/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.Expression;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.parameter.Parameter;

public class ParameterExpression
implements Expression {
    private final String parameterName;
    private final boolean allowSensitiveParameterReference;

    public ParameterExpression(String parameterName, boolean allowSensitiveParameterReference) {
        this.parameterName = parameterName;
        this.allowSensitiveParameterReference = allowSensitiveParameterReference;
    }

    @Override
    public String evaluate(EvaluationContext evaluationContext, AttributeValueDecorator decorator) {
        Parameter parameter = evaluationContext.getParameter(this.parameterName);
        if (parameter == null) {
            return null;
        }
        if (!this.allowSensitiveParameterReference && parameter.getDescriptor().isSensitive()) {
            return null;
        }
        return parameter.getValue();
    }

    @Override
    public String getExpression() {
        return "#{" + this.parameterName + "}";
    }
}

