/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class IsJsonEvaluator
extends BooleanEvaluator {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Evaluator<String> subject;

    public IsJsonEvaluator(Evaluator<String> subject) {
        this.subject = subject;
    }

    @Override
    public QueryResult<Boolean> evaluate(EvaluationContext evaluationContext) {
        String trimmedSubjectValue;
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue != null && (this.isPossibleJsonArray(trimmedSubjectValue = subjectValue.trim()) || this.isPossibleJsonObject(trimmedSubjectValue))) {
            try {
                MAPPER.readTree(trimmedSubjectValue);
                return new BooleanQueryResult(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new BooleanQueryResult(false);
    }

    private boolean isPossibleJsonArray(String subject) {
        return subject.startsWith("[") && subject.endsWith("]");
    }

    private boolean isPossibleJsonObject(String subject) {
        return subject.startsWith("{") && subject.endsWith("}");
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

