/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class SubstringBeforeEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> beforeEvaluator;

    public SubstringBeforeEvaluator(Evaluator<String> subject, Evaluator<String> beforeEvaluator) {
        this.subject = subject;
        this.beforeEvaluator = beforeEvaluator;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult("");
        }
        String beforeValue = this.beforeEvaluator.evaluate(evaluationContext).getValue();
        if (beforeValue == null || beforeValue.length() == 0) {
            return new StringQueryResult(subjectValue);
        }
        int index = subjectValue.indexOf(beforeValue);
        if (index < 0) {
            return new StringQueryResult(subjectValue);
        }
        return new StringQueryResult(subjectValue.substring(0, index));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

