/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MROutputFiles;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestMapRed
extends Configured
implements Tool {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), "TestMapRed-mapred");
    private static int range = 10;
    private static int counts = 100;
    private static Random r = new Random();

    @After
    public void cleanup() {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    @Test
    public void testMapred() throws Exception {
        this.launch();
    }

    @Test
    public void testNullKeys() throws Exception {
        JobConf conf = new JobConf(TestMapRed.class);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> values = new HashSet<String>();
        String m = "AAAAAAAAAAAAAA";
        for (int i = 1; i < 11; ++i) {
            values.add(m);
            m = m.replace((char)(65 + i - 1), (char)(65 + i));
        }
        Path testdir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)fs);
        fs.delete(testdir, true);
        Path inFile = new Path(testdir, "nullin/blah");
        SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)inFile, NullWritable.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        Text t = new Text();
        for (String s : values) {
            t.set(s);
            w.append((Writable)NullWritable.get(), (Writable)t);
        }
        w.close();
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inFile});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(testdir, "nullout"));
        conf.setMapperClass(NullMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setNumReduceTasks(1);
        conf.set("mapreduce.framework.name", "local");
        JobClient.runJob((JobConf)conf);
        SequenceFile.Reader r = new SequenceFile.Reader((FileSystem)fs, new Path(testdir, "nullout/part-00000"), (Configuration)conf);
        m = "AAAAAAAAAAAAAA";
        int i = 1;
        while (r.next((Writable)NullWritable.get(), (Writable)t)) {
            Assert.assertTrue((String)("Unexpected value: " + t), (boolean)values.remove(t.toString()));
            m = m.replace((char)(65 + i - 1), (char)(65 + i));
            ++i;
        }
        Assert.assertTrue((String)("Missing values: " + values.toString()), (boolean)values.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCompression(boolean compressMapOutputs, SequenceFile.CompressionType redCompression, boolean includeCombine) throws Exception {
        JobConf conf = new JobConf(TestMapRed.class);
        Path testdir = new Path(TEST_DIR.getAbsolutePath());
        Path inDir = new Path(testdir, "in");
        Path outDir = new Path(testdir, "out");
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(testdir, true);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setMapperClass(MyMap.class);
        conf.setReducerClass(MyReduce.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.set("mapreduce.framework.name", "local");
        if (includeCombine) {
            conf.setCombinerClass(IdentityReducer.class);
        }
        conf.setCompressMapOutput(compressMapOutputs);
        SequenceFileOutputFormat.setOutputCompressionType((JobConf)conf, (SequenceFile.CompressionType)redCompression);
        try {
            if (!fs.mkdirs(testdir)) {
                throw new IOException("Mkdirs failed to create " + testdir.toString());
            }
            if (!fs.mkdirs(inDir)) {
                throw new IOException("Mkdirs failed to create " + inDir.toString());
            }
            Path inFile = new Path(inDir, "part0");
            FSDataOutputStream f = fs.create(inFile);
            f.writeBytes("Owen was here\n");
            f.writeBytes("Hadoop is fun\n");
            f.writeBytes("Is this done, yet?\n");
            f.close();
            RunningJob rj = JobClient.runJob((JobConf)conf);
            Assert.assertTrue((String)"job was complete", (boolean)rj.isComplete());
            Assert.assertTrue((String)"job was successful", (boolean)rj.isSuccessful());
            Path output = new Path(outDir, Task.getOutputName((int)0));
            Assert.assertTrue((String)("reduce output exists " + output), (boolean)fs.exists(output));
            SequenceFile.Reader rdr = new SequenceFile.Reader(fs, output, (Configuration)conf);
            Assert.assertEquals((String)("is reduce output compressed " + output), (Object)(redCompression != SequenceFile.CompressionType.NONE ? 1 : 0), (Object)rdr.isCompressed());
            rdr.close();
        }
        finally {
            fs.delete(testdir, true);
        }
    }

    @Test
    public void testCompression() throws Exception {
        EnumSet<SequenceFile.CompressionType> seq = EnumSet.allOf(SequenceFile.CompressionType.class);
        for (SequenceFile.CompressionType redCompression : seq) {
            for (int combine = 0; combine < 2; ++combine) {
                this.checkCompression(false, redCompression, combine == 1);
                this.checkCompression(true, redCompression, combine == 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() throws Exception {
        Path testdir;
        FileSystem fs;
        JobConf conf = this.getConf() == null ? new JobConf() : new JobConf(this.getConf());
        conf.set("mapreduce.framework.name", "local");
        conf.setJarByClass(TestMapRed.class);
        int countsToGo = counts;
        int[] dist = new int[range];
        for (int i = 0; i < range; ++i) {
            double avgInts = 1.0 * (double)countsToGo / (double)(range - i);
            dist[i] = (int)Math.max(0L, Math.round(avgInts + Math.sqrt(avgInts) * r.nextGaussian()));
            countsToGo -= dist[i];
        }
        if (countsToGo > 0) {
            int n = dist.length - 1;
            dist[n] = dist[n] + countsToGo;
        }
        if (!(fs = FileSystem.get((Configuration)conf)).mkdirs(testdir = new Path(TEST_DIR.getAbsolutePath(), "mapred.loadtest"))) {
            throw new IOException("Mkdirs failed to create " + testdir.toString());
        }
        Path randomIns = new Path(testdir, "genins");
        if (!fs.mkdirs(randomIns)) {
            throw new IOException("Mkdirs failed to create " + randomIns.toString());
        }
        Path answerkey = new Path(randomIns, "answer.key");
        try (SequenceFile.Writer out = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)answerkey, IntWritable.class, IntWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
            for (int i = 0; i < range; ++i) {
                out.append((Writable)new IntWritable(i), (Writable)new IntWritable(dist[i]));
            }
        }
        Path randomOuts = new Path(testdir, "genouts");
        fs.delete(randomOuts, true);
        JobConf genJob = new JobConf((Configuration)conf, TestMapRed.class);
        FileInputFormat.setInputPaths((JobConf)genJob, (Path[])new Path[]{randomIns});
        genJob.setInputFormat(SequenceFileInputFormat.class);
        genJob.setMapperClass(RandomGenMapper.class);
        FileOutputFormat.setOutputPath((JobConf)genJob, (Path)randomOuts);
        genJob.setOutputKeyClass(IntWritable.class);
        genJob.setOutputValueClass(IntWritable.class);
        genJob.setOutputFormat(TextOutputFormat.class);
        genJob.setReducerClass(RandomGenReducer.class);
        genJob.setNumReduceTasks(1);
        JobClient.runJob((JobConf)genJob);
        int intermediateReduces = 10;
        Path intermediateOuts = new Path(testdir, "intermediateouts");
        fs.delete(intermediateOuts, true);
        JobConf checkJob = new JobConf((Configuration)conf, TestMapRed.class);
        FileInputFormat.setInputPaths((JobConf)checkJob, (Path[])new Path[]{randomOuts});
        checkJob.setInputFormat(TextInputFormat.class);
        checkJob.setMapperClass(RandomCheckMapper.class);
        FileOutputFormat.setOutputPath((JobConf)checkJob, (Path)intermediateOuts);
        checkJob.setOutputKeyClass(IntWritable.class);
        checkJob.setOutputValueClass(IntWritable.class);
        checkJob.setOutputFormat(MapFileOutputFormat.class);
        checkJob.setReducerClass(RandomCheckReducer.class);
        checkJob.setNumReduceTasks(intermediateReduces);
        JobClient.runJob((JobConf)checkJob);
        Path finalOuts = new Path(testdir, "finalouts");
        fs.delete(finalOuts, true);
        JobConf mergeJob = new JobConf((Configuration)conf, TestMapRed.class);
        FileInputFormat.setInputPaths((JobConf)mergeJob, (Path[])new Path[]{intermediateOuts});
        mergeJob.setInputFormat(SequenceFileInputFormat.class);
        mergeJob.setMapperClass(MergeMapper.class);
        FileOutputFormat.setOutputPath((JobConf)mergeJob, (Path)finalOuts);
        mergeJob.setOutputKeyClass(IntWritable.class);
        mergeJob.setOutputValueClass(IntWritable.class);
        mergeJob.setOutputFormat(SequenceFileOutputFormat.class);
        mergeJob.setReducerClass(MergeReducer.class);
        mergeJob.setNumReduceTasks(1);
        JobClient.runJob((JobConf)mergeJob);
        boolean success = true;
        Path recomputedkey = new Path(finalOuts, "part-00000");
        int totalseen = 0;
        try (SequenceFile.Reader in = new SequenceFile.Reader(fs, recomputedkey, (Configuration)conf);){
            IntWritable key = new IntWritable();
            IntWritable val = new IntWritable();
            for (int i = 0; i < range; ++i) {
                if (dist[i] == 0) continue;
                if (!in.next((Writable)key, (Writable)val)) {
                    System.err.println("Cannot read entry " + i);
                    success = false;
                    break;
                }
                if (key.get() != i || val.get() != dist[i]) {
                    System.err.println("Mismatch!  Pos=" + key.get() + ", i=" + i + ", val=" + val.get() + ", dist[i]=" + dist[i]);
                    success = false;
                }
                totalseen += val.get();
            }
            if (success && in.next((Writable)key, (Writable)val)) {
                System.err.println("Unnecessary lines in recomputed key!");
                success = false;
            }
        }
        int originalTotal = 0;
        for (int aDist : dist) {
            originalTotal += aDist;
        }
        System.out.println("Original sum: " + originalTotal);
        System.out.println("Recomputed sum: " + totalseen);
        Path resultFile = new Path(testdir, "results");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resultFile)));){
            bw.write("Success=" + success + "\n");
            System.out.println("Success=" + success);
        }
        Assert.assertTrue((String)"testMapRed failed", (boolean)success);
        fs.delete(testdir, true);
    }

    private static void printTextFile(FileSystem fs, Path p) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(p)));
        while ((line = in.readLine()) != null) {
            System.out.println("  Row: " + line);
        }
        in.close();
    }

    private static void printSequenceFile(FileSystem fs, Path p, Configuration conf) throws IOException {
        SequenceFile.Reader r = new SequenceFile.Reader(fs, p, conf);
        Object key = null;
        Object value = null;
        while ((key = r.next(key)) != null) {
            value = r.getCurrentValue(value);
            System.out.println("  Row: " + key + ", " + value);
        }
        r.close();
    }

    private static boolean isSequenceFile(FileSystem fs, Path f) throws IOException {
        FSDataInputStream in = fs.open(f);
        byte[] seq = "SEQ".getBytes();
        for (int i = 0; i < seq.length; ++i) {
            if (seq[i] == in.read()) continue;
            return false;
        }
        return true;
    }

    private static void printFiles(Path dir, Configuration conf) throws IOException {
        FileSystem fs = dir.getFileSystem(conf);
        for (FileStatus f : fs.listStatus(dir)) {
            System.out.println("Reading " + f.getPath() + ": ");
            if (f.isDirectory()) {
                System.out.println("  it is a map file.");
                TestMapRed.printSequenceFile(fs, new Path(f.getPath(), "data"), conf);
                continue;
            }
            if (TestMapRed.isSequenceFile(fs, f.getPath())) {
                System.out.println("  it is a sequence file.");
                TestMapRed.printSequenceFile(fs, f.getPath(), conf);
                continue;
            }
            System.out.println("  it is a text file.");
            TestMapRed.printTextFile(fs, f.getPath());
        }
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new TestMapRed(), (String[])argv);
        System.exit(res);
    }

    @Test
    public void testSmallInput() {
        this.runJob(100);
    }

    @Test
    public void testBiggerInput() {
        this.runJob(1000);
    }

    public void runJob(int items) {
        try {
            JobConf conf = new JobConf(TestMapRed.class);
            Path testdir = new Path(TEST_DIR.getAbsolutePath());
            Path inDir = new Path(testdir, "in");
            Path outDir = new Path(testdir, "out");
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.delete(testdir, true);
            conf.setInt("mapreduce.task.io.sort.mb", 1);
            conf.setInputFormat(SequenceFileInputFormat.class);
            FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
            conf.setMapperClass(IdentityMapper.class);
            conf.setReducerClass(IdentityReducer.class);
            conf.setOutputKeyClass(Text.class);
            conf.setOutputValueClass(Text.class);
            conf.setOutputFormat(SequenceFileOutputFormat.class);
            conf.set("mapreduce.framework.name", "local");
            if (!fs.mkdirs(testdir)) {
                throw new IOException("Mkdirs failed to create " + testdir.toString());
            }
            if (!fs.mkdirs(inDir)) {
                throw new IOException("Mkdirs failed to create " + inDir.toString());
            }
            Path inFile = new Path(inDir, "part0");
            SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)inFile, Text.class, Text.class);
            StringBuffer content = new StringBuffer();
            for (int i = 0; i < 1000; ++i) {
                content.append(i).append(": This is one more line of content\n");
            }
            Text text = new Text(content.toString());
            for (int i = 0; i < items; ++i) {
                writer.append((Writable)new Text("rec:" + i), (Writable)text);
            }
            writer.close();
            JobClient.runJob((JobConf)conf);
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Threw exception:" + e), (boolean)false);
        }
    }

    public int run(String[] argv) throws Exception {
        if (argv.length < 2) {
            System.err.println("Usage: TestMapRed <range> <counts>");
            System.err.println();
            System.err.println("Note: a good test will have a <counts> value that is substantially larger than the <range>");
            return -1;
        }
        int i = 0;
        range = Integer.parseInt(argv[i++]);
        counts = Integer.parseInt(argv[i++]);
        this.launch();
        return 0;
    }

    public static class NullMapper
    implements Mapper<NullWritable, Text, NullWritable, Text> {
        public void map(NullWritable key, Text val, OutputCollector<NullWritable, Text> output, Reporter reporter) throws IOException {
            output.collect((Object)NullWritable.get(), (Object)val);
        }

        public void configure(JobConf conf) {
        }

        public void close() {
        }
    }

    private static class MyReduce
    extends IdentityReducer {
        private JobConf conf;
        private boolean compressInput;
        private boolean first = true;

        private MyReduce() {
        }

        public void configure(JobConf conf) {
            this.conf = conf;
            this.compressInput = conf.getCompressMapOutput();
        }

        public void reduce(WritableComparable key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
            if (this.first) {
                this.first = false;
                MROutputFiles mapOutputFile = new MROutputFiles();
                mapOutputFile.setConf((Configuration)this.conf);
                Path input = mapOutputFile.getInputFile(0);
                FileSystem fs = FileSystem.get((Configuration)this.conf);
                Assert.assertTrue((String)("reduce input exists " + input), (boolean)fs.exists(input));
                SequenceFile.Reader rdr = new SequenceFile.Reader(fs, input, (Configuration)this.conf);
                Assert.assertEquals((String)("is reduce input compressed " + input), (Object)this.compressInput, (Object)rdr.isCompressed());
                rdr.close();
            }
        }
    }

    private static class MyMap
    implements Mapper<WritableComparable, Text, Text, Text> {
        private MyMap() {
        }

        public void configure(JobConf conf) {
        }

        public void map(WritableComparable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            String str = StringUtils.toLowerCase((String)value.toString());
            output.collect((Object)new Text(str), (Object)value);
        }

        public void close() throws IOException {
        }
    }

    static class MergeReducer
    implements Reducer<IntWritable, IntWritable, IntWritable, IntWritable> {
        MergeReducer() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<IntWritable> it, OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            int keyint = key.get();
            int total = 0;
            while (it.hasNext()) {
                total += it.next().get();
            }
            out.collect((Object)new IntWritable(keyint), (Object)new IntWritable(total));
        }

        public void close() {
        }
    }

    static class MergeMapper
    implements Mapper<IntWritable, IntWritable, IntWritable, IntWritable> {
        MergeMapper() {
        }

        public void configure(JobConf job) {
        }

        public void map(IntWritable key, IntWritable val, OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            int keyint = key.get();
            int valint = val.get();
            out.collect((Object)new IntWritable(keyint), (Object)new IntWritable(valint));
        }

        public void close() {
        }
    }

    static class RandomCheckReducer
    implements Reducer<IntWritable, IntWritable, IntWritable, IntWritable> {
        RandomCheckReducer() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<IntWritable> it, OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            int keyint = key.get();
            int count = 0;
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            out.collect((Object)new IntWritable(keyint), (Object)new IntWritable(count));
        }

        public void close() {
        }
    }

    static class RandomCheckMapper
    implements Mapper<WritableComparable, Text, IntWritable, IntWritable> {
        RandomCheckMapper() {
        }

        public void configure(JobConf job) {
        }

        public void map(WritableComparable key, Text val, OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            out.collect((Object)new IntWritable(Integer.parseInt(val.toString().trim())), (Object)new IntWritable(1));
        }

        public void close() {
        }
    }

    static class RandomGenReducer
    implements Reducer<IntWritable, IntWritable, IntWritable, IntWritable> {
        RandomGenReducer() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<IntWritable> it, OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            while (it.hasNext()) {
                out.collect((Object)it.next(), null);
            }
        }

        public void close() {
        }
    }

    static class RandomGenMapper
    implements Mapper<IntWritable, IntWritable, IntWritable, IntWritable> {
        RandomGenMapper() {
        }

        public void configure(JobConf job) {
        }

        public void map(IntWritable key, IntWritable val, OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            int randomVal = key.get();
            int randomCount = val.get();
            for (int i = 0; i < randomCount; ++i) {
                out.collect((Object)new IntWritable(Math.abs(r.nextInt())), (Object)new IntWritable(randomVal));
            }
        }

        public void close() {
        }
    }
}

