/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.history;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.history.HiveHistory;

public class HiveHistoryUtil {
    private static final String KEY = "(\\w+)";
    private static final String VALUE = "[[^\"]?]+";
    private static final Pattern pattern = Pattern.compile("(\\w+)=\"[[^\"]?]+\"");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseHiveHistory(String path, HiveHistory.Listener l) throws IOException {
        if (path == null) {
            return;
        }
        FileInputStream fi = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(fi));
        try {
            String line = null;
            StringBuilder buf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                if (!line.trim().endsWith("\"")) continue;
                HiveHistoryUtil.parseLine(buf.toString(), l);
                buf = new StringBuilder();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {}
        }
    }

    private static void parseLine(String line, HiveHistory.Listener l) throws IOException {
        HashMap<String, String> parseBuffer = new HashMap<String, String>();
        int idx = line.indexOf(32);
        String recType = line.substring(0, idx);
        String data = line.substring(idx + 1, line.length());
        Matcher matcher = pattern.matcher(data);
        while (matcher.find()) {
            String tuple = matcher.group(0);
            String[] parts = tuple.split("=");
            parseBuffer.put(parts[0], parts[1].substring(1, parts[1].length() - 1));
        }
        l.handle(HiveHistory.RecordTypes.valueOf(recType), parseBuffer);
    }
}

