/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateString;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="to_date", value="_FUNC_(expr) - Extracts the date part of the date or datetime expression expr", extended="Example:\n   > SELECT _FUNC_('2009-07-30 04:17:52') FROM src LIMIT 1;\n  '2009-07-30'")
@VectorizedExpressions(value={VectorUDFDateString.class, VectorUDFDateLong.class})
public class GenericUDFDate
extends GenericUDF {
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private transient PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private transient ObjectInspectorConverters.Converter textConverter;
    private transient ObjectInspectorConverters.Converter dateWritableConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType;
    private transient PrimitiveObjectInspector argumentOI;
    private final Text output = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("to_date() requires 1 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("to_date() only accepts STRING/TIMESTAMP/DATEWRITABLE types, got " + arguments[0].getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        this.inputType = this.argumentOI.getPrimitiveCategory();
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        switch (this.inputType) {
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                this.inputType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.textConverter = ObjectInspectorConverters.getConverter((ObjectInspector)this.argumentOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter(this.argumentOI, (SettableTimestampObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                this.dateWritableConverter = ObjectInspectorConverters.getConverter((ObjectInspector)this.argumentOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException("TO_DATE() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + this.inputType);
            }
        }
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        switch (this.inputType) {
            case STRING: {
                Date date;
                String dateString = this.textConverter.convert(arguments[0].get()).toString();
                try {
                    date = this.formatter.parse(dateString);
                }
                catch (ParseException e) {
                    return null;
                }
                this.output.set(this.formatter.format(date));
                break;
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampWritable)this.timestampConverter.convert(arguments[0].get())).getTimestamp();
                this.output.set(this.formatter.format(ts));
                break;
            }
            case DATE: {
                DateWritable dw = (DateWritable)this.dateWritableConverter.convert(arguments[0].get());
                this.output.set(this.formatter.format(dw.get()));
                break;
            }
            default: {
                throw new UDFArgumentException("TO_DATE() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + this.inputType);
            }
        }
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("to_date", children);
    }
}

