/*
 * Decompiled with CFR 0.152.
 */
package junit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class TestCaseClassLoader
extends ClassLoader {
    private String[] fPathItems;
    private String[] fExcluded = new String[]{"com.sun.", "sun."};
    static final String EXCLUDED_FILE = "excluded.properties";

    public TestCaseClassLoader() {
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n;
        }
        this.fPathItems = new String[n];
        stringTokenizer = new StringTokenizer(string, string2);
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.fPathItems[n++] = stringTokenizer.nextToken();
        }
        String[] stringArray = this.readExcludedPackages();
        if (stringArray != null) {
            this.fExcluded = stringArray;
        }
    }

    public URL getResource(String string) {
        return ClassLoader.getSystemResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        return ClassLoader.getSystemResourceAsStream(string);
    }

    protected boolean isExcluded(String string) {
        if (string.startsWith("java.") || string.startsWith("junit.framework") || string.startsWith("junit.extensions") || string.startsWith("junit.util") || string.startsWith("junit.ui")) {
            return true;
        }
        int n = 0;
        while (n < this.fExcluded.length) {
            if (string.startsWith(this.fExcluded[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.isExcluded(string)) {
            try {
                clazz = this.findSystemClass(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            File file = this.locate(string);
            if (file == null) {
                throw new ClassNotFoundException();
            }
            byte[] byArray = this.loadClassData(file);
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private byte[] loadClassData(File file) throws ClassNotFoundException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClassNotFoundException();
        }
    }

    private File locate(String string) {
        string = String.valueOf(string.replace('.', '/')) + ".class";
        File file = null;
        if (string != null) {
            int n = 0;
            while (n < this.fPathItems.length) {
                file = new File(this.fPathItems[n], string);
                if (file.exists()) {
                    return file;
                }
                ++n;
            }
        }
        return null;
    }

    private String[] readExcludedPackages() {
        Object object;
        InputStream inputStream = this.getClass().getResourceAsStream(EXCLUDED_FILE);
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<String> vector = new Vector<String>(10);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith("excluded.")) continue;
            String string = properties.getProperty((String)object);
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() <= 0) continue;
            vector.addElement(string);
        }
        object = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            object[n] = (String)vector.elementAt(n);
            ++n;
        }
        return object;
    }
}

