/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.AvailableSpaceBlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.PathUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAvailableSpaceBlockPlacementPolicy {
    private static final int numRacks = 4;
    private static final int nodesPerRack = 5;
    private static final int blockSize = 1024;
    private static final int chooseTimes = 10000;
    private static final String file = "/tobers/test";
    private static final int replica = 3;
    private static DatanodeStorageInfo[] storages;
    private static DatanodeDescriptor[] dataNodes;
    private static Configuration conf;
    private static NameNode namenode;
    private static BlockPlacementPolicy placementPolicy;
    private static NetworkTopology cluster;

    @BeforeClass
    public static void setupCluster() throws Exception {
        conf = new HdfsConfiguration();
        conf.setFloat("dfs.namenode.available-space-block-placement-policy.balanced-space-preference-fraction", 0.6f);
        String[] racks = new String[4];
        for (int i = 0; i < 4; ++i) {
            racks[i] = "/rack" + i;
        }
        String[] owerRackOfNodes = new String[20];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                owerRackOfNodes[i * 4 + j] = racks[j];
            }
        }
        storages = DFSTestUtil.createDatanodeStorageInfos(owerRackOfNodes);
        dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        File baseDir = PathUtils.getTestDir(AvailableSpaceBlockPlacementPolicy.class);
        conf.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
        conf.set("dfs.block.replicator.classname", AvailableSpaceBlockPlacementPolicy.class.getName());
        DFSTestUtil.formatNameNode(conf);
        namenode = new NameNode(conf);
        BlockManager bm = namenode.getNamesystem().getBlockManager();
        placementPolicy = bm.getBlockPlacementPolicy();
        cluster = bm.getDatanodeManager().getNetworkTopology();
        for (int i = 0; i < 20; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
        TestAvailableSpaceBlockPlacementPolicy.setupDataNodeCapacity();
    }

    private static void updateHeartbeatWithUsage(DatanodeDescriptor dn, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long dnCacheCapacity, long dnCacheUsed, int xceiverCount, int volFailures) {
        dn.getStorageInfos()[0].setUtilizationForTesting(capacity, dfsUsed, remaining, blockPoolUsed);
        dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), dnCacheCapacity, dnCacheUsed, xceiverCount, volFailures, null);
    }

    private static void setupDataNodeCapacity() {
        for (int i = 0; i < 20; ++i) {
            if (i % 2 == 0) {
                TestAvailableSpaceBlockPlacementPolicy.updateHeartbeatWithUsage(dataNodes[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
                continue;
            }
            TestAvailableSpaceBlockPlacementPolicy.updateHeartbeatWithUsage(dataNodes[i], 2048L, 1024L, 1024L, 0L, 0L, 0L, 0, 0);
        }
    }

    @Test
    public void testPolicyReplacement() {
        Assert.assertTrue((boolean)(placementPolicy instanceof AvailableSpaceBlockPlacementPolicy));
    }

    @Test
    public void testChooseTarget() {
        int total = 0;
        int moreRemainingNode = 0;
        for (int i = 0; i < 10000; ++i) {
            DatanodeStorageInfo[] targets = namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget(file, 3, null, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assert.assertTrue((targets.length == 3 ? 1 : 0) != 0);
            for (int j = 0; j < 3; ++j) {
                ++total;
                if (!(targets[j].getDatanodeDescriptor().getRemainingPercent() > 60.0f)) continue;
                ++moreRemainingNode;
            }
        }
        Assert.assertTrue((total == 30000 ? 1 : 0) != 0);
        double possibility = 1.0 * (double)moreRemainingNode / (double)total;
        Assert.assertTrue((possibility > 0.52 ? 1 : 0) != 0);
        Assert.assertTrue((possibility < 0.55 ? 1 : 0) != 0);
    }

    @Test
    public void testChooseDataNode() {
        try {
            ArrayList allNodes = new ArrayList(dataNodes.length);
            Collections.addAll(allNodes, dataNodes);
            if (placementPolicy instanceof AvailableSpaceBlockPlacementPolicy) {
                ((AvailableSpaceBlockPlacementPolicy)placementPolicy).chooseDataNode("~", allNodes);
            }
        }
        catch (NullPointerException npe) {
            Assert.fail((String)"NPE should not be thrown");
        }
    }

    @AfterClass
    public static void teardownCluster() {
        if (namenode != null) {
            namenode.stop();
        }
    }
}

