/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import org.apache.tez.dag.records.DagIdentifierImpl;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.DagIdentifier;
import org.apache.tez.runtime.api.VertexIdentifier;

public class VertexIdentifierImpl
implements VertexIdentifier {
    private final DagIdentifier dagIdentifier;
    private final TezVertexID vertexId;
    private final String vertexName;

    public VertexIdentifierImpl(String dagName, String vertexName, TezVertexID vertexId) {
        this.vertexId = vertexId;
        this.vertexName = vertexName;
        this.dagIdentifier = new DagIdentifierImpl(dagName, vertexId.getDAGId());
    }

    public String getName() {
        return this.vertexName;
    }

    public int getIdentifier() {
        return this.vertexId.getId();
    }

    public DagIdentifier getDagIdentifier() {
        return this.dagIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            VertexIdentifierImpl other = (VertexIdentifierImpl)o;
            return this.vertexId.equals(other.vertexId);
        }
        return false;
    }

    public String toString() {
        return this.dagIdentifier.toString() + " Vertex: " + this.vertexName + ":[" + this.getIdentifier() + "]";
    }

    public int hashCode() {
        return this.vertexId.hashCode();
    }
}

