/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputUpdatePayloadEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootInputVertexManager
extends VertexManagerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RootInputVertexManager.class);
    public static final String TEZ_ROOT_INPUT_VERTEX_MANAGER_ENABLE_SLOW_START = "tez.root-input-vertex-manager.enable.slow-start";
    public static final boolean TEZ_ROOT_INPUT_VERTEX_MANAGER_ENABLE_SLOW_START_DEFAULT = false;
    public static final String TEZ_ROOT_INPUT_VERTEX_MANAGER_MIN_SRC_FRACTION = "tez.root-input-vertex-manager.min-src-fraction";
    public static final float TEZ_ROOT_INPUT_VERTEX_MANAGER_MIN_SRC_FRACTION_DEFAULT = 0.25f;
    public static final String TEZ_ROOT_INPUT_VERTEX_MANAGER_MAX_SRC_FRACTION = "tez.root-input-vertex-manager.max-src-fraction";
    public static final float TEZ_ROOT_INPUT_VERTEX_MANAGER_MAX_SRC_FRACTION_DEFAULT = 0.75f;
    private String configuredInputName;
    int totalNumSourceTasks = 0;
    int numSourceTasksCompleted = 0;
    private AtomicBoolean onVertexStartedDone = new AtomicBoolean(false);
    private final Map<String, SourceVertexInfo> srcVertexInfo = new ConcurrentHashMap<String, SourceVertexInfo>();
    boolean sourceVerticesScheduled = false;
    List<PendingTaskInfo> pendingTasks = Lists.newLinkedList();
    int totalTasksToSchedule = 0;
    boolean slowStartEnabled = false;
    float slowStartMinFraction = 0.0f;
    float slowStartMaxFraction = 0.0f;
    @VisibleForTesting
    Configuration conf;

    SourceVertexInfo createSourceVertexInfo(EdgeProperty edgeProperty, int numTasks) {
        return new SourceVertexInfo(edgeProperty, numTasks);
    }

    public RootInputVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    public void onVertexStarted(List<TaskAttemptIdentifier> completions) {
        Map edges = this.getContext().getInputVertexEdgeProperties();
        for (Map.Entry entry : edges.entrySet()) {
            String srcVertex = (String)entry.getKey();
            int numTasks = this.getContext().getVertexNumTasks(srcVertex);
            if (numTasks > 0) {
                LOG.info("Task count in " + srcVertex + ": " + numTasks);
                this.srcVertexInfo.put(srcVertex, this.createSourceVertexInfo((EdgeProperty)entry.getValue(), this.getContext().getVertexNumTasks(this.getContext().getVertexName())));
                this.getContext().registerForVertexStateUpdates(srcVertex, EnumSet.of(VertexState.CONFIGURED));
                continue;
            }
            LOG.info("Vertex: " + this.getContext().getVertexName() + "; Ignoring " + srcVertex + " as it has " + numTasks + " tasks");
        }
        if (completions != null) {
            for (TaskAttemptIdentifier attempt : completions) {
                this.onSourceTaskCompleted(attempt);
            }
        }
        this.onVertexStartedDone.set(true);
        this.updatePendingTasks();
        this.processPendingTasks();
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) {
        Preconditions.checkArgument((stateUpdate.getVertexState() == VertexState.CONFIGURED ? 1 : 0) != 0, (Object)("Received incorrect state notification : " + stateUpdate.getVertexState() + " for vertex: " + stateUpdate.getVertexName() + " in vertex: " + this.getContext().getVertexName()));
        SourceVertexInfo vInfo = this.srcVertexInfo.get(stateUpdate.getVertexName());
        if (vInfo != null) {
            Preconditions.checkState((!vInfo.vertexIsConfigured ? 1 : 0) != 0);
            vInfo.vertexIsConfigured = true;
            vInfo.numTasks = this.getContext().getVertexNumTasks(stateUpdate.getVertexName());
            this.totalNumSourceTasks += vInfo.numTasks;
            LOG.info("Received configured notification : {} for vertex: {} in vertex: {} numjourceTasks: {}", new Object[]{stateUpdate.getVertexState(), stateUpdate.getVertexName(), this.getContext().getVertexName(), this.totalNumSourceTasks});
            this.processPendingTasks();
        }
    }

    public void onSourceTaskCompleted(TaskAttemptIdentifier attempt) {
        BitSet completedSourceTasks;
        String srcVertexName = attempt.getTaskIdentifier().getVertexIdentifier().getName();
        int srcTaskId = attempt.getTaskIdentifier().getIdentifier();
        SourceVertexInfo srcInfo = this.srcVertexInfo.get(srcVertexName);
        if (srcInfo.vertexIsConfigured) {
            Preconditions.checkState((srcTaskId < srcInfo.numTasks ? 1 : 0) != 0, (Object)("Received completion for srcTaskId " + srcTaskId + " but Vertex: " + srcVertexName + " has only " + srcInfo.numTasks + " tasks"));
        }
        if (!(completedSourceTasks = srcInfo.finishedTaskSet).get(srcTaskId)) {
            completedSourceTasks.set(srcTaskId);
            ++this.numSourceTasksCompleted;
        }
        this.processPendingTasks();
    }

    public void initialize() {
        UserPayload userPayload = this.getContext().getUserPayload();
        if (userPayload == null || userPayload.getPayload() == null || userPayload.getPayload().limit() == 0) {
            throw new RuntimeException("Could not initialize RootInputVertexManager from provided user payload");
        }
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)userPayload);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize RootInputVertexManager from provided user payload", e);
        }
        this.slowStartEnabled = this.conf.getBoolean(TEZ_ROOT_INPUT_VERTEX_MANAGER_ENABLE_SLOW_START, false);
        if (this.slowStartEnabled) {
            this.slowStartMinFraction = this.conf.getFloat(TEZ_ROOT_INPUT_VERTEX_MANAGER_MIN_SRC_FRACTION, 0.25f);
            this.slowStartMaxFraction = this.conf.getFloat(TEZ_ROOT_INPUT_VERTEX_MANAGER_MAX_SRC_FRACTION, Math.max(this.slowStartMinFraction, 0.75f));
        } else {
            this.slowStartMinFraction = 0.0f;
            this.slowStartMaxFraction = 0.0f;
        }
        if (this.slowStartMinFraction < 0.0f || this.slowStartMaxFraction > 1.0f || this.slowStartMaxFraction < this.slowStartMinFraction) {
            throw new IllegalArgumentException("Invalid values for slowStartMinFraction/slowStartMaxFraction. Min cannot be < 0, max cannot be > 1, and max cannot be < min., configuredMin=" + this.slowStartMinFraction + ", configuredMax=" + this.slowStartMaxFraction);
        }
        this.updatePendingTasks();
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
        LinkedList riEvents = Lists.newLinkedList();
        boolean dataInformationEventSeen = false;
        for (Event event : events) {
            if (event instanceof InputConfigureVertexTasksEvent) {
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                Preconditions.checkState((this.getContext().getVertexNumTasks(this.getContext().getVertexName()) == -1 ? 1 : 0) != 0, (Object)("Parallelism for the vertex should be set to -1 if the InputInitializer is setting parallelism, VertexName: " + this.getContext().getVertexName()));
                Preconditions.checkState((this.configuredInputName == null ? 1 : 0) != 0, (Object)("RootInputVertexManager cannot configure multiple inputs. Use a custom VertexManager, VertexName: " + this.getContext().getVertexName() + ", ConfiguredInput: " + this.configuredInputName + ", CurrentInput: " + inputName));
                this.configuredInputName = inputName;
                InputConfigureVertexTasksEvent cEvent = (InputConfigureVertexTasksEvent)event;
                HashMap<String, InputSpecUpdate> rootInputSpecUpdate = new HashMap<String, InputSpecUpdate>();
                rootInputSpecUpdate.put(inputName, cEvent.getInputSpecUpdate() == null ? InputSpecUpdate.getDefaultSinglePhysicalInputSpecUpdate() : cEvent.getInputSpecUpdate());
                this.getContext().reconfigureVertex(rootInputSpecUpdate, cEvent.getLocationHint(), cEvent.getNumTasks());
            }
            if (event instanceof InputUpdatePayloadEvent) {
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                inputDescriptor.setUserPayload(UserPayload.create((ByteBuffer)((InputUpdatePayloadEvent)event).getUserPayload()));
                continue;
            }
            if (!(event instanceof InputDataInformationEvent)) continue;
            dataInformationEventSeen = true;
            Preconditions.checkState((this.getContext().getVertexNumTasks(this.getContext().getVertexName()) != 0 ? 1 : 0) != 0);
            Preconditions.checkState((this.configuredInputName == null || this.configuredInputName.equals(inputName) ? 1 : 0) != 0, (Object)("RootInputVertexManager cannot configure multiple inputs. Use a custom VertexManager, VertexName:" + this.getContext().getVertexName() + ", ConfiguredInput: " + this.configuredInputName + ", CurrentInput: " + inputName));
            this.configuredInputName = inputName;
            InputDataInformationEvent rEvent = (InputDataInformationEvent)event;
            rEvent.setTargetIndex(rEvent.getSourceIndex());
            riEvents.add(rEvent);
        }
        this.getContext().addRootInputEvents(inputName, (Collection)riEvents);
    }

    private boolean canScheduleTasks() {
        for (Map.Entry<String, SourceVertexInfo> entry : this.srcVertexInfo.entrySet()) {
            if (entry.getValue().vertexIsConfigured) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting for vertex: " + entry.getKey() + " in vertex: " + this.getContext().getVertexName());
            }
            return false;
        }
        this.sourceVerticesScheduled = true;
        return this.sourceVerticesScheduled;
    }

    private boolean preconditionsSatisfied() {
        if (!this.onVertexStartedDone.get()) {
            return false;
        }
        if (!this.sourceVerticesScheduled && !this.canScheduleTasks()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Defer scheduling tasks for vertex: {} as one task needs to be completed per source vertex", (Object)this.getContext().getVertexName());
            }
            return false;
        }
        return true;
    }

    void updatePendingTasks() {
        int tasks = this.getContext().getVertexNumTasks(this.getContext().getVertexName());
        if (tasks == this.pendingTasks.size() || tasks <= 0) {
            return;
        }
        this.pendingTasks.clear();
        for (int i = 0; i < tasks; ++i) {
            this.pendingTasks.add(new PendingTaskInfo(i));
        }
        this.totalTasksToSchedule = this.pendingTasks.size();
    }

    private void processPendingTasks() {
        if (!this.preconditionsSatisfied()) {
            return;
        }
        this.schedulePendingTasks();
    }

    private void schedulePendingTasks() {
        List<VertexManagerPluginContext.ScheduleTaskRequest> scheduledTasks = this.getTasksToSchedule();
        if (scheduledTasks != null && scheduledTasks.size() > 0) {
            this.getContext().scheduleTasks(scheduledTasks);
        }
    }

    float getMinSourceVertexCompletedTaskFraction() {
        float minSourceVertexCompletedTaskFraction = 1.0f;
        if (this.numSourceTasksCompleted != this.totalNumSourceTasks) {
            for (Map.Entry<String, SourceVertexInfo> vInfo : this.srcVertexInfo.entrySet()) {
                int numCompletedTasks;
                float completedFraction;
                SourceVertexInfo srcInfo = vInfo.getValue();
                Preconditions.checkState((boolean)srcInfo.vertexIsConfigured, (Object)("Vertex: " + vInfo.getKey()));
                if (srcInfo.numTasks <= 0 || !(minSourceVertexCompletedTaskFraction > (completedFraction = (float)(numCompletedTasks = srcInfo.getNumCompletedTasks()) / (float)srcInfo.numTasks))) continue;
                minSourceVertexCompletedTaskFraction = completedFraction;
            }
        }
        return minSourceVertexCompletedTaskFraction;
    }

    List<VertexManagerPluginContext.ScheduleTaskRequest> getTasksToSchedule() {
        float minSourceVertexCompletedTaskFraction = this.getMinSourceVertexCompletedTaskFraction();
        int numTasksToSchedule = this.getNumOfTasksToScheduleAndLog(minSourceVertexCompletedTaskFraction);
        if (numTasksToSchedule > 0) {
            ArrayList tasksToSchedule = Lists.newArrayListWithCapacity((int)numTasksToSchedule);
            while (!this.pendingTasks.isEmpty() && numTasksToSchedule > 0) {
                --numTasksToSchedule;
                Integer taskIndex = this.pendingTasks.get(0).getIndex();
                tasksToSchedule.add(VertexManagerPluginContext.ScheduleTaskRequest.create((int)taskIndex, null));
                this.pendingTasks.remove(0);
            }
            return tasksToSchedule;
        }
        return null;
    }

    int getNumOfTasksToScheduleAndLog(float minFraction) {
        int numTasksToSchedule = this.getNumOfTasksToSchedule(minFraction);
        if (numTasksToSchedule > 0) {
            LOG.info("Scheduling {} tasks for vertex: {} with totalTasks: {}. {} source tasks completed out of {}. MinSourceTaskCompletedFraction: {} min: {} max: {}", new Object[]{numTasksToSchedule, this.getContext().getVertexName(), this.totalTasksToSchedule, this.numSourceTasksCompleted, this.totalNumSourceTasks, Float.valueOf(minFraction), Float.valueOf(this.slowStartMinFraction), Float.valueOf(this.slowStartMaxFraction)});
        }
        return numTasksToSchedule;
    }

    int getNumOfTasksToSchedule(float minSourceVertexCompletedTaskFraction) {
        int numPendingTasks = this.pendingTasks.size();
        if (this.numSourceTasksCompleted == this.totalNumSourceTasks) {
            LOG.info("All source tasks completed. Ramping up {} remaining tasks for vertex: {}", (Object)numPendingTasks, (Object)this.getContext().getVertexName());
            return numPendingTasks;
        }
        float tasksFractionToSchedule = 1.0f;
        float percentRange = this.slowStartMaxFraction - this.slowStartMinFraction;
        if (percentRange > 0.0f) {
            tasksFractionToSchedule = (minSourceVertexCompletedTaskFraction - this.slowStartMinFraction) / percentRange;
        } else if (minSourceVertexCompletedTaskFraction < this.slowStartMinFraction) {
            tasksFractionToSchedule = 0.0f;
        }
        tasksFractionToSchedule = Math.max(0.0f, Math.min(1.0f, tasksFractionToSchedule));
        return (int)Math.ceil(tasksFractionToSchedule * (float)this.totalTasksToSchedule) - (this.totalTasksToSchedule - numPendingTasks);
    }

    public static RootInputVertexManagerConfigBuilder createConfigBuilder(@Nullable Configuration conf) {
        return new RootInputVertexManagerConfigBuilder(conf);
    }

    public static final class RootInputVertexManagerConfigBuilder {
        private final Configuration conf;

        private RootInputVertexManagerConfigBuilder(@Nullable Configuration conf) {
            this.conf = conf == null ? new Configuration(false) : conf;
        }

        public RootInputVertexManagerConfigBuilder setSlowStart(boolean enabled) {
            this.conf.setBoolean(RootInputVertexManager.TEZ_ROOT_INPUT_VERTEX_MANAGER_ENABLE_SLOW_START, enabled);
            return this;
        }

        public RootInputVertexManagerConfigBuilder setSlowStartMinSrcCompletionFraction(float minFraction) {
            this.conf.setFloat(RootInputVertexManager.TEZ_ROOT_INPUT_VERTEX_MANAGER_MIN_SRC_FRACTION, minFraction);
            return this;
        }

        public RootInputVertexManagerConfigBuilder setSlowStartMaxSrcCompletionFraction(float maxFraction) {
            this.conf.setFloat(RootInputVertexManager.TEZ_ROOT_INPUT_VERTEX_MANAGER_MAX_SRC_FRACTION, maxFraction);
            return this;
        }

        public VertexManagerPluginDescriptor build() {
            VertexManagerPluginDescriptor desc = VertexManagerPluginDescriptor.create((String)RootInputVertexManager.class.getName());
            try {
                return (VertexManagerPluginDescriptor)desc.setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)this.conf));
            }
            catch (IOException e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }
    }

    static class SourceVertexInfo {
        final EdgeProperty edgeProperty;
        boolean vertexIsConfigured;
        final BitSet finishedTaskSet;
        int numTasks;

        SourceVertexInfo(EdgeProperty edgeProperty, int totalTasksToSchedule) {
            this.edgeProperty = edgeProperty;
            this.finishedTaskSet = new BitSet();
        }

        int getNumTasks() {
            return this.numTasks;
        }

        int getNumCompletedTasks() {
            return this.finishedTaskSet.cardinality();
        }
    }

    static class PendingTaskInfo {
        private final int index;

        public PendingTaskInfo(int index) {
            this.index = index;
        }

        public String toString() {
            return "[index=" + this.index + "]";
        }

        public int getIndex() {
            return this.index;
        }
    }
}

