/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.app.launcher.DagDeleteRunnable;
import org.apache.tez.dag.app.launcher.DeletionTracker;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionTrackerImpl
extends DeletionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DeletionTrackerImpl.class);
    private Map<NodeId, Integer> nodeIdShufflePortMap = new HashMap<NodeId, Integer>();
    private ExecutorService dagCleanupService;

    public DeletionTrackerImpl(Configuration conf) {
        super(conf);
        this.dagCleanupService = new ThreadPoolExecutor(0, conf.getInt("tez.am.dag.deletion.thread-count-limit", 10), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShuffleDeleteTracker #%d").build());
    }

    @Override
    public void dagComplete(TezDAGID dag, JobTokenSecretManager jobTokenSecretManager) {
        super.dagComplete(dag, jobTokenSecretManager);
        for (Map.Entry<NodeId, Integer> entry : this.nodeIdShufflePortMap.entrySet()) {
            NodeId nodeId = entry.getKey();
            int shufflePort = entry.getValue();
            if (shufflePort == -1) continue;
            DagDeleteRunnable dagDeleteRunnable = new DagDeleteRunnable(nodeId, shufflePort, dag, TezRuntimeUtils.getHttpConnectionParams((Configuration)this.conf), jobTokenSecretManager);
            try {
                this.dagCleanupService.submit(dagDeleteRunnable);
            }
            catch (RejectedExecutionException rejectedException) {
                LOG.info("Ignoring deletion request for " + dagDeleteRunnable);
            }
        }
    }

    @Override
    public void addNodeShufflePort(NodeId nodeId, int port) {
        if (port != -1 && this.nodeIdShufflePortMap.get(nodeId) == null) {
            this.nodeIdShufflePortMap.put(nodeId, port);
        }
    }

    @VisibleForTesting
    Map<NodeId, Integer> getNodeIdShufflePortMap() {
        return this.nodeIdShufflePortMap;
    }

    @Override
    public void shutdown() {
        if (this.dagCleanupService != null) {
            this.dagCleanupService.shutdownNow();
            this.dagCleanupService = null;
        }
        this.nodeIdShufflePortMap = null;
    }
}

