/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFinishedEvent
implements HistoryEvent {
    private static final Logger LOG = LoggerFactory.getLogger(TaskFinishedEvent.class);
    private TezTaskID taskID;
    private String vertexName;
    private long startTime;
    private long finishTime;
    private TaskState state;
    private TezCounters tezCounters;
    private TezTaskAttemptID successfulAttemptID;
    private String diagnostics;
    private int numFailedAttempts;

    public TaskFinishedEvent(TezTaskID taskID, String vertexName, long startTime, long finishTime, TezTaskAttemptID successfulAttemptID, TaskState state, String diagnostics, TezCounters counters, int failedAttempts) {
        this.vertexName = vertexName;
        this.taskID = taskID;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
        this.successfulAttemptID = successfulAttemptID;
        this.numFailedAttempts = failedAttempts;
    }

    public TaskFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_FINISHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskFinishedProto toProto() {
        RecoveryProtos.TaskFinishedProto.Builder builder = RecoveryProtos.TaskFinishedProto.newBuilder();
        builder.setTaskId(this.taskID.toString()).setState(this.state.ordinal()).setFinishTime(this.finishTime);
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        if (this.successfulAttemptID != null) {
            builder.setSuccessfulTaskAttemptId(this.successfulAttemptID.toString());
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.TaskFinishedProto proto) {
        this.taskID = TezTaskID.fromString((String)proto.getTaskId());
        this.finishTime = proto.getFinishTime();
        this.state = TaskState.values()[proto.getState()];
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
        if (proto.hasSuccessfulTaskAttemptId()) {
            this.successfulAttemptID = TezTaskAttemptID.fromString((String)proto.getSuccessfulTaskAttemptId());
        }
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.TaskFinishedProto proto = (RecoveryProtos.TaskFinishedProto)inputStream.readMessage(RecoveryProtos.TaskFinishedProto.PARSER, null);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("vertexName=");
        sb.append(this.vertexName);
        sb.append(", taskId=");
        sb.append(this.taskID);
        sb.append(", startTime=");
        sb.append(this.startTime);
        sb.append(", finishTime=");
        sb.append(this.finishTime);
        sb.append(", timeTaken=");
        sb.append(this.finishTime - this.startTime);
        sb.append(", status=");
        sb.append(this.state.name());
        sb.append(", successfulAttemptID=");
        sb.append(this.successfulAttemptID);
        sb.append(", diagnostics=");
        sb.append(this.diagnostics);
        sb.append(", counters=");
        if (this.tezCounters == null) {
            sb.append("null");
        } else {
            sb.append("Counters: ");
            sb.append(this.tezCounters.countCounters());
            for (CounterGroup group : this.tezCounters) {
                sb.append(", ");
                sb.append(group.getDisplayName());
                for (TezCounter counter : group) {
                    sb.append(", ");
                    sb.append(counter.getDisplayName()).append("=").append(counter.getValue());
                }
            }
        }
        return sb.toString();
    }

    public TezTaskID getTaskID() {
        return this.taskID;
    }

    public TaskState getState() {
        return this.state;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public TezCounters getTezCounters() {
        return this.tezCounters;
    }

    public TezTaskAttemptID getSuccessfulAttemptID() {
        return this.successfulAttemptID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public int getNumFailedAttempts() {
        return this.numFailedAttempts;
    }
}

