/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class GroupByConstParallelSetter
extends Rule {
    private static final Log log = LogFactory.getLog(GroupByConstParallelSetter.class);

    public GroupByConstParallelSetter(String n) {
        super(n, false);
    }

    @Override
    public Transformer getNewTransformer() {
        return new GroupAllParallelSetterTransformer();
    }

    @Override
    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOCogroup op = new LOCogroup(plan);
        plan.add(op);
        return plan;
    }

    public class GroupAllParallelSetterTransformer
    extends Transformer {
        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            LOCogroup group = (LOCogroup)matched.getSources().get(0);
            MultiMap<Integer, LogicalExpressionPlan> explPlans = group.getExpressionPlans();
            for (LogicalExpressionPlan ep : explPlans.values()) {
                Iterator<Operator> op_iter = ep.getOperators();
                if (op_iter.hasNext() && !(op_iter.next() instanceof ConstantExpression)) {
                    return false;
                }
                if (!op_iter.hasNext()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void transform(OperatorPlan plan) throws FrontendException {
            Iterator<Operator> iter = plan.getOperators();
            while (iter.hasNext()) {
                Operator op = iter.next();
                if (!(op instanceof LOCogroup)) continue;
                LOCogroup group = (LOCogroup)op;
                if (group.getRequestedParallelism() > 1) {
                    log.warn((Object)("Resetting parallism to 1 for the group/cogroup " + group.getAlias() + " as the group by expressions returns a constant"));
                }
                ((LOCogroup)op).setRequestedParallelism(1);
            }
        }

        @Override
        public OperatorPlan reportChanges() {
            return new OperatorSubPlan(GroupByConstParallelSetter.this.currentPlan);
        }
    }
}

