/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.Count;
import org.apache.hadoop.fs.shell.PathData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCount {
    private static final String WITH_QUOTAS = "Content summary with quotas";
    private static final String NO_QUOTAS = "Content summary without quotas";
    private static final String HUMAN = "human: ";
    private static final String BYTES = "bytes: ";
    private static final String QUOTAS_AND_USAGE = "quotas and usage";
    private static Configuration conf;
    private static FileSystem mockFs;
    private static FileStatus fileStat;

    @BeforeClass
    public static void setup() {
        conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        fileStat = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)fileStat.isFile()).thenReturn((Object)true);
    }

    @Before
    public void resetMock() {
        Mockito.reset((Object[])new FileSystem[]{mockFs});
    }

    @Test
    public void processOptionsHumanReadable() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-h");
        options.add("dummy");
        Count count = new Count();
        count.processOptions(options);
        Assert.assertFalse((boolean)count.isShowQuotas());
        Assert.assertTrue((boolean)count.isHumanReadable());
    }

    @Test
    public void processOptionsAll() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-h");
        options.add("-t");
        options.add("SSD");
        options.add("dummy");
        Count count = new Count();
        count.processOptions(options);
        Assert.assertTrue((boolean)count.isShowQuotas());
        Assert.assertTrue((boolean)count.isHumanReadable());
        Assert.assertTrue((boolean)count.isShowQuotabyType());
        Assert.assertEquals((long)1L, (long)count.getStorageTypes().size());
        Assert.assertEquals((Object)StorageType.SSD, count.getStorageTypes().get(0));
    }

    @Test
    public void processOptionsNoOptions() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("dummy");
        Count count = new Count();
        count.processOptions(options);
        Assert.assertFalse((boolean)count.isShowQuotas());
    }

    @Test
    public void processOptionsShowQuotas() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("dummy");
        Count count = new Count();
        count.processOptions(options);
        Assert.assertTrue((boolean)count.isShowQuotas());
    }

    @Test
    public void processOptionsMissingArgs() {
        LinkedList options = new LinkedList();
        Count count = new Count();
        try {
            count.processOptions(options);
            Assert.fail((String)"Count.processOptions - NotEnoughArgumentsException not thrown");
        }
        catch (CommandFormat.NotEnoughArgumentsException notEnoughArgumentsException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)count.isShowQuotas());
    }

    @Test
    public void processOptionsHeaderNoQuotas() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-v");
        options.add("dummy");
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        count.processOptions(options);
        String noQuotasHeader = "   DIR_COUNT   FILE_COUNT       CONTENT_SIZE PATHNAME";
        ((PrintStream)Mockito.verify((Object)out)).println(noQuotasHeader);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processOptionsHeaderWithQuotas() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-v");
        options.add("dummy");
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        count.processOptions(options);
        String withQuotasHeader = "       QUOTA       REM_QUOTA     SPACE_QUOTA REM_SPACE_QUOTA    DIR_COUNT   FILE_COUNT       CONTENT_SIZE PATHNAME";
        ((PrintStream)Mockito.verify((Object)out)).println(withQuotasHeader);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathShowQuotas() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        ((PrintStream)Mockito.verify((Object)out)).println("bytes: Content summary with quotas" + path.toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathNoQuotas() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        ((PrintStream)Mockito.verify((Object)out)).println("bytes: Content summary without quotas" + path.toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathShowQuotasHuman() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-h");
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        ((PrintStream)Mockito.verify((Object)out)).println("human: Content summary with quotas" + path.toString());
    }

    @Test
    public void processPathNoQuotasHuman() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-h");
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        ((PrintStream)Mockito.verify((Object)out)).println("human: Content summary without quotas" + path.toString());
    }

    @Test
    public void processPathWithQuotasByStorageTypesHeader() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-v");
        options.add("-t");
        options.add("all");
        options.add("dummy");
        count.processOptions(options);
        String withStorageTypeHeader = "    SSD_QUOTA     REM_SSD_QUOTA    DISK_QUOTA    REM_DISK_QUOTA ARCHIVE_QUOTA REM_ARCHIVE_QUOTA PATHNAME";
        ((PrintStream)Mockito.verify((Object)out)).println(withStorageTypeHeader);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathWithQuotasBySSDStorageTypesHeader() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-v");
        options.add("-t");
        options.add("SSD");
        options.add("dummy");
        count.processOptions(options);
        String withStorageTypeHeader = "    SSD_QUOTA     REM_SSD_QUOTA PATHNAME";
        ((PrintStream)Mockito.verify((Object)out)).println(withStorageTypeHeader);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathWithQuotasByQTVH() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-t");
        options.add("-v");
        options.add("-h");
        options.add("dummy");
        count.processOptions(options);
        String withStorageTypeHeader = "    SSD_QUOTA     REM_SSD_QUOTA    DISK_QUOTA    REM_DISK_QUOTA ARCHIVE_QUOTA REM_ARCHIVE_QUOTA PATHNAME";
        ((PrintStream)Mockito.verify((Object)out)).println(withStorageTypeHeader);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathWithQuotasByMultipleStorageTypesContent() throws Exception {
        this.processMultipleStorageTypesContent(false);
    }

    @Test
    public void processPathWithQuotaUsageByMultipleStorageTypesContent() throws Exception {
        this.processMultipleStorageTypesContent(true);
    }

    private void processMultipleStorageTypesContent(boolean quotaUsageOnly) throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add(quotaUsageOnly ? "-u" : "-q");
        options.add("-t");
        options.add("SSD,DISK");
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        String withStorageType = BYTES + StorageType.SSD.toString() + " " + StorageType.DISK.toString() + " " + pathData.toString();
        ((PrintStream)Mockito.verify((Object)out)).println(withStorageType);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathWithQuotasByMultipleStorageTypes() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-v");
        options.add("-t");
        options.add("SSD,DISK");
        options.add("dummy");
        count.processOptions(options);
        String withStorageTypeHeader = "    SSD_QUOTA     REM_SSD_QUOTA    DISK_QUOTA    REM_DISK_QUOTA PATHNAME";
        ((PrintStream)Mockito.verify((Object)out)).println(withStorageTypeHeader);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void getCommandName() {
        Count count = new Count();
        String actual = count.getCommandName();
        String expected = "count";
        Assert.assertEquals((String)"Count.getCommandName", (Object)expected, (Object)actual);
    }

    @Test
    public void isDeprecated() {
        Count count = new Count();
        boolean actual = count.isDeprecated();
        boolean expected = false;
        Assert.assertEquals((String)"Count.isDeprecated", (Object)expected, (Object)actual);
    }

    @Test
    public void getReplacementCommand() {
        Count count = new Count();
        String actual = count.getReplacementCommand();
        Object expected = null;
        Assert.assertEquals((String)"Count.getReplacementCommand", expected, (Object)actual);
    }

    @Test
    public void getName() {
        Count count = new Count();
        String actual = count.getName();
        String expected = "count";
        Assert.assertEquals((String)"Count.getName", (Object)expected, (Object)actual);
    }

    @Test
    public void getUsage() {
        Count count = new Count();
        String actual = count.getUsage();
        String expected = "-count [-q] [-h] [-v] [-t [<storage type>]] [-u] [-x] <path> ...";
        Assert.assertEquals((String)"Count.getUsage", (Object)expected, (Object)actual);
    }

    @Test
    public void getDescription() {
        Count count = new Count();
        String actual = count.getDescription();
        String expected = "Count the number of directories, files and bytes under the paths\nthat match the specified file pattern.  The output columns are:\nDIR_COUNT FILE_COUNT CONTENT_SIZE PATHNAME\nor, with the -q option:\nQUOTA REM_QUOTA SPACE_QUOTA REM_SPACE_QUOTA\n      DIR_COUNT FILE_COUNT CONTENT_SIZE PATHNAME\nThe -h option shows file sizes in human readable format.\nThe -v option displays a header line.\nThe -x option excludes snapshots from being calculated. \nThe -t option displays quota by storage types.\nIt should be used with -q or -u option, otherwise it will be ignored.\nIf a comma-separated list of storage types is given after the -t option, \nit displays the quota and usage for the specified types. \nOtherwise, it displays the quota and usage for all the storage \ntypes that support quota. The list of possible storage types(case insensitive):\nram_disk, ssd, disk and archive.\nIt can also pass the value '', 'all' or 'ALL' to specify all the storage types.\nThe -u option shows the quota and \nthe usage against the quota without the detailed content summary.";
        Assert.assertEquals((String)"Count.getDescription", (Object)expected, (Object)actual);
    }

    @Test
    public void processPathWithQuotaUsageHuman() throws Exception {
        this.processPathWithQuotaUsage(false);
    }

    @Test
    public void processPathWithQuotaUsageRawBytes() throws Exception {
        this.processPathWithQuotaUsage(true);
    }

    private void processPathWithQuotaUsage(boolean rawBytes) throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        if (!rawBytes) {
            options.add("-h");
        }
        options.add("-u");
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        String withStorageType = (rawBytes ? BYTES : HUMAN) + QUOTAS_AND_USAGE + pathData.toString();
        ((PrintStream)Mockito.verify((Object)out)).println(withStorageType);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    static class MockFileSystem
    extends FilterFileSystem {
        Configuration conf;

        MockFileSystem() {
            super(mockFs);
        }

        public void initialize(URI uri, Configuration conf) {
            this.conf = conf;
        }

        public Path makeQualified(Path path) {
            return path;
        }

        public ContentSummary getContentSummary(Path f) throws IOException {
            return new MockContentSummary();
        }

        public Configuration getConf() {
            return this.conf;
        }

        public QuotaUsage getQuotaUsage(Path f) throws IOException {
            return new MockQuotaUsage();
        }
    }

    static class MockQuotaUsage
    extends QuotaUsage {
        public String toString(boolean hOption, boolean tOption, List<StorageType> types) {
            if (tOption) {
                StringBuffer result = new StringBuffer();
                result.append(hOption ? TestCount.HUMAN : TestCount.BYTES);
                for (StorageType type : types) {
                    result.append(type.toString());
                    result.append(" ");
                }
                return result.toString();
            }
            if (hOption) {
                return "human: quotas and usage";
            }
            return "bytes: quotas and usage";
        }
    }

    static class MockContentSummary
    extends ContentSummary {
        public String toString(boolean qOption, boolean hOption, boolean xOption) {
            if (qOption) {
                if (hOption) {
                    return "human: Content summary with quotas";
                }
                return "bytes: Content summary with quotas";
            }
            if (hOption) {
                return "human: Content summary without quotas";
            }
            return "bytes: Content summary without quotas";
        }
    }
}

