/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskFetchedInput
extends FetchedInput {
    private static final Logger LOG = LoggerFactory.getLogger(DiskFetchedInput.class);
    private final FileSystem localFS;
    private final Path tmpOutputPath;
    private final Path outputPath;
    private final long size;

    public DiskFetchedInput(long compressedSize, InputAttemptIdentifier inputAttemptIdentifier, FetchedInputCallback callbackHandler, Configuration conf, LocalDirAllocator localDirAllocator, TezTaskOutputFiles filenameAllocator) throws IOException {
        super(inputAttemptIdentifier, callbackHandler);
        this.size = compressedSize;
        this.localFS = FileSystem.getLocal((Configuration)conf).getRaw();
        this.outputPath = filenameAllocator.getInputFileForWrite(this.getInputAttemptIdentifier().getInputIdentifier(), this.getInputAttemptIdentifier().getSpillEventId(), this.size);
        this.tmpOutputPath = this.outputPath.suffix(String.valueOf(this.getId()));
    }

    @Override
    public FetchedInput.Type getType() {
        return FetchedInput.Type.DISK;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.localFS.create(this.tmpOutputPath);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.localFS.open(this.outputPath);
    }

    public final Path getInputPath() {
        if (this.isState(FetchedInput.State.COMMITTED)) {
            return this.outputPath;
        }
        return this.tmpOutputPath;
    }

    @Override
    public void commit() throws IOException {
        if (this.isState(FetchedInput.State.PENDING)) {
            this.setState(FetchedInput.State.COMMITTED);
            this.localFS.rename(this.tmpOutputPath, this.outputPath);
            this.notifyFetchComplete();
        }
    }

    @Override
    public void abort() throws IOException {
        if (this.isState(FetchedInput.State.PENDING)) {
            this.setState(FetchedInput.State.ABORTED);
            this.localFS.delete(this.tmpOutputPath, false);
            this.notifyFetchFailure();
        }
    }

    @Override
    public void free() {
        Preconditions.checkState((this.isState(FetchedInput.State.COMMITTED) || this.isState(FetchedInput.State.ABORTED) ? 1 : 0) != 0, (Object)"FetchedInput can only be freed after it is committed or aborted");
        if (this.isState(FetchedInput.State.COMMITTED)) {
            this.setState(FetchedInput.State.FREED);
            try {
                this.localFS.delete(this.outputPath, false);
            }
            catch (IOException e) {
                LOG.warn("Failed to remvoe file : " + this.outputPath.toString());
            }
            this.notifyFreedResource();
        }
    }

    public String toString() {
        return "DiskFetchedInput [outputPath=" + this.outputPath + ", inputAttemptIdentifier=" + this.getInputAttemptIdentifier() + ", actualSize=" + this.getSize() + ", type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", state=" + (Object)((Object)this.getState()) + "]";
    }
}

