/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestBaseSourceImpl {
    private static BaseSourceImpl bmsi;

    @BeforeClass
    public static void setUp() throws Exception {
        bmsi = new BaseSourceImpl("TestName", "test description", "testcontext", "TestContext");
    }

    @Test
    public void testSetGauge() throws Exception {
        bmsi.setGauge("testset", 100L);
        Assert.assertEquals((long)100L, (long)((MutableGaugeLong)TestBaseSourceImpl.bmsi.metricsRegistry.get("testset")).value());
        bmsi.setGauge("testset", 300L);
        Assert.assertEquals((long)300L, (long)((MutableGaugeLong)TestBaseSourceImpl.bmsi.metricsRegistry.get("testset")).value());
    }

    @Test
    public void testIncGauge() throws Exception {
        bmsi.incGauge("testincgauge", 100L);
        Assert.assertEquals((long)100L, (long)((MutableGaugeLong)TestBaseSourceImpl.bmsi.metricsRegistry.get("testincgauge")).value());
        bmsi.incGauge("testincgauge", 100L);
        Assert.assertEquals((long)200L, (long)((MutableGaugeLong)TestBaseSourceImpl.bmsi.metricsRegistry.get("testincgauge")).value());
    }

    @Test
    public void testDecGauge() throws Exception {
        bmsi.decGauge("testdec", 100L);
        Assert.assertEquals((long)-100L, (long)((MutableGaugeLong)TestBaseSourceImpl.bmsi.metricsRegistry.get("testdec")).value());
        bmsi.decGauge("testdec", 100L);
        Assert.assertEquals((long)-200L, (long)((MutableGaugeLong)TestBaseSourceImpl.bmsi.metricsRegistry.get("testdec")).value());
    }

    @Test
    public void testIncCounters() throws Exception {
        bmsi.incCounters("testinccounter", 100L);
        Assert.assertEquals((long)100L, (long)((MutableCounterLong)TestBaseSourceImpl.bmsi.metricsRegistry.get("testinccounter")).value());
        bmsi.incCounters("testinccounter", 100L);
        Assert.assertEquals((long)200L, (long)((MutableCounterLong)TestBaseSourceImpl.bmsi.metricsRegistry.get("testinccounter")).value());
    }

    @Test
    public void testRemoveMetric() throws Exception {
        bmsi.setGauge("testrmgauge", 100L);
        bmsi.removeMetric("testrmgauge");
        Assert.assertNull((Object)TestBaseSourceImpl.bmsi.metricsRegistry.get("testrmgauge"));
    }
}

