/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AbstractPreemptableResourceCalculator {
    protected final CapacitySchedulerPreemptionContext context;
    protected final ResourceCalculator rc;
    protected boolean isReservedPreemptionCandidatesSelector;
    private Resource stepFactor;

    public AbstractPreemptableResourceCalculator(CapacitySchedulerPreemptionContext preemptionContext, boolean isReservedPreemptionCandidatesSelector) {
        this.context = preemptionContext;
        this.rc = preemptionContext.getResourceCalculator();
        this.isReservedPreemptionCandidatesSelector = isReservedPreemptionCandidatesSelector;
        this.stepFactor = Resource.newInstance((int)0, (int)0);
        for (ResourceInformation ri : this.stepFactor.getResources()) {
            ri.setValue(1L);
        }
    }

    protected void computeFixpointAllocation(Resource totGuarant, Collection<TempQueuePerPartition> qAlloc, Resource unassigned, boolean ignoreGuarantee) {
        TQComparator tqComparator = new TQComparator(this.rc, totGuarant);
        PriorityQueue<TempQueuePerPartition> orderedByNeed = new PriorityQueue<TempQueuePerPartition>(10, tqComparator);
        for (TempQueuePerPartition q : qAlloc) {
            Resource used = q.getUsed();
            q.idealAssigned = Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)used, (Resource)q.getGuaranteed()) ? Resources.add((Resource)Resources.componentwiseMin((Resource)q.getGuaranteed(), (Resource)q.getUsed()), (Resource)q.untouchableExtra) : Resources.clone((Resource)used);
            Resources.subtractFrom((Resource)unassigned, (Resource)q.idealAssigned);
            Resource curPlusPend = Resources.add((Resource)q.getUsed(), (Resource)q.pending);
            if (!Resources.lessThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)q.idealAssigned, (Resource)curPlusPend)) continue;
            orderedByNeed.add(q);
        }
        while (!orderedByNeed.isEmpty() && Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)unassigned, (Resource)Resources.none())) {
            this.resetCapacity(unassigned, orderedByNeed, ignoreGuarantee);
            Collection<TempQueuePerPartition> underserved = this.getMostUnderservedQueues(orderedByNeed, tqComparator);
            Resource dupUnassignedForTheRound = Resources.clone((Resource)unassigned);
            Iterator<TempQueuePerPartition> i = underserved.iterator();
            while (i.hasNext() && this.rc.isAnyMajorResourceAboveZero(unassigned)) {
                Resource wQidle;
                TempQueuePerPartition sub = i.next();
                Resource wQavail = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.rc, (Resource)dupUnassignedForTheRound, (double[])sub.normalizedGuarantee, (Resource)this.stepFactor);
                Resource wQdone = Resources.subtract((Resource)(wQavail = Resources.componentwiseMin((Resource)wQavail, (Resource)unassigned)), (Resource)(wQidle = sub.offer(wQavail, this.rc, totGuarant, this.isReservedPreemptionCandidatesSelector)));
                if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)totGuarant, (Resource)wQdone, (Resource)Resources.none())) {
                    orderedByNeed.add(sub);
                }
                Resources.subtractFrom((Resource)unassigned, (Resource)wQdone);
                unassigned = Resources.componentwiseMax((Resource)unassigned, (Resource)Resources.none());
            }
        }
        while (!orderedByNeed.isEmpty()) {
            TempQueuePerPartition q1 = (TempQueuePerPartition)orderedByNeed.remove();
            this.context.addPartitionToUnderServedQueues(q1.queueName, q1.partition);
        }
    }

    private void resetCapacity(Resource clusterResource, Collection<TempQueuePerPartition> queues, boolean ignoreGuar) {
        Resource activeCap = Resource.newInstance((int)0, (int)0);
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        if (ignoreGuar) {
            for (TempQueuePerPartition q : queues) {
                for (int i = 0; i < maxLength; ++i) {
                    q.normalizedGuarantee[i] = 1.0f / (float)queues.size();
                }
            }
        } else {
            for (TempQueuePerPartition q : queues) {
                Resources.addTo((Resource)activeCap, (Resource)q.getGuaranteed());
            }
            for (TempQueuePerPartition q : queues) {
                for (int i = 0; i < maxLength; ++i) {
                    ResourceInformation nResourceInformation = q.getGuaranteed().getResourceInformation(i);
                    ResourceInformation dResourceInformation = activeCap.getResourceInformation(i);
                    long nValue = nResourceInformation.getValue();
                    long dValue = UnitsConversionUtil.convert((String)dResourceInformation.getUnits(), (String)nResourceInformation.getUnits(), (long)dResourceInformation.getValue());
                    if (dValue == 0L) continue;
                    q.normalizedGuarantee[i] = (float)nValue / (float)dValue;
                }
            }
        }
    }

    private Collection<TempQueuePerPartition> getMostUnderservedQueues(PriorityQueue<TempQueuePerPartition> orderedByNeed, TQComparator tqComparator) {
        ArrayList<TempQueuePerPartition> underserved = new ArrayList<TempQueuePerPartition>();
        while (!orderedByNeed.isEmpty()) {
            TempQueuePerPartition q1 = (TempQueuePerPartition)orderedByNeed.remove();
            underserved.add(q1);
            this.context.addPartitionToUnderServedQueues(q1.queueName, q1.partition);
            TempQueuePerPartition q2 = orderedByNeed.peek();
            if (q2 != null && tqComparator.compare(q1, q2) >= 0) continue;
            if (null != q2) {
                this.context.addPartitionToUnderServedQueues(q2.queueName, q2.partition);
            }
            return underserved;
        }
        return underserved;
    }

    static class TQComparator
    implements Comparator<TempQueuePerPartition> {
        private ResourceCalculator rc;
        private Resource clusterRes;

        TQComparator(ResourceCalculator rc, Resource clusterRes) {
            this.rc = rc;
            this.clusterRes = clusterRes;
        }

        @Override
        public int compare(TempQueuePerPartition tq1, TempQueuePerPartition tq2) {
            double assigned1 = this.getIdealPctOfGuaranteed(tq1);
            double assigned2 = this.getIdealPctOfGuaranteed(tq2);
            return PriorityUtilizationQueueOrderingPolicy.compare(assigned1, assigned2, tq1.relativePriority, tq2.relativePriority);
        }

        private double getIdealPctOfGuaranteed(TempQueuePerPartition q) {
            double pctOver = 2.147483647E9;
            if (q != null && Resources.greaterThan((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)q.getGuaranteed(), (Resource)Resources.none())) {
                pctOver = Resources.divide((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)q.idealAssigned, (Resource)q.getGuaranteed());
            }
            return pctOver;
        }
    }
}

