/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.io.Writable;

public class TezLocalResource
implements Writable {
    private URI uri;
    private long size;
    private long timestamp;

    public TezLocalResource() {
    }

    public TezLocalResource(URI uri, long size, long timestamp) {
        this.uri = uri;
        this.size = size;
        this.timestamp = timestamp;
    }

    public URI getUri() {
        return this.uri;
    }

    public long getSize() {
        return this.size;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.uri.toString());
        out.writeLong(this.size);
        out.writeLong(this.timestamp);
    }

    public void readFields(DataInput in) throws IOException {
        try {
            this.uri = new URI(in.readUTF());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.size = in.readLong();
        this.timestamp = in.readLong();
    }

    public String toString() {
        return "TezLocalResource [uri=" + this.uri + ", size=" + this.size + ", timestamp=" + this.timestamp + "]";
    }
}

