/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.MergedLogicalInput;

public class InputReadyTracker {
    private final ConcurrentMap<Input, Boolean> readyInputs;
    private ConcurrentMap<Input, List<MergedLogicalInput>> inputToGroupMap;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public InputReadyTracker() {
        this.readyInputs = Maps.newConcurrentMap();
    }

    public void setInputIsReady(Input input) {
        this.lock.lock();
        try {
            Boolean old = this.readyInputs.putIfAbsent(input, true);
            if (old == null) {
                this.informGroupedInputs(input);
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void informGroupedInputs(Input input) {
        List mergedInputList;
        if (this.inputToGroupMap != null && (mergedInputList = (List)this.inputToGroupMap.get(input)) != null) {
            for (MergedLogicalInput mergedInput : mergedInputList) {
                mergedInput.setConstituentInputIsReady(input);
            }
        }
    }

    public Input waitForAnyInputReady(Collection<Input> inputs) throws InterruptedException {
        return this.waitForAnyInputReady(inputs, -1L);
    }

    public Input waitForAnyInputReady(Collection<Input> inputs, long timeoutMillis) throws InterruptedException {
        Preconditions.checkArgument((inputs != null && inputs.size() > 0 ? 1 : 0) != 0, (Object)"At least one input should be specified");
        InputReadyMonitor inputReadyMonitor = new InputReadyMonitor(inputs, true);
        try {
            return inputReadyMonitor.awaitCondition(timeoutMillis);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public void waitForAllInputsReady(Collection<Input> inputs) throws InterruptedException {
        this.waitForAllInputsReady(inputs, -1L);
    }

    public boolean waitForAllInputsReady(Collection<Input> inputs, long timeoutMillis) throws InterruptedException {
        Preconditions.checkArgument((inputs != null && inputs.size() > 0 ? 1 : 0) != 0, (Object)"At least one input should be specified");
        boolean succeeded = true;
        InputReadyMonitor inputReadyMonitor = new InputReadyMonitor(inputs, false);
        try {
            inputReadyMonitor.awaitCondition(timeoutMillis);
        }
        catch (TimeoutException e) {
            succeeded = false;
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupedInputs(Collection<MergedLogicalInput> inputGroups) {
        this.lock.lock();
        try {
            if (inputGroups != null) {
                this.inputToGroupMap = Maps.newConcurrentMap();
                for (MergedLogicalInput mergedInput : inputGroups) {
                    for (Input dest : mergedInput.getInputs()) {
                        List mergedList;
                        if (this.readyInputs.containsKey(dest)) {
                            mergedInput.setConstituentInputIsReady(dest);
                        }
                        if ((mergedList = (List)this.inputToGroupMap.get(dest)) == null) {
                            mergedList = Lists.newArrayList();
                            this.inputToGroupMap.put(dest, mergedList);
                        }
                        mergedList.add(mergedInput);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class InputReadyMonitor {
        private final Set<Input> pendingInputs = Collections.newSetFromMap(new ConcurrentHashMap());
        private final boolean selectOne;

        public InputReadyMonitor(Collection<Input> inputs, boolean anyOne) {
            this.pendingInputs.addAll(inputs);
            this.selectOne = anyOne;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Input awaitCondition(long timeoutMillis) throws InterruptedException, TimeoutException {
            InputReadyTracker.this.lock.lock();
            try {
                while (this.pendingInputs.size() > 0) {
                    Iterator<Input> inputIter = this.pendingInputs.iterator();
                    while (inputIter.hasNext()) {
                        Input input = inputIter.next();
                        if (!InputReadyTracker.this.readyInputs.containsKey(input)) continue;
                        inputIter.remove();
                        if (!this.selectOne) continue;
                        Input input2 = input;
                        return input2;
                    }
                    if (this.pendingInputs.size() <= 0) continue;
                    if (timeoutMillis >= 0L) {
                        boolean succeeded = InputReadyTracker.this.condition.await(timeoutMillis, TimeUnit.MILLISECONDS);
                        if (succeeded) continue;
                        throw new TimeoutException("pending Inputs timeout");
                    }
                    InputReadyTracker.this.condition.await();
                }
            }
            finally {
                InputReadyTracker.this.lock.unlock();
            }
            return null;
        }
    }
}

