/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class Add
extends BinaryExpressionOperator {
    private static final long serialVersionUID = 1L;

    public Add(OperatorKey k) {
        super(k);
    }

    public Add(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitAdd(this);
    }

    @Override
    public String name() {
        return "Add[" + DataType.findTypeName(this.resultType) + "] - " + this.mKey.toString();
    }

    protected Number add(Number a, Number b, byte dataType) throws ExecException {
        switch (dataType) {
            case 25: {
                return (Double)a + (Double)b;
            }
            case 10: {
                return (Integer)a + (Integer)b;
            }
            case 15: {
                return (Long)a + (Long)b;
            }
            case 20: {
                return Float.valueOf(((Float)a).floatValue() + ((Float)b).floatValue());
            }
            case 65: {
                return ((BigInteger)a).add((BigInteger)b);
            }
            case 70: {
                return ((BigDecimal)a).add((BigDecimal)b);
            }
        }
        throw new ExecException("called on unsupported Number class " + DataType.findTypeName(dataType));
    }

    protected Result genericGetNext(byte dataType) throws ExecException {
        Result r = this.accumChild(null, dataType);
        if (r != null) {
            return r;
        }
        Result res = this.lhs.getNext(dataType);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        Number left = (Number)res.result;
        res = this.rhs.getNext(dataType);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        Number right = (Number)res.result;
        res.result = this.add(left, right, dataType);
        return res;
    }

    @Override
    public Result getNextDouble() throws ExecException {
        return this.genericGetNext((byte)25);
    }

    @Override
    public Result getNextFloat() throws ExecException {
        return this.genericGetNext((byte)20);
    }

    @Override
    public Result getNextInteger() throws ExecException {
        return this.genericGetNext((byte)10);
    }

    @Override
    public Result getNextLong() throws ExecException {
        return this.genericGetNext((byte)15);
    }

    @Override
    public Result getNextBigInteger() throws ExecException {
        return this.genericGetNext((byte)65);
    }

    @Override
    public Result getNextBigDecimal() throws ExecException {
        return this.genericGetNext((byte)70);
    }

    @Override
    public Add clone() throws CloneNotSupportedException {
        Add clone = new Add(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

