/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.event.Level;

public abstract class FileContextPermissionBase {
    protected FileContextTestHelper fileContextTestHelper;
    protected FileContext fc;
    static final FsPermission FILE_MASK_ZERO = new FsPermission(0);

    public FileContextPermissionBase() {
        try {
            GenericTestUtils.setLogLevel(FileSystem.LOG, Level.DEBUG);
        }
        catch (Exception e) {
            System.out.println("Cannot change log level\n" + StringUtils.stringifyException((Throwable)e));
        }
    }

    protected FileContextTestHelper getFileContextHelper() {
        return new FileContextTestHelper();
    }

    protected abstract FileContext getFileContext() throws Exception;

    @Before
    public void setUp() throws Exception {
        this.fileContextTestHelper = this.getFileContextHelper();
        this.fc = this.getFileContext();
        this.fc.mkdir(this.fileContextTestHelper.getTestRootPath(this.fc), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        this.fc.delete(this.fileContextTestHelper.getTestRootPath(this.fc), true);
    }

    private void cleanupFile(FileContext fc, Path name) throws IOException {
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, name));
        fc.delete(name, true);
        Assert.assertTrue((!FileContextTestHelper.exists(fc, name) ? 1 : 0) != 0);
    }

    @Test
    public void testCreatePermission() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        String filename = "foo";
        Path f = this.fileContextTestHelper.getTestRootPath(this.fc, filename);
        this.fileContextTestHelper.createFile(this.fc, filename);
        this.doFilePermissionCheck(FileContext.FILE_DEFAULT_PERM.applyUMask(this.fc.getUMask()), this.fc.getFileStatus(f).getPermission());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPermission() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        String filename = "foo";
        Path f = this.fileContextTestHelper.getTestRootPath(this.fc, filename);
        FileContextTestHelper.createFile(this.fc, f);
        try {
            FsPermission all = new FsPermission(511);
            FsPermission none = new FsPermission(0);
            this.fc.setPermission(f, none);
            this.doFilePermissionCheck(none, this.fc.getFileStatus(f).getPermission());
            this.fc.setPermission(f, all);
            this.doFilePermissionCheck(all, this.fc.getFileStatus(f).getPermission());
        }
        finally {
            this.cleanupFile(this.fc, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOwner() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        String filename = "bar";
        Path f = this.fileContextTestHelper.getTestRootPath(this.fc, filename);
        FileContextTestHelper.createFile(this.fc, f);
        List<String> groups = null;
        try {
            groups = FileContextPermissionBase.getGroups();
            System.out.println(filename + ": " + this.fc.getFileStatus(f).getPermission());
        }
        catch (IOException e) {
            System.out.println(StringUtils.stringifyException((Throwable)e));
            System.out.println("Cannot run test");
            return;
        }
        if (groups == null || groups.size() < 1) {
            System.out.println("Cannot run test: need at least one group.  groups=" + groups);
            return;
        }
        try {
            String g0 = groups.get(0);
            this.fc.setOwner(f, null, g0);
            Assert.assertEquals((Object)g0, (Object)this.fc.getFileStatus(f).getGroup());
            if (groups.size() > 1) {
                String g1 = groups.get(1);
                this.fc.setOwner(f, null, g1);
                Assert.assertEquals((Object)g1, (Object)this.fc.getFileStatus(f).getGroup());
            } else {
                System.out.println("Not testing changing the group since user belongs to only one group.");
            }
            try {
                this.fc.setOwner(f, null, null);
                Assert.fail((String)"Exception expected.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            this.cleanupFile(this.fc, f);
        }
    }

    @Test
    public void testUgi() throws IOException, InterruptedException {
        UserGroupInformation otherUser = UserGroupInformation.createRemoteUser((String)"otherUser");
        FileContext newFc = (FileContext)otherUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileContext>(){

            @Override
            public FileContext run() throws Exception {
                FileContext newFc = FileContext.getFileContext();
                return newFc;
            }
        });
        Assert.assertEquals((Object)"otherUser", (Object)newFc.getUgi().getUserName());
    }

    static List<String> getGroups() throws IOException {
        ArrayList<String> a = new ArrayList<String>();
        String s = Shell.execCommand((String[])Shell.getGroupsCommand());
        StringTokenizer t = new StringTokenizer(s);
        while (t.hasMoreTokens()) {
            a.add(t.nextToken());
        }
        return a;
    }

    void doFilePermissionCheck(FsPermission expectedPerm, FsPermission actualPerm) {
        Assert.assertEquals((Object)expectedPerm.applyUMask(this.getFileMask()), (Object)actualPerm);
    }

    FsPermission getFileMask() {
        return FILE_MASK_ZERO;
    }
}

