/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.MetricsIO;
import org.apache.hadoop.hbase.io.MetricsIOWrapper;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMetricsIO {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsIO.class);
    public MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    @Test
    public void testMetrics() {
        MetricsIO metrics = new MetricsIO(new MetricsIOWrapper(){

            public long getChecksumFailures() {
                return 40L;
            }
        });
        metrics.updateFsReadTime(100L);
        metrics.updateFsReadTime(200L);
        metrics.updateFsPreadTime(300L);
        metrics.updateFsWriteTime(400L);
        metrics.updateFsWriteTime(500L);
        metrics.updateFsWriteTime(600L);
        this.HELPER.assertCounter("fsChecksumFailureCount", 40L, (BaseSource)metrics.getMetricsSource());
        this.HELPER.assertCounter("fsReadTime_numOps", 2L, (BaseSource)metrics.getMetricsSource());
        this.HELPER.assertCounter("fsPReadTime_numOps", 1L, (BaseSource)metrics.getMetricsSource());
        this.HELPER.assertCounter("fsWriteTime_numOps", 3L, (BaseSource)metrics.getMetricsSource());
    }
}

