/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestMasterAddressTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterAddressTracker.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterAddressTracker.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZKWatcher zk;
    @Rule
    public TestName name = new TestName();

    @After
    public void cleanUp() {
        if (zk != null) {
            zk.close();
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testDeleteIfEquals() throws Exception {
        ServerName sn = ServerName.valueOf((String)"localhost", (int)1234, (long)System.currentTimeMillis());
        MasterAddressTracker addressTracker = this.setupMasterTracker(sn, 1772);
        try {
            Assert.assertFalse((String)"shouldn't have deleted wrong master server.", (boolean)MasterAddressTracker.deleteIfEquals((ZKWatcher)addressTracker.getWatcher(), (String)"some other string."));
        }
        finally {
            Assert.assertTrue((String)"Couldn't clean up master", (boolean)MasterAddressTracker.deleteIfEquals((ZKWatcher)addressTracker.getWatcher(), (String)sn.toString()));
        }
    }

    private MasterAddressTracker setupMasterTracker(ServerName sn, int infoPort) throws Exception {
        zk = new ZKWatcher(TEST_UTIL.getConfiguration(), this.name.getMethodName(), null);
        ZKUtil.createAndFailSilent((ZKWatcher)zk, (String)TestMasterAddressTracker.zk.getZNodePaths().baseZNode);
        ZKUtil.createAndFailSilent((ZKWatcher)zk, (String)TestMasterAddressTracker.zk.getZNodePaths().backupMasterAddressesZNode);
        MasterAddressTracker addressTracker = new MasterAddressTracker(zk, null);
        addressTracker.start();
        Assert.assertFalse((boolean)addressTracker.hasMaster());
        zk.registerListener((ZKListener)addressTracker);
        NodeCreationListener listener = new NodeCreationListener(zk, TestMasterAddressTracker.zk.getZNodePaths().masterAddressZNode);
        zk.registerListener((ZKListener)listener);
        if (sn != null) {
            LOG.info("Creating master node");
            MasterAddressTracker.setMasterAddress((ZKWatcher)zk, (String)TestMasterAddressTracker.zk.getZNodePaths().masterAddressZNode, (ServerName)sn, (int)infoPort);
            LOG.info("Waiting for master address manager to be notified");
            listener.waitForCreation();
            LOG.info("Master node created");
        }
        return addressTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterAddressTrackerFromZK() throws Exception {
        int infoPort = 1235;
        ServerName sn = ServerName.valueOf((String)"localhost", (int)1234, (long)System.currentTimeMillis());
        MasterAddressTracker addressTracker = this.setupMasterTracker(sn, 1235);
        try {
            Assert.assertTrue((boolean)addressTracker.hasMaster());
            ServerName pulledAddress = addressTracker.getMasterAddress();
            Assert.assertTrue((boolean)pulledAddress.equals((Object)sn));
            Assert.assertEquals((long)1235L, (long)addressTracker.getMasterInfoPort());
        }
        finally {
            Assert.assertTrue((String)"Couldn't clean up master", (boolean)MasterAddressTracker.deleteIfEquals((ZKWatcher)addressTracker.getWatcher(), (String)sn.toString()));
        }
    }

    @Test
    public void testParsingNull() throws Exception {
        Assert.assertNull((String)"parse on null data should return null.", (Object)MasterAddressTracker.parse(null));
    }

    @Test
    public void testNoBackups() throws Exception {
        ServerName sn = ServerName.valueOf((String)"localhost", (int)1234, (long)System.currentTimeMillis());
        MasterAddressTracker addressTracker = this.setupMasterTracker(sn, 1772);
        try {
            Assert.assertEquals((String)"Should receive 0 for backup not found.", (long)0L, (long)addressTracker.getBackupMasterInfoPort(ServerName.valueOf((String)"doesnotexist.example.com", (int)1234, (long)System.currentTimeMillis())));
        }
        finally {
            Assert.assertTrue((String)"Couldn't clean up master", (boolean)MasterAddressTracker.deleteIfEquals((ZKWatcher)addressTracker.getWatcher(), (String)sn.toString()));
        }
    }

    @Test
    public void testNoMaster() throws Exception {
        MasterAddressTracker addressTracker = this.setupMasterTracker(null, 1772);
        Assert.assertFalse((boolean)addressTracker.hasMaster());
        Assert.assertNull((String)"should get null master when none active.", (Object)addressTracker.getMasterAddress());
        Assert.assertEquals((String)"Should receive 0 for backup not found.", (long)0L, (long)addressTracker.getMasterInfoPort());
    }

    @Test
    public void testBackupMasters() throws Exception {
        ServerName sn = ServerName.valueOf((String)"localhost", (int)5678, (long)System.currentTimeMillis());
        MasterAddressTracker addressTracker = this.setupMasterTracker(sn, 1111);
        Assert.assertTrue((boolean)addressTracker.hasMaster());
        ServerName activeMaster = addressTracker.getMasterAddress();
        Assert.assertEquals((Object)activeMaster, (Object)sn);
        List backupMasters = addressTracker.getBackupMasters();
        Assert.assertEquals((long)0L, (long)backupMasters.size());
        ServerName backupMaster1 = ServerName.valueOf((String)"localhost", (int)2222, (long)-1L);
        ServerName backupMaster2 = ServerName.valueOf((String)"localhost", (int)3333, (long)-1L);
        String backupZNode1 = ZNodePaths.joinZNode((String)TestMasterAddressTracker.zk.getZNodePaths().backupMasterAddressesZNode, (String)backupMaster1.toString());
        String backupZNode2 = ZNodePaths.joinZNode((String)TestMasterAddressTracker.zk.getZNodePaths().backupMasterAddressesZNode, (String)backupMaster2.toString());
        MasterAddressTracker.setMasterAddress((ZKWatcher)zk, (String)backupZNode1, (ServerName)backupMaster1, (int)2222);
        MasterAddressTracker.setMasterAddress((ZKWatcher)zk, (String)backupZNode2, (ServerName)backupMaster2, (int)3333);
        backupMasters = addressTracker.getBackupMasters();
        Assert.assertEquals((long)2L, (long)backupMasters.size());
        Assert.assertTrue((boolean)backupMasters.contains(backupMaster1));
        Assert.assertTrue((boolean)backupMasters.contains(backupMaster2));
    }

    public static class NodeCreationListener
    extends ZKListener {
        private static final Logger LOG = LoggerFactory.getLogger(NodeCreationListener.class);
        private Semaphore lock = new Semaphore(0);
        private String node;

        public NodeCreationListener(ZKWatcher watcher, String node) {
            super(watcher);
            this.node = node;
        }

        public void nodeCreated(String path) {
            if (path.equals(this.node)) {
                LOG.debug("nodeCreated(" + path + ")");
                this.lock.release();
            }
        }

        public void waitForCreation() throws InterruptedException {
            this.lock.acquire();
        }
    }
}

