/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.SimpleRpcScheduler;
import org.apache.hadoop.hbase.regionserver.FifoRpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestRpcSchedulerFactory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcSchedulerFactory.class);
    @Rule
    public TestName testName = new TestName();
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
    }

    @Test
    public void testRWQ() {
        this.conf.setDouble("hbase.ipc.server.callqueue.read.ratio", 0.5);
        this.conf.setDouble("hbase.ipc.server.callqueue.handler.factor", 0.5);
        this.conf.setDouble("hbase.ipc.server.callqueue.scan.ratio", 0.5);
        SimpleRpcSchedulerFactory factory = new SimpleRpcSchedulerFactory();
        RpcScheduler rpcScheduler = factory.create(this.conf, null, null);
        Assert.assertTrue((boolean)rpcScheduler.getClass().equals(SimpleRpcScheduler.class));
    }

    @Test
    public void testFifo() {
        FifoRpcSchedulerFactory factory = new FifoRpcSchedulerFactory();
        RpcScheduler rpcScheduler = factory.create(this.conf, null, null);
        Assert.assertTrue((boolean)rpcScheduler.getClass().equals(FifoRpcScheduler.class));
    }
}

