/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

public class CatTool
implements Tool {
    private long totalCopied;
    private double sampleCounter;
    private GenericRecord reuse;
    private DataFileStream<GenericRecord> reader;
    private DataFileWriter<GenericRecord> writer;
    private Schema schema;
    private List<Path> inFiles;
    private int currentInput;

    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser optParser = new OptionParser();
        ArgumentAcceptingOptionSpec offsetOpt = optParser.accepts("offset", "offset for reading input").withRequiredArg().ofType(Long.class).defaultsTo((Object)new Long(0L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec limitOpt = optParser.accepts("limit", "maximum number of records in the outputfile").withRequiredArg().ofType(Long.class).defaultsTo((Object)Long.MAX_VALUE, (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec fracOpt = optParser.accepts("samplerate", "rate at which records will be collected").withRequiredArg().ofType(Double.class).defaultsTo((Object)new Double(1.0), (Object[])new Double[0]);
        OptionSet opts = optParser.parse(args.toArray(new String[0]));
        List nargs = opts.nonOptionArguments();
        if (nargs.size() < 2) {
            this.printHelp(out);
            return 0;
        }
        this.inFiles = Util.getFiles(nargs.subList(0, nargs.size() - 1));
        System.out.println("List of input files:");
        for (Path p : this.inFiles) {
            System.out.println(p);
        }
        this.currentInput = -1;
        this.nextInput();
        OutputStream output = out;
        String lastArg = (String)nargs.get(nargs.size() - 1);
        if (nargs.size() > 1 && !lastArg.equals("-")) {
            output = Util.createFromFS(lastArg);
        }
        this.writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        String codecName = this.reader.getMetaString("avro.codec");
        CodecFactory codec = codecName == null ? CodecFactory.fromString((String)"null") : CodecFactory.fromString((String)codecName);
        this.writer.setCodec(codec);
        for (String key : this.reader.getMetaKeys()) {
            if (DataFileWriter.isReservedMeta((String)key)) continue;
            this.writer.setMeta(key, this.reader.getMeta(key));
        }
        this.writer.create(this.schema, output);
        long offset = (Long)opts.valueOf((OptionSpec)offsetOpt);
        long limit = (Long)opts.valueOf((OptionSpec)limitOpt);
        double samplerate = (Double)opts.valueOf((OptionSpec)fracOpt);
        this.sampleCounter = 1.0;
        this.totalCopied = 0L;
        this.reuse = null;
        if (limit < 0L) {
            System.out.println("limit has to be non-negative");
            this.printHelp(out);
            return 1;
        }
        if (offset < 0L) {
            System.out.println("offset has to be non-negative");
            this.printHelp(out);
            return 1;
        }
        if (samplerate < 0.0 || samplerate > 1.0) {
            System.out.println("samplerate has to be a number between 0 and 1");
            this.printHelp(out);
            return 1;
        }
        this.skip(offset);
        this.writeRecords(limit, samplerate);
        System.out.println(this.totalCopied + " records written.");
        this.writer.flush();
        this.writer.close();
        Util.close(out);
        return 0;
    }

    private void nextInput() throws IOException {
        ++this.currentInput;
        Path path = this.inFiles.get(this.currentInput);
        FSDataInputStream input = new FSDataInputStream(Util.openFromFS(path));
        this.reader = new DataFileStream((InputStream)input, (DatumReader)new GenericDatumReader());
        if (this.schema == null) {
            this.schema = this.reader.getSchema();
        } else if (!this.schema.equals((Object)this.reader.getSchema())) {
            throw new IOException("schemas dont match");
        }
    }

    private boolean hasNextInput() {
        return this.inFiles.size() > this.currentInput + 1;
    }

    private long skip(long skip) throws IOException {
        long skipped = 0L;
        while (0L < skip && this.reader.hasNext()) {
            this.reader.next((Object)this.reuse);
            --skip;
            ++skipped;
        }
        if (0L < skip && this.hasNextInput()) {
            this.nextInput();
            skipped += this.skip(skip);
        }
        return skipped;
    }

    private long writeRecords(long count, double samplerate) throws IOException {
        long written = 0L;
        while (written < count && this.reader.hasNext()) {
            this.reuse = (GenericRecord)this.reader.next((Object)this.reuse);
            this.sampleCounter += samplerate;
            if (!(this.sampleCounter >= 1.0)) continue;
            this.writer.append((Object)this.reuse);
            ++written;
            this.sampleCounter -= 1.0;
        }
        this.totalCopied += written;
        if (written < count && this.hasNextInput()) {
            this.nextInput();
            written += this.writeRecords(count - written, samplerate);
        }
        return written;
    }

    private void printHelp(PrintStream out) {
        out.println("cat --offset <offset> --limit <limit> --samplerate <samplerate> [input-files...] output-file");
        out.println();
        out.println("extracts records from a list of input files into a new file.");
        out.println("--offset      start of the extract");
        out.println("--limit       maximum number of records in the output file.");
        out.println("--samplerate  rate at which records will be collected");
        out.println("A dash ('-') can be given to direct output to stdout");
    }

    @Override
    public String getName() {
        return "cat";
    }

    @Override
    public String getShortDescription() {
        return "extracts samples from files";
    }
}

