/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.TColumn;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.accumulo.core.master.thrift.FateOperation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.KerberosAuthenticator;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKAuthenticator;
import org.apache.accumulo.server.security.handler.ZKAuthorizor;
import org.apache.accumulo.server.security.handler.ZKPermHandler;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOperation {
    private static final Logger log = LoggerFactory.getLogger(SecurityOperation.class);
    protected Authorizor authorizor;
    protected Authenticator authenticator;
    protected PermissionHandler permHandle;
    protected boolean isKerberos;
    private static String rootUserName = null;
    private final ZooCache zooCache;
    private final String ZKUserPath;
    protected final AccumuloServerContext context;
    static SecurityOperation instance;

    public static synchronized SecurityOperation getInstance(AccumuloServerContext context, boolean initialize) {
        if (instance == null) {
            String instanceId = context.getInstance().getInstanceID();
            instance = new SecurityOperation(context, SecurityOperation.getAuthorizor(instanceId, initialize), SecurityOperation.getAuthenticator(instanceId, initialize), SecurityOperation.getPermHandler(instanceId, initialize));
        }
        return instance;
    }

    protected static Authorizor getAuthorizor(String instanceId, boolean initialize) {
        Authorizor toRet = (Authorizor)SiteConfiguration.getInstance().instantiateClassProperty(Property.INSTANCE_SECURITY_AUTHORIZOR, Authorizor.class, (Object)ZKAuthorizor.getInstance());
        toRet.initialize(instanceId, initialize);
        return toRet;
    }

    protected static Authenticator getAuthenticator(String instanceId, boolean initialize) {
        Authenticator toRet = (Authenticator)SiteConfiguration.getInstance().instantiateClassProperty(Property.INSTANCE_SECURITY_AUTHENTICATOR, Authenticator.class, (Object)ZKAuthenticator.getInstance());
        toRet.initialize(instanceId, initialize);
        return toRet;
    }

    protected static PermissionHandler getPermHandler(String instanceId, boolean initialize) {
        PermissionHandler toRet = (PermissionHandler)SiteConfiguration.getInstance().instantiateClassProperty(Property.INSTANCE_SECURITY_PERMISSION_HANDLER, PermissionHandler.class, (Object)ZKPermHandler.getInstance());
        toRet.initialize(instanceId, initialize);
        return toRet;
    }

    protected SecurityOperation(AccumuloServerContext context) {
        this.context = context;
        this.ZKUserPath = "/accumulo/" + context.getInstance().getInstanceID() + "/users";
        this.zooCache = new ZooCache();
    }

    public SecurityOperation(AccumuloServerContext context, Authorizor author, Authenticator authent, PermissionHandler pm) {
        this(context);
        this.authorizor = author;
        this.authenticator = authent;
        this.permHandle = pm;
        if (!(this.authorizor.validSecurityHandlers(this.authenticator, pm) && this.authenticator.validSecurityHandlers(this.authorizor, pm) && this.permHandle.validSecurityHandlers(authent, author))) {
            throw new RuntimeException(this.authorizor + ", " + this.authenticator + ", and " + pm + " do not play nice with eachother. Please choose authentication and authorization mechanisms that are compatible with one another.");
        }
        this.isKerberos = KerberosAuthenticator.class.isAssignableFrom(this.authenticator.getClass());
    }

    public void initializeSecurity(TCredentials credentials, String rootPrincipal, byte[] token) throws AccumuloSecurityException, ThriftSecurityException {
        if (!this.isSystemUser(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.authenticator.initializeSecurity(credentials, rootPrincipal, token);
        this.authorizor.initializeSecurity(credentials, rootPrincipal);
        this.permHandle.initializeSecurity(credentials, rootPrincipal);
        try {
            this.permHandle.grantTablePermission(rootPrincipal, "!0", TablePermission.ALTER_TABLE);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized String getRootUsername() {
        if (rootUserName == null) {
            rootUserName = new String(this.zooCache.get(this.ZKUserPath), StandardCharsets.UTF_8);
        }
        return rootUserName;
    }

    public boolean isSystemUser(TCredentials credentials) {
        return this.context.getCredentials().getToken().getClass().getName().equals(credentials.getTokenClassName());
    }

    protected void authenticate(TCredentials credentials) throws ThriftSecurityException {
        if (!credentials.getInstanceId().equals(this.context.getInstance().getInstanceID())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.INVALID_INSTANCEID);
        }
        Credentials creds = Credentials.fromThrift((TCredentials)credentials);
        if (this.isSystemUser(credentials)) {
            if (this.isKerberos) {
                if (!this.context.getCredentials().getToken().equals(creds.getToken())) {
                    log.debug("With SASL enabled, System AuthenticationTokens did not match.");
                    throw new ThriftSecurityException(creds.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
                }
            } else if (!this.context.getCredentials().equals((Object)creds)) {
                log.debug("Provided credentials did not match server's expected credentials. Expected " + this.context.getCredentials() + " but got " + creds);
                throw new ThriftSecurityException(creds.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
            }
        } else {
            block16: {
                if (this.isKerberos) {
                    try {
                        if (this.authenticator.userExists(creds.getPrincipal())) break block16;
                        try {
                            this._createUser(credentials, creds, Authorizations.EMPTY);
                        }
                        catch (ThriftSecurityException e) {
                            if (SecurityErrorCode.USER_EXISTS != e.getCode()) {
                                throw e;
                            }
                        }
                    }
                    catch (AccumuloSecurityException e) {
                        log.debug("Failed to determine if user exists", (Throwable)e);
                        throw e.asThriftException();
                    }
                }
            }
            try {
                if (!this.authenticator.authenticateUser(creds.getPrincipal(), creds.getToken())) {
                    throw new ThriftSecurityException(creds.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
                }
            }
            catch (AccumuloSecurityException e) {
                log.debug("AccumuloSecurityException", (Throwable)e);
                throw e.asThriftException();
            }
        }
    }

    public boolean canAskAboutUser(TCredentials credentials, String user) throws ThriftSecurityException {
        if (!this.canPerformSystemActions(credentials) && !credentials.getPrincipal().equals(user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return true;
    }

    public boolean authenticateUser(TCredentials credentials, TCredentials toAuth) throws ThriftSecurityException {
        this.canAskAboutUser(credentials, toAuth.getPrincipal());
        if (credentials.equals(toAuth)) {
            return true;
        }
        try {
            Credentials toCreds = Credentials.fromThrift((TCredentials)toAuth);
            if (this.isKerberos && !this.authenticator.userExists(toCreds.getPrincipal())) {
                this.createUser(credentials, toCreds, Authorizations.EMPTY);
            }
            return this.authenticator.authenticateUser(toCreds.getPrincipal(), toCreds.getToken());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public Authorizations getUserAuthorizations(TCredentials credentials, String user) throws ThriftSecurityException {
        this.authenticate(credentials);
        this.targetUserExists(user);
        if (!(credentials.getPrincipal().equals(user) || this.hasSystemPermission(credentials, SystemPermission.SYSTEM, false) || this.hasSystemPermission(credentials, SystemPermission.ALTER_USER, false))) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            return this.authorizor.getCachedUserAuthorizations(user);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public Authorizations getUserAuthorizations(TCredentials credentials) throws ThriftSecurityException {
        if (this.isSystemUser(credentials)) {
            this.authenticate(credentials);
            return Authorizations.EMPTY;
        }
        return this.getUserAuthorizations(credentials, credentials.getPrincipal());
    }

    public boolean authenticatedUserHasAuthorizations(TCredentials credentials, List<ByteBuffer> list) throws ThriftSecurityException {
        if (this.isSystemUser(credentials)) {
            return list.isEmpty();
        }
        try {
            return this.authorizor.isValidAuthorizations(credentials.getPrincipal(), list);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    private boolean hasSystemPermission(TCredentials credentials, SystemPermission permission, boolean useCached) throws ThriftSecurityException {
        return this.hasSystemPermissionWithNamespaceId(credentials, permission, null, useCached);
    }

    private boolean hasSystemPermissionWithNamespaceId(TCredentials credentials, SystemPermission permission, String namespaceId, boolean useCached) throws ThriftSecurityException {
        if (this.isSystemUser(credentials)) {
            return true;
        }
        if (this._hasSystemPermission(credentials.getPrincipal(), permission, useCached)) {
            return true;
        }
        if (namespaceId != null) {
            return this._hasNamespacePermission(credentials.getPrincipal(), namespaceId, NamespacePermission.getEquivalent((SystemPermission)permission), useCached);
        }
        return false;
    }

    private boolean _hasSystemPermission(String user, SystemPermission permission, boolean useCached) throws ThriftSecurityException {
        if (user.equals(this.getRootUsername())) {
            return true;
        }
        this.targetUserExists(user);
        try {
            if (useCached) {
                return this.permHandle.hasCachedSystemPermission(user, permission);
            }
            return this.permHandle.hasSystemPermission(user, permission);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    protected boolean hasTablePermission(TCredentials credentials, String tableId, String namespaceId, TablePermission permission, boolean useCached) throws ThriftSecurityException {
        if (this.isSystemUser(credentials)) {
            return true;
        }
        return this._hasTablePermission(credentials.getPrincipal(), tableId, permission, useCached) || this._hasNamespacePermission(credentials.getPrincipal(), namespaceId, NamespacePermission.getEquivalent((TablePermission)permission), useCached);
    }

    protected boolean _hasTablePermission(String user, String table, TablePermission permission, boolean useCached) throws ThriftSecurityException {
        this.targetUserExists(user);
        if ((table.equals("!0") || table.equals("+r") || table.equals("+rep")) && permission.equals((Object)TablePermission.READ)) {
            return true;
        }
        try {
            if (useCached) {
                return this.permHandle.hasCachedTablePermission(user, table, permission);
            }
            return this.permHandle.hasTablePermission(user, table, permission);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(user, SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    protected boolean _hasNamespacePermission(String user, String namespace, NamespacePermission permission, boolean useCached) throws ThriftSecurityException {
        if (permission == null) {
            return false;
        }
        this.targetUserExists(user);
        if (namespace.equals("+accumulo") && permission.equals((Object)NamespacePermission.READ)) {
            return true;
        }
        try {
            if (useCached) {
                return this.permHandle.hasCachedNamespacePermission(user, namespace, permission);
            }
            return this.permHandle.hasNamespacePermission(user, namespace, permission);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftSecurityException(user, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
    }

    private boolean canAskAboutOtherUsers(TCredentials credentials, String user) throws ThriftSecurityException {
        this.authenticate(credentials);
        return credentials.getPrincipal().equals(user) || this.hasSystemPermission(credentials, SystemPermission.SYSTEM, false) || this.hasSystemPermission(credentials, SystemPermission.CREATE_USER, false) || this.hasSystemPermission(credentials, SystemPermission.ALTER_USER, false) || this.hasSystemPermission(credentials, SystemPermission.DROP_USER, false);
    }

    private void targetUserExists(String user) throws ThriftSecurityException {
        if (user.equals(this.getRootUsername())) {
            return;
        }
        try {
            if (!this.authenticator.userExists(user)) {
                throw new ThriftSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST);
            }
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public boolean canScan(TCredentials credentials, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.READ, true);
    }

    public boolean canScan(TCredentials credentials, String tableId, String namespaceId, TRange range, List<TColumn> columns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        return this.canScan(credentials, tableId, namespaceId);
    }

    public boolean canScan(TCredentials credentials, String table, String namespaceId, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        return this.canScan(credentials, table, namespaceId);
    }

    public boolean canWrite(TCredentials credentials, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.WRITE, true);
    }

    public boolean canConditionallyUpdate(TCredentials credentials, String tableID, String namespaceId, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableID, namespaceId, TablePermission.WRITE, true) && this.hasTablePermission(credentials, tableID, namespaceId, TablePermission.READ, true);
    }

    public boolean canSplitTablet(TCredentials credentials, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.SYSTEM, namespaceId, false) || this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canPerformSystemActions(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials, SystemPermission.SYSTEM, false);
    }

    public boolean canFlush(TCredentials c, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c, tableId, namespaceId, TablePermission.WRITE, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canAlterTable(TCredentials c, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false) || this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false);
    }

    public boolean canCreateTable(TCredentials c, String table, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.CREATE_TABLE, namespaceId, false);
    }

    public boolean canRenameTable(TCredentials c, String tableId, String oldTableName, String newTableName, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canCloneTable(TCredentials c, String tableId, String tableName, String destinationNamespaceId, String srcNamespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.CREATE_TABLE, destinationNamespaceId, false) && this.hasTablePermission(c, tableId, srcNamespaceId, TablePermission.READ, false);
    }

    public boolean canDeleteTable(TCredentials c, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.DROP_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.DROP_TABLE, false);
    }

    public boolean canOnlineOfflineTable(TCredentials c, String tableId, FateOperation op, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.SYSTEM, namespaceId, false) || this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canMerge(TCredentials c, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.SYSTEM, namespaceId, false) || this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canDeleteRange(TCredentials c, String tableId, String tableName, Text startRow, Text endRow, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.SYSTEM, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.WRITE, false);
    }

    public boolean canBulkImport(TCredentials c, String tableId, String tableName, String dir, String failDir, String namespaceId) throws ThriftSecurityException {
        return this.canBulkImport(c, tableId, namespaceId);
    }

    public boolean canBulkImport(TCredentials c, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c, tableId, namespaceId, TablePermission.BULK_IMPORT, false);
    }

    public boolean canCompact(TCredentials c, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.WRITE, false);
    }

    public boolean canChangeAuthorizations(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c, SystemPermission.ALTER_USER, false);
    }

    public boolean canChangePassword(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        return c.getPrincipal().equals(user) || this.hasSystemPermission(c, SystemPermission.ALTER_USER, false);
    }

    public boolean canCreateUser(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c, SystemPermission.CREATE_USER, false);
    }

    public boolean canDropUser(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals(this.getRootUsername())) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c, SystemPermission.DROP_USER, false);
    }

    public boolean canGrantSystem(TCredentials c, String user, SystemPermission sysPerm) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c, SystemPermission.GRANT, false);
    }

    public boolean canGrantTable(TCredentials c, String user, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.GRANT, false);
    }

    public boolean canGrantNamespace(TCredentials c, String user, String namespace) throws ThriftSecurityException {
        return this.canModifyNamespacePermission(c, user, namespace);
    }

    private boolean canModifyNamespacePermission(TCredentials c, String user, String namespace) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_NAMESPACE, namespace, false) || this.hasNamespacePermission(c, c.principal, namespace, NamespacePermission.GRANT);
    }

    public boolean canRevokeSystem(TCredentials c, String user, SystemPermission sysPerm) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals(this.getRootUsername())) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c, SystemPermission.GRANT, false);
    }

    public boolean canRevokeTable(TCredentials c, String user, String tableId, String namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.GRANT, false);
    }

    public boolean canRevokeNamespace(TCredentials c, String user, String namespace) throws ThriftSecurityException {
        return this.canModifyNamespacePermission(c, user, namespace);
    }

    public void changeAuthorizations(TCredentials credentials, String user, Authorizations authorizations) throws ThriftSecurityException {
        if (!this.canChangeAuthorizations(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.authorizor.changeAuthorizations(user, authorizations);
            log.info("Changed authorizations for user " + user + " at the request of user " + credentials.getPrincipal());
        }
        catch (AccumuloSecurityException ase) {
            throw ase.asThriftException();
        }
    }

    public void changePassword(TCredentials credentials, Credentials toChange) throws ThriftSecurityException {
        if (!this.canChangePassword(credentials, toChange.getPrincipal())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            AuthenticationToken token = toChange.getToken();
            this.authenticator.changePassword(toChange.getPrincipal(), token);
            log.info("Changed password for user " + toChange.getPrincipal() + " at the request of user " + credentials.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void createUser(TCredentials credentials, Credentials newUser, Authorizations authorizations) throws ThriftSecurityException {
        if (!this.canCreateUser(credentials, newUser.getPrincipal())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this._createUser(credentials, newUser, authorizations);
        if (this.canChangeAuthorizations(credentials, newUser.getPrincipal())) {
            try {
                this.authorizor.changeAuthorizations(newUser.getPrincipal(), authorizations);
            }
            catch (AccumuloSecurityException ase) {
                throw ase.asThriftException();
            }
        }
    }

    protected void _createUser(TCredentials credentials, Credentials newUser, Authorizations authorizations) throws ThriftSecurityException {
        try {
            AuthenticationToken token = newUser.getToken();
            this.authenticator.createUser(newUser.getPrincipal(), token);
            this.authorizor.initUser(newUser.getPrincipal());
            this.permHandle.initUser(newUser.getPrincipal());
            log.info("Created user " + newUser.getPrincipal() + " at the request of user " + credentials.getPrincipal());
        }
        catch (AccumuloSecurityException ase) {
            throw ase.asThriftException();
        }
    }

    public void dropUser(TCredentials credentials, String user) throws ThriftSecurityException {
        if (!this.canDropUser(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            this.authorizor.dropUser(user);
            this.authenticator.dropUser(user);
            this.permHandle.cleanUser(user);
            log.info("Deleted user " + user + " at the request of user " + credentials.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void grantSystemPermission(TCredentials credentials, String user, SystemPermission permissionById) throws ThriftSecurityException {
        if (!this.canGrantSystem(credentials, user, permissionById)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.grantSystemPermission(user, permissionById);
            log.info("Granted system permission " + permissionById + " for user " + user + " at the request of user " + credentials.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void grantTablePermission(TCredentials c, String user, String tableId, TablePermission permission, String namespaceId) throws ThriftSecurityException {
        if (!this.canGrantTable(c, user, tableId, namespaceId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.grantTablePermission(user, tableId, permission);
            log.info("Granted table permission " + permission + " for user " + user + " on the table " + tableId + " at the request of user " + c.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public void grantNamespacePermission(TCredentials c, String user, String namespace, NamespacePermission permission) throws ThriftSecurityException {
        if (!this.canGrantNamespace(c, user, namespace)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.grantNamespacePermission(user, namespace, permission);
            log.info("Granted namespace permission " + permission + " for user " + user + " on the namespace " + namespace + " at the request of user " + c.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
    }

    public void revokeSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        if (!this.canRevokeSystem(credentials, user, permission)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.revokeSystemPermission(user, permission);
            log.info("Revoked system permission " + permission + " for user " + user + " at the request of user " + credentials.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void revokeTablePermission(TCredentials c, String user, String tableId, TablePermission permission, String namespaceId) throws ThriftSecurityException {
        if (!this.canRevokeTable(c, user, tableId, namespaceId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.revokeTablePermission(user, tableId, permission);
            log.info("Revoked table permission " + permission + " for user " + user + " on the table " + tableId + " at the request of user " + c.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public void revokeNamespacePermission(TCredentials c, String user, String namespace, NamespacePermission permission) throws ThriftSecurityException {
        if (!this.canRevokeNamespace(c, user, namespace)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.revokeNamespacePermission(user, namespace, permission);
            log.info("Revoked namespace permission " + permission + " for user " + user + " on the namespace " + namespace + " at the request of user " + c.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
    }

    public boolean hasSystemPermission(TCredentials credentials, String user, SystemPermission permissionById) throws ThriftSecurityException {
        if (!this.canAskAboutOtherUsers(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this._hasSystemPermission(user, permissionById, false);
    }

    public boolean hasTablePermission(TCredentials credentials, String user, String tableId, TablePermission permissionById) throws ThriftSecurityException {
        if (!this.canAskAboutOtherUsers(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this._hasTablePermission(user, tableId, permissionById, false);
    }

    public boolean hasNamespacePermission(TCredentials credentials, String user, String namespace, NamespacePermission permissionById) throws ThriftSecurityException {
        if (!this.canAskAboutOtherUsers(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this._hasNamespacePermission(user, namespace, permissionById, false);
    }

    public Set<String> listUsers(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        try {
            return this.authenticator.listUsers();
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void deleteTable(TCredentials credentials, String tableId, String namespaceId) throws ThriftSecurityException {
        if (!this.canDeleteTable(credentials, tableId, namespaceId)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            this.permHandle.cleanTablePermissions(tableId);
        }
        catch (AccumuloSecurityException e) {
            e.setUser(credentials.getPrincipal());
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public void deleteNamespace(TCredentials credentials, String namespace) throws ThriftSecurityException {
        if (!this.canDeleteNamespace(credentials, namespace)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            this.permHandle.cleanNamespacePermissions(namespace);
        }
        catch (AccumuloSecurityException e) {
            e.setUser(credentials.getPrincipal());
            throw e.asThriftException();
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
    }

    public boolean canExport(TCredentials credentials, String tableId, String tableName, String exportDir, String namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.READ, false);
    }

    public boolean canImport(TCredentials credentials, String tableName, String importDir, String namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.CREATE_TABLE, namespaceId, false);
    }

    public boolean canAlterNamespace(TCredentials credentials, String namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.ALTER_NAMESPACE, namespaceId, false);
    }

    public boolean canCreateNamespace(TCredentials credentials, String namespace) throws ThriftSecurityException {
        return this.canCreateNamespace(credentials);
    }

    private boolean canCreateNamespace(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials, SystemPermission.CREATE_NAMESPACE, false);
    }

    public boolean canDeleteNamespace(TCredentials credentials, String namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.DROP_NAMESPACE, namespaceId, false);
    }

    public boolean canRenameNamespace(TCredentials credentials, String namespaceId, String oldName, String newName) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.ALTER_NAMESPACE, namespaceId, false);
    }

    public boolean canObtainDelegationToken(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials, SystemPermission.OBTAIN_DELEGATION_TOKEN, false);
    }
}

