/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKReplicationStorageBase {
    public static final String REPLICATION_ZNODE = "zookeeper.znode.replication";
    public static final String REPLICATION_ZNODE_DEFAULT = "replication";
    protected final String replicationZNode;
    protected final ZKWatcher zookeeper;
    protected final Configuration conf;

    protected ZKReplicationStorageBase(ZKWatcher zookeeper, Configuration conf) {
        this.zookeeper = zookeeper;
        this.conf = conf;
        this.replicationZNode = ZNodePaths.joinZNode((String)this.zookeeper.getZNodePaths().baseZNode, (String)conf.get(REPLICATION_ZNODE, REPLICATION_ZNODE_DEFAULT));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static byte[] toByteArray(ReplicationProtos.ReplicationState.State state) {
        ReplicationProtos.ReplicationState msg = ReplicationProtos.ReplicationState.newBuilder().setState(state).build();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)baos, (int)16);
            msg.writeTo(cos);
            cos.flush();
            baos.flush();
            byte[] byArray = ProtobufUtil.prependPBMagic((byte[])baos.toByteArray());
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

