/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ReversedScannerCallable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={ClientTests.class, SmallTests.class})
public class TestReversedScannerCallable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReversedScannerCallable.class);
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestReversedScannerCallable");
    private static final String HOSTNAME = "localhost";
    private static final ServerName SERVERNAME = ServerName.valueOf((String)"localhost", (int)60030, (long)123L);
    private static final byte[] ROW = Bytes.toBytes((String)"row1");
    private static final Scan DEFAULT_SCAN = new Scan().withStartRow(ROW, true).setReversed(true);
    @Mock
    private ClusterConnection connection;
    @Mock
    private RpcControllerFactory rpcFactory;
    @Mock
    private RegionLocations regionLocations;
    @Mock
    private HRegionLocation regionLocation;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.connection.getConfiguration()).thenReturn((Object)new Configuration());
        Mockito.when((Object)this.regionLocations.size()).thenReturn((Object)1);
        Mockito.when((Object)this.regionLocations.getRegionLocation(0)).thenReturn((Object)this.regionLocation);
        Mockito.when((Object)this.regionLocation.getHostname()).thenReturn((Object)HOSTNAME);
        Mockito.when((Object)this.regionLocation.getServerName()).thenReturn((Object)SERVERNAME);
    }

    @Test
    public void testPrepareAlwaysUsesCache() throws Exception {
        Mockito.when((Object)this.connection.locateRegion(TABLE_NAME, ROW, true, true, 0)).thenReturn((Object)this.regionLocations);
        ReversedScannerCallable callable = new ReversedScannerCallable(this.connection, TABLE_NAME, DEFAULT_SCAN, null, this.rpcFactory, 0);
        callable.prepare(false);
        callable.prepare(true);
        ((ClusterConnection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)2))).locateRegion(TABLE_NAME, ROW, true, true, 0);
    }

    @Test
    public void testHandleDisabledTable() throws IOException {
        Mockito.when((Object)this.connection.isTableDisabled(TABLE_NAME)).thenReturn((Object)true);
        ReversedScannerCallable callable = new ReversedScannerCallable(this.connection, TABLE_NAME, DEFAULT_SCAN, null, this.rpcFactory, 0);
        Assert.assertThrows(TableNotEnabledException.class, () -> callable.prepare(true));
    }

    @Test
    public void testUpdateSearchKeyCacheLocation() throws IOException {
        byte[] regionName = RegionInfo.createRegionName((TableName)TABLE_NAME, (byte[])ConnectionUtils.createCloseRowBefore((byte[])ConnectionUtils.MAX_BYTE_ARRAY), (String)"123", (boolean)false);
        HRegionInfo mockRegionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        Mockito.when((Object)mockRegionInfo.containsRow(ConnectionUtils.MAX_BYTE_ARRAY)).thenReturn((Object)true);
        Mockito.when((Object)mockRegionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_END_ROW);
        Mockito.when((Object)mockRegionInfo.getRegionName()).thenReturn((Object)regionName);
        Mockito.when((Object)this.regionLocation.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        IOException testThrowable = new IOException("test throwable");
        Mockito.when((Object)this.connection.locateRegion(TABLE_NAME, ConnectionUtils.MAX_BYTE_ARRAY, true, true, 0)).thenReturn((Object)this.regionLocations);
        Scan scan = new Scan().setReversed(true);
        ReversedScannerCallable callable = new ReversedScannerCallable(this.connection, TABLE_NAME, scan, null, this.rpcFactory, 0);
        callable.prepare(false);
        callable.throwable((Throwable)testThrowable, true);
        ((ClusterConnection)Mockito.verify((Object)this.connection)).updateCachedLocations(TABLE_NAME, regionName, ConnectionUtils.MAX_BYTE_ARRAY, (Object)testThrowable, SERVERNAME);
    }
}

