/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestSaslUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSaslUtil.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testInitSaslProperties() {
        Map props = SaslUtil.initSaslProperties((String)"integrity");
        Assert.assertEquals((Object)"auth-int", props.get("javax.security.sasl.qop"));
        props = SaslUtil.initSaslProperties((String)"privacy,authentication");
        Assert.assertEquals((Object)"auth-conf,auth", props.get("javax.security.sasl.qop"));
        props = SaslUtil.initSaslProperties((String)"integrity,authentication,privacy");
        Assert.assertEquals((Object)"auth-int,auth,auth-conf", props.get("javax.security.sasl.qop"));
        this.exception.expect(IllegalArgumentException.class);
        props = SaslUtil.initSaslProperties((String)"xyz");
        Assert.assertEquals((Object)"auth", props.get("javax.security.sasl.qop"));
        this.exception.expect(IllegalArgumentException.class);
        props = SaslUtil.initSaslProperties((String)"");
        Assert.assertEquals((Object)"auth", props.get("javax.security.sasl.qop"));
    }
}

