/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.optimizer;

import java.util.Collection;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCube;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

public abstract class AllExpressionVisitor
extends LogicalRelationalNodesVisitor {
    protected LogicalRelationalOperator currentOp;

    public AllExpressionVisitor(OperatorPlan plan, PlanWalker walker) throws FrontendException {
        super(plan, walker);
    }

    protected abstract LogicalExpressionVisitor getVisitor(LogicalExpressionPlan var1) throws FrontendException;

    private void visitAll(Collection<LogicalExpressionPlan> lexpPlans) throws FrontendException {
        for (LogicalExpressionPlan plan : lexpPlans) {
            LogicalExpressionVisitor v = this.getVisitor(plan);
            v.visit();
        }
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
        this.currentOp = filter;
        LogicalExpressionVisitor v = this.getVisitor(filter.getFilterPlan());
        v.visit();
    }

    @Override
    public void visit(LOLimit limit) throws FrontendException {
        this.currentOp = limit;
        if (limit.getLimitPlan() != null) {
            LogicalExpressionVisitor v = this.getVisitor(limit.getLimitPlan());
            v.visit();
        }
    }

    @Override
    public void visit(LOJoin join) throws FrontendException {
        this.currentOp = join;
        this.visitAll(join.getExpressionPlanValues());
    }

    @Override
    public void visit(LOCube cu) throws FrontendException {
        this.currentOp = cu;
        MultiMap<Integer, LogicalExpressionPlan> expressionPlans = cu.getExpressionPlans();
        for (Integer key : expressionPlans.keySet()) {
            this.visitAll(expressionPlans.get(key));
        }
    }

    @Override
    public void visit(LOCogroup cg) throws FrontendException {
        this.currentOp = cg;
        MultiMap<Integer, LogicalExpressionPlan> expressionPlans = cg.getExpressionPlans();
        for (Integer key : expressionPlans.keySet()) {
            this.visitAll(expressionPlans.get(key));
        }
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        this.currentOp = foreach;
        LogicalPlan innerPlan = foreach.getInnerPlan();
        PlanWalker newWalker = this.currentWalker.spawnChildWalker(innerPlan);
        this.pushWalker(newWalker);
        this.currentWalker.walk(this);
        this.popWalker();
    }

    @Override
    public void visit(LOGenerate gen) throws FrontendException {
        this.currentOp = gen;
        this.visitAll(gen.getOutputPlans());
    }

    @Override
    public void visit(LOInnerLoad load) throws FrontendException {
        this.currentOp = load.getLOForEach();
        LogicalExpressionPlan exp = (LogicalExpressionPlan)load.getProjection().getPlan();
        LogicalExpressionVisitor v = this.getVisitor(exp);
        v.visit();
    }

    @Override
    public void visit(LOSplitOutput splitOutput) throws FrontendException {
        this.currentOp = splitOutput;
        LogicalExpressionVisitor v = this.getVisitor(splitOutput.getFilterPlan());
        v.visit();
    }

    @Override
    public void visit(LORank rank) throws FrontendException {
        this.currentOp = rank;
        this.visitAll(rank.getRankColPlans());
    }

    @Override
    public void visit(LOSort sort) throws FrontendException {
        this.currentOp = sort;
        this.visitAll(sort.getSortColPlans());
    }
}

