/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.SchemaClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/erosb/jsonsKema/ClassPathAwareSchemaClient;", "Lcom/github/erosb/jsonsKema/SchemaClient;", "fallbackClient", "(Lcom/github/erosb/jsonsKema/SchemaClient;)V", "get", "Ljava/io/InputStream;", "url", "Ljava/net/URI;", "handleProtocol", "Ljava/util/Optional;", "", "loadFromClasspath", "str", "Companion", "json-sKema"})
public final class ClassPathAwareSchemaClient
implements SchemaClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaClient fallbackClient;
    @NotNull
    private static final List<String> HANDLED_PREFIXES;

    public ClassPathAwareSchemaClient(@NotNull SchemaClient fallbackClient) {
        Intrinsics.checkNotNullParameter(fallbackClient, "fallbackClient");
        this.fallbackClient = fallbackClient;
    }

    @Override
    @NotNull
    public InputStream get(@NotNull URI url) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter(url, "url");
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        Optional<String> maybeString = this.handleProtocol(string);
        if (maybeString.isPresent()) {
            String string2 = maybeString.get();
            Intrinsics.checkNotNullExpressionValue(string2, "get(...)");
            InputStream stream = this.loadFromClasspath(string2);
            inputStream = stream;
            if (inputStream == null) {
                String string3 = "Could not find %s";
                Object[] objectArray = new Object[]{url};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
                throw new UncheckedIOException(new IOException(string4));
            }
        } else {
            inputStream = this.fallbackClient.get(url);
        }
        return inputStream;
    }

    private final InputStream loadFromClasspath(String str) {
        return this.getClass().getResourceAsStream(str);
    }

    private final Optional<String> handleProtocol(String url) {
        Optional<String> optional = HANDLED_PREFIXES.stream().filter(arg_0 -> ClassPathAwareSchemaClient.handleProtocol$lambda$0(new Function1<String, Boolean>(url){
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable String prefix) {
                String string = prefix;
                Intrinsics.checkNotNull(string);
                return StringsKt.startsWith$default(this.$url, string, false, 2, null);
            }
        }, arg_0)).map(arg_0 -> ClassPathAwareSchemaClient.handleProtocol$lambda$1(new Function1<String, String>(url){
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(1);
            }

            public final String invoke(@NotNull String prefix) {
                Intrinsics.checkNotNullParameter(prefix, "prefix");
                StringBuilder stringBuilder = new StringBuilder().append('/');
                String string = this.$url.substring(prefix.length());
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                return stringBuilder.append(string).toString();
            }
        }, arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, "findFirst(...)");
        return optional;
    }

    @Override
    @NotNull
    public IJsonValue getParsed(@NotNull URI uri) {
        return SchemaClient.DefaultImpls.getParsed(this, uri);
    }

    private static final boolean handleProtocol$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String handleProtocol$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    static {
        String[] stringArray = new String[]{"classpath://", "classpath:/", "classpath:"};
        HANDLED_PREFIXES = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/erosb/jsonsKema/ClassPathAwareSchemaClient$Companion;", "", "()V", "HANDLED_PREFIXES", "", "", "json-sKema"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

