/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import io.confluent.kafka.schemaregistry.json.jackson.JSONObjectDeserializer;
import java.io.IOException;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.util.ClassUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONArrayDeserializer
extends StdDeserializer<JSONArray> {
    private static final long serialVersionUID = 1L;
    public static final JSONArrayDeserializer instance = new JSONArrayDeserializer();

    public JSONArrayDeserializer() {
        super(JSONArray.class);
    }

    @Override
    public JSONArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2;
        if (!p.isExpectedStartArrayToken()) {
            JsonToken t3 = p.currentToken();
            return (JSONArray)ctxt.handleUnexpectedToken(this.handledType(), t3, p, "Unexpected token (%s), expected START_ARRAY for %s value", new Object[]{t3, ClassUtil.nameOf(this.handledType())});
        }
        JSONArray array = new JSONArray();
        block11: while ((t2 = p.nextToken()) != JsonToken.END_ARRAY) {
            switch (t2) {
                case START_ARRAY: {
                    array.put(this.deserialize(p, ctxt));
                    continue block11;
                }
                case START_OBJECT: {
                    array.put(JSONObjectDeserializer.instance.deserialize(p, ctxt));
                    continue block11;
                }
                case VALUE_STRING: {
                    array.put(p.getText());
                    continue block11;
                }
                case VALUE_NULL: {
                    array.put(JSONObject.NULL);
                    continue block11;
                }
                case VALUE_TRUE: {
                    array.put(Boolean.TRUE);
                    continue block11;
                }
                case VALUE_FALSE: {
                    array.put(Boolean.FALSE);
                    continue block11;
                }
                case VALUE_NUMBER_INT: {
                    Number num = p.getNumberValue();
                    if (num instanceof Byte || num instanceof Short) {
                        num = num.intValue();
                    }
                    array.put(num);
                    continue block11;
                }
                case VALUE_NUMBER_FLOAT: {
                    array.put(p.getNumberValue());
                    continue block11;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object o = p.getEmbeddedObject();
                    if (o instanceof byte[]) {
                        o = p.getText();
                    }
                    array.put(o);
                    continue block11;
                }
            }
            return (JSONArray)ctxt.handleUnexpectedToken(this.handledType(), p);
        }
        return array;
    }
}

