/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.LogicalType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableRangeSet;
import org.apache.pinot.shaded.com.google.common.collect.Range;
import org.apache.pinot.shaded.com.google.common.collect.RangeSet;

public class RangeSetDeserializer
extends StdDeserializer<RangeSet<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    private final JsonDeserializer<Object> _deserializer;

    public RangeSetDeserializer() {
        super(RangeSet.class);
        this._deserializer = null;
    }

    protected RangeSetDeserializer(RangeSetDeserializer base, JsonDeserializer<Object> deser) {
        super(base);
        this._deserializer = deser;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType genericType = this._findType(ctxt, ctxt.getContextualType());
        if (genericType == null) {
            if (property != null) {
                genericType = this._findType(ctxt, property.getType());
            }
            if (genericType == null) {
                return this;
            }
        }
        JsonDeserializer<Object> deser = ctxt.findContextualValueDeserializer(genericType, property);
        return new RangeSetDeserializer(this, deser);
    }

    private JavaType _findType(DeserializationContext ctxt, JavaType base) {
        JavaType valueType;
        Class<?> raw = base.getRawClass();
        TypeFactory tf = ctxt.getTypeFactory();
        if (RangeSet.class.isAssignableFrom(raw) && (valueType = tf.findFirstTypeParameter(base, RangeSet.class)) != null) {
            JavaType rangeType = tf.constructParametricType(Range.class, valueType);
            return tf.constructCollectionType(List.class, rangeType);
        }
        return null;
    }

    @Override
    public RangeSet<Comparable<?>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._deserializer == null) {
            ctxt.reportBadDefinition(this.handledType(), "Not contextualized to have value deserializer or value type of `RangeSet` was not available via type parameters");
        }
        Collection ranges = (Collection)this._deserializer.deserialize(p, ctxt);
        ImmutableRangeSet.Builder<Comparable<?>> builder = ImmutableRangeSet.builder();
        for (Object ob : ranges) {
            if (ob == null) {
                this._tryToAddNull(p, ctxt, builder);
                continue;
            }
            Range range = (Range)ob;
            builder.add(range);
        }
        return builder.build();
    }

    protected void _tryToAddNull(JsonParser p, DeserializationContext ctxt, ImmutableRangeSet.Builder<Comparable<?>> builder) throws IOException {
        try {
            builder.add(null);
        }
        catch (NullPointerException e) {
            ctxt.handleUnexpectedToken(this._valueType, JsonToken.VALUE_NULL, p, "Guava `RangeSet` does not accept `null` values", new Object[0]);
        }
    }
}

