/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataContentType;
import com.azure.core.implementation.util.SliceInputStream;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.json.JsonWriter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FileContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(FileContent.class);
    private final Path file;
    private final int chunkSize;
    private final long position;
    private final long length;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<FileContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FileContent.class, byte[].class, "bytes");

    public FileContent(Path file, int chunkSize, Long position, Long length) {
        this(FileContent.validateFile(file), FileContent.validateChunkSize(chunkSize), FileContent.validatePosition(position), FileContent.validateLength(length, file.toFile().length(), FileContent.validatePosition(position)));
    }

    FileContent(Path file, int chunkSize, long position, long length) {
        this.file = file;
        this.chunkSize = chunkSize;
        this.position = position;
        this.length = length;
    }

    private static Path validateFile(Path file) {
        Objects.requireNonNull(file, "'file' cannot be null.");
        if (!file.toFile().exists()) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(new FileNotFoundException("File does not exist " + file)));
        }
        return file;
    }

    private static int validateChunkSize(int chunkSize) {
        if (chunkSize <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'chunkSize' cannot be less than or equal to 0."));
        }
        return chunkSize;
    }

    private static long validatePosition(Long position) {
        if (position != null && position < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'position' cannot be negative."));
        }
        return position != null ? position : 0L;
    }

    private static long validateLength(Long length, long fileLength, long position) {
        if (length != null && length < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'length' cannot be negative."));
        }
        long maxAvailableLength = fileLength - position;
        return length == null ? maxAvailableLength : Math.min(length, maxAvailableLength);
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserialize(this.toStream(), typeReference);
    }

    @Override
    public InputStream toStream() {
        try {
            return new SliceInputStream(new BufferedInputStream(this.getFileInputStream(), this.chunkSize), this.position, this.length);
        }
        catch (FileNotFoundException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException("File not found " + this.file, e));
        }
    }

    protected FileInputStream getFileInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file.toFile());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        if (this.length > Integer.MAX_VALUE) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + this.length));
        }
        return this.toByteBufferInternal();
    }

    protected ByteBuffer toByteBufferInternal() {
        MappedByteBuffer mappedByteBuffer;
        block8: {
            FileChannel fileChannel = FileChannel.open(this.file, new OpenOption[0]);
            try {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.position, this.length);
                if (fileChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(exception));
                }
            }
            fileChannel.close();
        }
        return mappedByteBuffer;
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return Flux.using(this::openAsynchronousFileChannel, channel -> FluxUtil.readFile(channel, this.chunkSize, this.position, this.length), channel -> {
            try {
                channel.close();
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate(ex));
            }
        });
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(Channels.newChannel(outputStream));
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(this.file, new OpenOption[0]);){
            long written;
            for (long totalWritten = 0L; totalWritten < this.length; totalWritten += written) {
                written = fileChannel.transferTo(this.position + totalWritten, this.length - totalWritten, channel);
                if (written >= 0L) continue;
                return;
            }
        }
    }

    @Override
    public Mono<Void> writeTo(AsynchronousByteChannel channel) {
        if (channel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return FluxUtil.writeToAsynchronousByteChannel(this.toFluxByteBuffer(), channel);
    }

    @Override
    public void writeTo(JsonWriter jsonWriter) throws IOException {
        Objects.requireNonNull(jsonWriter, "'jsonWriter' cannot be null");
        jsonWriter.writeBinary(this.toBytes());
    }

    protected AsynchronousFileChannel openAsynchronousFileChannel() throws IOException {
        return AsynchronousFileChannel.open(this.file, StandardOpenOption.READ);
    }

    public Path getFile() {
        return this.file;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean isReplayable() {
        return true;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        return this;
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        return Mono.just(this);
    }

    @Override
    public BinaryDataContentType getContentType() {
        return BinaryDataContentType.BINARY;
    }

    private byte[] getBytes() {
        byte[] byArray;
        block11: {
            if (this.length > 0x7FFFFFF7L) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + this.length));
            }
            InputStream is = this.toStream();
            try {
                int read;
                byte[] bytes = new byte[(int)this.length];
                int pendingBytes = bytes.length;
                int offset = 0;
                do {
                    if ((read = is.read(bytes, offset, pendingBytes)) >= 0) {
                        offset += read;
                        continue;
                    }
                    throw LOGGER.logExceptionAsError(new IllegalStateException("Premature EOF. File was modified concurrently."));
                } while ((pendingBytes -= read) > 0);
                byArray = bytes;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(exception));
                }
            }
            is.close();
        }
        return byArray;
    }
}

