/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.complex;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroType;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroIntegerSchema;
import java.util.List;
import java.util.function.Consumer;

public class AvroUnionSchema
extends AvroCompositeSchema {
    private static final ClientLogger LOGGER = new ClientLogger(AvroUnionSchema.class);
    private final List<AvroType> types;

    public AvroUnionSchema(List<AvroType> types, AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
        this.types = types;
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
        AvroIntegerSchema indexSchema = new AvroIntegerSchema(this.state, this::onIndex);
        indexSchema.pushToStack();
    }

    private void onIndex(Object index) {
        AvroUnionSchema.checkType("index", index, Integer.class);
        Integer i = (Integer)index;
        if (i < 0 || i >= this.types.size()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Invalid index to parse union"));
        }
        AvroType type = this.types.get(i);
        AvroSchema typeSchema = AvroUnionSchema.getSchema(type, this.state, this::onType);
        typeSchema.pushToStack();
    }

    private void onType(Object value) {
        this.result = value;
        this.done = true;
    }
}

