/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import com.google.protobuf.AnyProto;
import com.google.protobuf.ApiProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DurationProto;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.EmptyProto;
import com.google.protobuf.FieldMaskProto;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SourceContextProto;
import com.google.protobuf.StructProto;
import com.google.protobuf.TimestampProto;
import com.google.protobuf.TypeProto;
import com.google.protobuf.WrappersProto;
import com.google.type.CalendarPeriodProto;
import com.google.type.ColorProto;
import com.google.type.DateProto;
import com.google.type.DateTimeProto;
import com.google.type.DayOfWeekProto;
import com.google.type.ExprProto;
import com.google.type.FractionProto;
import com.google.type.IntervalProto;
import com.google.type.LatLngProto;
import com.google.type.MoneyProto;
import com.google.type.MonthProto;
import com.google.type.PhoneNumberProto;
import com.google.type.PostalAddressProto;
import com.google.type.QuaternionProto;
import com.google.type.TimeOfDayProto;
import com.squareup.wire.Syntax;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.SchemaDiff;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.EnumDefinition;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.MessageDefinition;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.ServiceDefinition;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleConditionException;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.protobuf.MetaProto;
import io.confluent.protobuf.type.DecimalProto;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import kotlin.ranges.IntRange;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.shaded.com.google.common.base.CaseFormat;
import org.apache.pinot.shaded.com.google.common.collect.EnumHashBiMap;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.apache.pinot.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(ProtobufSchema.class);
    public static final String TYPE = "PROTOBUF";
    public static final String PROTO2 = "proto2";
    public static final String PROTO3 = "proto3";
    public static final String DOC_FIELD = "doc";
    public static final String PARAMS_FIELD = "params";
    public static final String TAGS_FIELD = "tags";
    public static final String PRECISION_KEY = "precision";
    public static final String SCALE_KEY = "scale";
    public static final String DEFAULT_NAME = "default";
    public static final String MAP_ENTRY_SUFFIX = "Entry";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final String CONFLUENT_PREFIX = "confluent.";
    public static final String CONFLUENT_FILE_META = "confluent.file_meta";
    public static final String CONFLUENT_MESSAGE_META = "confluent.message_meta";
    public static final String CONFLUENT_FIELD_META = "confluent.field_meta";
    public static final String CONFLUENT_ENUM_META = "confluent.enum_meta";
    public static final String CONFLUENT_ENUM_VALUE_META = "confluent.enum_value_meta";
    private static final String JAVA_PACKAGE = "java_package";
    private static final String JAVA_OUTER_CLASSNAME = "java_outer_classname";
    private static final String JAVA_MULTIPLE_FILES = "java_multiple_files";
    private static final String JAVA_GENERATE_EQUALS_AND_HASH = "java_generate_equals_and_hash";
    private static final String JAVA_STRING_CHECK_UTF8 = "java_string_check_utf8";
    private static final String OPTIMIZE_FOR = "optimize_for";
    private static final String GO_PACKAGE = "go_package";
    private static final String CC_GENERIC_SERVICES = "cc_generic_services";
    private static final String JAVA_GENERIC_SERVICES = "java_generic_services";
    private static final String PY_GENERIC_SERVICES = "py_generic_services";
    private static final String PHP_GENERIC_SERVICES = "php_generic_services";
    private static final String DEPRECATED = "deprecated";
    private static final String CC_ENABLE_ARENAS = "cc_enable_arenas";
    private static final String OBJC_CLASS_PREFIX = "objc_class_prefix";
    private static final String CSHARP_NAMESPACE = "csharp_namespace";
    private static final String SWIFT_PREFIX = "swift_prefix";
    private static final String PHP_CLASS_PREFIX = "php_class_prefix";
    private static final String PHP_NAMESPACE = "php_namespace";
    private static final String PHP_METADATA_NAMESPACE = "php_metadata_namespace";
    private static final String RUBY_PACKAGE = "ruby_package";
    private static final String NO_STANDARD_DESCRIPTOR_ACCESSOR = "no_standard_descriptor_accessor";
    private static final String MAP_ENTRY = "map_entry";
    private static final String CTYPE = "ctype";
    private static final String PACKED = "packed";
    private static final String JSTYPE = "jstype";
    private static final String ALLOW_ALIAS = "allow_alias";
    private static final String IDEMPOTENCY_LEVEL = "idempotency_level";
    public static final Location DEFAULT_LOCATION = Location.get("");
    public static final String CFLT_META_LOCATION = "confluent/meta.proto";
    public static final String CFLT_DECIMAL_LOCATION = "confluent/type/decimal.proto";
    public static final String CALENDAR_PERIOD_LOCATION = "google/type/calendar_period.proto";
    public static final String COLOR_LOCATION = "google/type/color.proto";
    public static final String DATE_LOCATION = "google/type/date.proto";
    public static final String DATETIME_LOCATION = "google/type/datetime.proto";
    public static final String DAY_OF_WEEK_LOCATION = "google/type/dayofweek.proto";
    public static final String DECIMAL_LOCATION = "google/type/decimal.proto";
    public static final String EXPR_LOCATION = "google/type/expr.proto";
    public static final String FRACTION_LOCATION = "google/type/fraction.proto";
    public static final String INTERVAL_LOCATION = "google/type/interval.proto";
    public static final String LATLNG_LOCATION = "google/type/latlng.proto";
    public static final String MONEY_LOCATION = "google/type/money.proto";
    public static final String MONTH_LOCATION = "google/type/month.proto";
    public static final String PHONE_NUMBER_LOCATION = "google/type/phone_number.proto";
    public static final String POSTAL_ADDRESS_LOCATION = "google/type/postal_address.proto";
    public static final String QUATERNION_LOCATION = "google/type/quaternion.proto";
    public static final String TIME_OF_DAY_LOCATION = "google/type/timeofday.proto";
    public static final String ANY_LOCATION = "google/protobuf/any.proto";
    public static final String API_LOCATION = "google/protobuf/api.proto";
    public static final String DESCRIPTOR_LOCATION = "google/protobuf/descriptor.proto";
    public static final String DURATION_LOCATION = "google/protobuf/duration.proto";
    public static final String EMPTY_LOCATION = "google/protobuf/empty.proto";
    public static final String FIELD_MASK_LOCATION = "google/protobuf/field_mask.proto";
    public static final String SOURCE_CONTEXT_LOCATION = "google/protobuf/source_context.proto";
    public static final String STRUCT_LOCATION = "google/protobuf/struct.proto";
    public static final String TIMESTAMP_LOCATION = "google/protobuf/timestamp.proto";
    public static final String TYPE_LOCATION = "google/protobuf/type.proto";
    public static final String WRAPPER_LOCATION = "google/protobuf/wrappers.proto";
    private static final ProtoFileElement CFLT_META_SCHEMA = ProtobufSchema.toProtoFile(MetaProto.getDescriptor().toProto());
    private static final ProtoFileElement CFLT_DECIMAL_SCHEMA = ProtobufSchema.toProtoFile(DecimalProto.getDescriptor().toProto());
    private static final ProtoFileElement CALENDAR_PERIOD_SCHEMA = ProtobufSchema.toProtoFile(CalendarPeriodProto.getDescriptor().toProto());
    private static final ProtoFileElement COLOR_SCHEMA = ProtobufSchema.toProtoFile(ColorProto.getDescriptor().toProto());
    private static final ProtoFileElement DATE_SCHEMA = ProtobufSchema.toProtoFile(DateProto.getDescriptor().toProto());
    private static final ProtoFileElement DATETIME_SCHEMA = ProtobufSchema.toProtoFile(DateTimeProto.getDescriptor().toProto());
    private static final ProtoFileElement DAY_OF_WEEK_SCHEMA = ProtobufSchema.toProtoFile(DayOfWeekProto.getDescriptor().toProto());
    private static final ProtoFileElement DECIMAL_SCHEMA = ProtobufSchema.toProtoFile(com.google.type.DecimalProto.getDescriptor().toProto());
    private static final ProtoFileElement EXPR_SCHEMA = ProtobufSchema.toProtoFile(ExprProto.getDescriptor().toProto());
    private static final ProtoFileElement FRACTION_SCHEMA = ProtobufSchema.toProtoFile(FractionProto.getDescriptor().toProto());
    private static final ProtoFileElement INTERVAL_SCHEMA = ProtobufSchema.toProtoFile(IntervalProto.getDescriptor().toProto());
    private static final ProtoFileElement LATLNG_SCHEMA = ProtobufSchema.toProtoFile(LatLngProto.getDescriptor().toProto());
    private static final ProtoFileElement MONEY_SCHEMA = ProtobufSchema.toProtoFile(MoneyProto.getDescriptor().toProto());
    private static final ProtoFileElement MONTH_SCHEMA = ProtobufSchema.toProtoFile(MonthProto.getDescriptor().toProto());
    private static final ProtoFileElement PHONE_NUMBER_SCHEMA = ProtobufSchema.toProtoFile(PhoneNumberProto.getDescriptor().toProto());
    private static final ProtoFileElement POSTAL_ADDRESS_SCHEMA = ProtobufSchema.toProtoFile(PostalAddressProto.getDescriptor().toProto());
    private static final ProtoFileElement QUATERNION_SCHEMA = ProtobufSchema.toProtoFile(QuaternionProto.getDescriptor().toProto());
    private static final ProtoFileElement TIME_OF_DAY_SCHEMA = ProtobufSchema.toProtoFile(TimeOfDayProto.getDescriptor().toProto());
    private static final ProtoFileElement ANY_SCHEMA = ProtobufSchema.toProtoFile(AnyProto.getDescriptor().toProto());
    private static final ProtoFileElement API_SCHEMA = ProtobufSchema.toProtoFile(ApiProto.getDescriptor().toProto());
    private static final ProtoFileElement DESCRIPTOR_SCHEMA = ProtobufSchema.toProtoFile(DescriptorProtos.getDescriptor().toProto());
    private static final ProtoFileElement DURATION_SCHEMA = ProtobufSchema.toProtoFile(DurationProto.getDescriptor().toProto());
    private static final ProtoFileElement EMPTY_SCHEMA = ProtobufSchema.toProtoFile(EmptyProto.getDescriptor().toProto());
    private static final ProtoFileElement FIELD_MASK_SCHEMA = ProtobufSchema.toProtoFile(FieldMaskProto.getDescriptor().toProto());
    private static final ProtoFileElement SOURCE_CONTEXT_SCHEMA = ProtobufSchema.toProtoFile(SourceContextProto.getDescriptor().toProto());
    private static final ProtoFileElement STRUCT_SCHEMA = ProtobufSchema.toProtoFile(StructProto.getDescriptor().toProto());
    private static final ProtoFileElement TIMESTAMP_SCHEMA = ProtobufSchema.toProtoFile(TimestampProto.getDescriptor().toProto());
    private static final ProtoFileElement TYPE_SCHEMA = ProtobufSchema.toProtoFile(TypeProto.getDescriptor().toProto());
    private static final ProtoFileElement WRAPPER_SCHEMA = ProtobufSchema.toProtoFile(WrappersProto.getDescriptor().toProto());
    private static final HashMap<String, ProtoFileElement> KNOWN_DEPENDENCIES = new HashMap();
    private final ProtoFileElement schemaObj;
    private final Integer version;
    private final String name;
    private final List<SchemaReference> references;
    private final Map<String, ProtoFileElement> dependencies;
    private final Metadata metadata;
    private final RuleSet ruleSet;
    private transient String canonicalString;
    private transient DynamicSchema dynamicSchema;
    private transient Descriptors.Descriptor descriptor;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private static final Base64.Encoder base64Encoder;
    private static final Base64.Decoder base64Decoder;
    private static final ObjectMapper jsonMapper;
    private static volatile Method extensionFields;

    public static Set<String> knownTypes() {
        return KNOWN_DEPENDENCIES.keySet();
    }

    public ProtobufSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null, null);
    }

    public ProtobufSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version, String name) {
        this(schemaString, references, resolvedReferences, null, null, version, name);
    }

    public ProtobufSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Metadata metadata, RuleSet ruleSet, Integer version, String name) {
        try {
            this.schemaObj = schemaString != null ? this.toProtoFile(schemaString) : null;
            this.version = version;
            this.name = name;
            this.references = Collections.unmodifiableList(references);
            this.dependencies = Collections.unmodifiableMap(resolvedReferences.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toProtoFile((String)e.getValue()))));
            this.metadata = metadata;
            this.ruleSet = ruleSet;
        }
        catch (IllegalStateException e2) {
            log.error("Could not parse Protobuf schema {} with references {}", schemaString, references, e2);
            throw e2;
        }
    }

    public ProtobufSchema(ProtoFileElement protoFileElement, List<SchemaReference> references, Map<String, ProtoFileElement> dependencies) {
        this.schemaObj = protoFileElement;
        this.version = null;
        this.name = null;
        this.references = Collections.unmodifiableList(references);
        this.dependencies = Collections.unmodifiableMap(dependencies);
        this.metadata = null;
        this.ruleSet = null;
    }

    public ProtobufSchema(Descriptors.Descriptor descriptor2) {
        this(descriptor2, Collections.emptyList());
    }

    public ProtobufSchema(Descriptors.Descriptor descriptor2, List<SchemaReference> references) {
        HashMap<String, ProtoFileElement> dependencies = new HashMap<String, ProtoFileElement>();
        this.schemaObj = ProtobufSchema.toProtoFile(descriptor2.getFile(), dependencies);
        this.version = null;
        this.name = descriptor2.getFullName();
        this.references = Collections.unmodifiableList(references);
        this.dependencies = Collections.unmodifiableMap(dependencies);
        this.metadata = null;
        this.ruleSet = null;
        this.descriptor = descriptor2;
    }

    public ProtobufSchema(Descriptors.EnumDescriptor enumDescriptor) {
        this(enumDescriptor, Collections.emptyList());
    }

    public ProtobufSchema(Descriptors.EnumDescriptor enumDescriptor, List<SchemaReference> references) {
        HashMap<String, ProtoFileElement> dependencies = new HashMap<String, ProtoFileElement>();
        this.schemaObj = ProtobufSchema.toProtoFile(enumDescriptor.getFile(), dependencies);
        this.version = null;
        this.name = enumDescriptor.getFullName();
        this.references = Collections.unmodifiableList(references);
        this.dependencies = Collections.unmodifiableMap(dependencies);
        this.metadata = null;
        this.ruleSet = null;
        this.descriptor = null;
    }

    public ProtobufSchema(Descriptors.FileDescriptor fileDescriptor) {
        this(fileDescriptor, Collections.emptyList());
    }

    public ProtobufSchema(Descriptors.FileDescriptor fileDescriptor, List<SchemaReference> references) {
        HashMap<String, ProtoFileElement> dependencies = new HashMap<String, ProtoFileElement>();
        this.schemaObj = ProtobufSchema.toProtoFile(fileDescriptor, dependencies);
        this.version = null;
        this.name = null;
        this.references = Collections.unmodifiableList(references);
        this.dependencies = Collections.unmodifiableMap(dependencies);
        this.metadata = null;
        this.ruleSet = null;
        this.descriptor = null;
    }

    private ProtobufSchema(ProtoFileElement schemaObj, Integer version, String name, List<SchemaReference> references, Map<String, ProtoFileElement> dependencies, Metadata metadata, RuleSet ruleSet, String canonicalString, DynamicSchema dynamicSchema, Descriptors.Descriptor descriptor2) {
        this.schemaObj = schemaObj;
        this.version = version;
        this.name = name;
        this.references = references;
        this.dependencies = dependencies;
        this.metadata = metadata;
        this.ruleSet = ruleSet;
        this.canonicalString = canonicalString;
        this.dynamicSchema = dynamicSchema;
        this.descriptor = descriptor2;
    }

    @Override
    public ProtobufSchema copy() {
        return new ProtobufSchema(this.schemaObj, this.version, this.name, this.references, this.dependencies, this.metadata, this.ruleSet, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    @Override
    public ProtobufSchema copy(Integer version) {
        return new ProtobufSchema(this.schemaObj, version, this.name, this.references, this.dependencies, this.metadata, this.ruleSet, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    public ProtobufSchema copy(String name) {
        return new ProtobufSchema(this.schemaObj, this.version, name, this.references, this.dependencies, this.metadata, this.ruleSet, this.canonicalString, this.dynamicSchema, Objects.equals(this.name, name) ? this.descriptor : null);
    }

    public ProtobufSchema copy(List<SchemaReference> references) {
        return this.copy(references, this.dependencies);
    }

    public ProtobufSchema copy(List<SchemaReference> references, Map<String, ProtoFileElement> dependencies) {
        return new ProtobufSchema(this.schemaObj, this.version, this.name, references, dependencies, this.metadata, this.ruleSet, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    @Override
    public ProtobufSchema copy(Metadata metadata, RuleSet ruleSet) {
        return new ProtobufSchema(this.schemaObj, this.version, this.name, this.references, this.dependencies, metadata, ruleSet, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    @Override
    public ParsedSchema copy(Map<SchemaEntity, Set<String>> tagsToAdd, Map<SchemaEntity, Set<String>> tagsToRemove) {
        ProtobufSchema schemaCopy = this.copy();
        Object original = jsonMapper.valueToTree(schemaCopy.rawSchema());
        this.modifySchemaTags(schemaCopy.rawSchema(), (JsonNode)original, tagsToAdd, tagsToRemove);
        try {
            ProtoFileElement newFileElement = ProtobufSchemaUtils.jsonToFile(original);
            return new ProtobufSchema(newFileElement.toSchema(), schemaCopy.references(), schemaCopy.dependencies().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ProtoFileElement)e.getValue()).toSchema())), schemaCopy.metadata(), schemaCopy.ruleSet(), schemaCopy.version(), schemaCopy.name());
        }
        catch (JsonProcessingException e2) {
            throw new IllegalStateException("Cannot deserialize json into ProtoFileElement", e2);
        }
    }

    public ProtobufSchema copyWithSchema(String schema) {
        return new ProtobufSchema(this.toProtoFile(schema), this.version, this.name, this.references, this.dependencies, this.metadata, this.ruleSet, schema, null, null);
    }

    private ProtoFileElement toProtoFile(String schema) {
        try {
            return ProtoParser.Companion.parse(DEFAULT_LOCATION, schema);
        }
        catch (Exception e) {
            try {
                byte[] bytes = base64Decoder.decode(schema);
                return ProtobufSchema.toProtoFile(DescriptorProtos.FileDescriptorProto.parseFrom(bytes));
            }
            catch (Exception pe) {
                throw new IllegalArgumentException("Could not parse Protobuf - " + e.getMessage(), e);
            }
        }
    }

    private static ProtoFileElement toProtoFile(Descriptors.FileDescriptor file, Map<String, ProtoFileElement> dependencies) {
        for (Descriptors.FileDescriptor dependency : file.getDependencies()) {
            String depName = dependency.getName();
            dependencies.put(depName, ProtobufSchema.toProtoFile(dependency, dependencies));
        }
        return ProtobufSchema.toProtoFile(file.toProto());
    }

    private static ProtoFileElement toProtoFile(DescriptorProtos.FileDescriptorProto file) {
        MetaProto.Meta meta;
        OptionElement option;
        String packageName = file.getPackage();
        if (packageName.isEmpty()) {
            packageName = null;
        }
        Syntax syntax = null;
        switch (file.getSyntax()) {
            case "proto2": {
                syntax = Syntax.PROTO_2;
                break;
            }
            case "proto3": {
                syntax = Syntax.PROTO_3;
                break;
            }
        }
        ImmutableList.Builder types = ImmutableList.builder();
        for (DescriptorProtos.DescriptorProto descriptorProto : file.getMessageTypeList()) {
            MessageElement message = ProtobufSchema.toMessage(file, descriptorProto);
            types.add(message);
        }
        for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : file.getEnumTypeList()) {
            EnumElement enumer = ProtobufSchema.toEnum(enumDescriptorProto);
            types.add(enumer);
        }
        ImmutableList.Builder services = ImmutableList.builder();
        for (DescriptorProtos.ServiceDescriptorProto sd : file.getServiceList()) {
            ServiceElement service = ProtobufSchema.toService(sd);
            services.add(service);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder publicImports = ImmutableList.builder();
        ProtocolStringList dependencyList = file.getDependencyList();
        HashSet<Integer> publicDependencyList = new HashSet<Integer>(file.getPublicDependencyList());
        for (int i = 0; i < dependencyList.size(); ++i) {
            String depName = (String)dependencyList.get(i);
            if (publicDependencyList.contains(i)) {
                publicImports.add(depName);
                continue;
            }
            builder.add(depName);
        }
        ImmutableList.Builder options = ImmutableList.builder();
        if (file.getOptions().hasJavaPackage()) {
            options.add(new OptionElement(JAVA_PACKAGE, OptionElement.Kind.STRING, file.getOptions().getJavaPackage(), false));
        }
        if (file.getOptions().hasJavaOuterClassname()) {
            options.add(new OptionElement(JAVA_OUTER_CLASSNAME, OptionElement.Kind.STRING, file.getOptions().getJavaOuterClassname(), false));
        }
        if (file.getOptions().hasJavaMultipleFiles()) {
            options.add(new OptionElement(JAVA_MULTIPLE_FILES, OptionElement.Kind.BOOLEAN, file.getOptions().getJavaMultipleFiles(), false));
        }
        if (file.getOptions().hasJavaGenerateEqualsAndHash()) {
            options.add(new OptionElement(JAVA_GENERATE_EQUALS_AND_HASH, OptionElement.Kind.BOOLEAN, file.getOptions().getJavaGenerateEqualsAndHash(), false));
        }
        if (file.getOptions().hasJavaStringCheckUtf8()) {
            options.add(new OptionElement(JAVA_STRING_CHECK_UTF8, OptionElement.Kind.BOOLEAN, file.getOptions().getJavaStringCheckUtf8(), false));
        }
        if (file.getOptions().hasOptimizeFor()) {
            options.add(new OptionElement(OPTIMIZE_FOR, OptionElement.Kind.ENUM, file.getOptions().getOptimizeFor(), false));
        }
        if (file.getOptions().hasGoPackage()) {
            options.add(new OptionElement(GO_PACKAGE, OptionElement.Kind.STRING, file.getOptions().getGoPackage(), false));
        }
        if (file.getOptions().hasCcGenericServices()) {
            options.add(new OptionElement(CC_GENERIC_SERVICES, OptionElement.Kind.BOOLEAN, file.getOptions().getCcGenericServices(), false));
        }
        if (file.getOptions().hasJavaGenericServices()) {
            options.add(new OptionElement(JAVA_GENERIC_SERVICES, OptionElement.Kind.BOOLEAN, file.getOptions().getJavaGenericServices(), false));
        }
        if (file.getOptions().hasPyGenericServices()) {
            options.add(new OptionElement(PY_GENERIC_SERVICES, OptionElement.Kind.BOOLEAN, file.getOptions().getPyGenericServices(), false));
        }
        if (file.getOptions().hasPhpGenericServices()) {
            options.add(new OptionElement(PHP_GENERIC_SERVICES, OptionElement.Kind.BOOLEAN, file.getOptions().getPhpGenericServices(), false));
        }
        if (file.getOptions().hasDeprecated()) {
            options.add(new OptionElement(DEPRECATED, OptionElement.Kind.BOOLEAN, file.getOptions().getDeprecated(), false));
        }
        if (file.getOptions().hasCcEnableArenas()) {
            options.add(new OptionElement(CC_ENABLE_ARENAS, OptionElement.Kind.BOOLEAN, file.getOptions().getCcEnableArenas(), false));
        }
        if (file.getOptions().hasObjcClassPrefix()) {
            options.add(new OptionElement(OBJC_CLASS_PREFIX, OptionElement.Kind.STRING, file.getOptions().getObjcClassPrefix(), false));
        }
        if (file.getOptions().hasCsharpNamespace()) {
            options.add(new OptionElement(CSHARP_NAMESPACE, OptionElement.Kind.STRING, file.getOptions().getCsharpNamespace(), false));
        }
        if (file.getOptions().hasSwiftPrefix()) {
            options.add(new OptionElement(SWIFT_PREFIX, OptionElement.Kind.STRING, file.getOptions().getSwiftPrefix(), false));
        }
        if (file.getOptions().hasPhpClassPrefix()) {
            options.add(new OptionElement(PHP_CLASS_PREFIX, OptionElement.Kind.STRING, file.getOptions().getPhpClassPrefix(), false));
        }
        if (file.getOptions().hasPhpNamespace()) {
            options.add(new OptionElement(PHP_NAMESPACE, OptionElement.Kind.STRING, file.getOptions().getPhpNamespace(), false));
        }
        if (file.getOptions().hasPhpMetadataNamespace()) {
            options.add(new OptionElement(PHP_METADATA_NAMESPACE, OptionElement.Kind.STRING, file.getOptions().getPhpMetadataNamespace(), false));
        }
        if (file.getOptions().hasRubyPackage()) {
            options.add(new OptionElement(RUBY_PACKAGE, OptionElement.Kind.STRING, file.getOptions().getRubyPackage(), false));
        }
        if (file.getOptions().hasExtension(MetaProto.fileMeta) && (option = ProtobufSchema.toOption(CONFLUENT_FILE_META, meta = file.getOptions().getExtension(MetaProto.fileMeta))) != null) {
            options.add(option);
        }
        options.addAll(ProtobufSchema.toCustomOptions(file.getOptions()));
        ImmutableList.Builder<ExtendElement> extendElements = ProtobufSchema.toExtendElements(file, file.getExtensionList());
        return new ProtoFileElement(DEFAULT_LOCATION, packageName, syntax, (List<String>)((Object)builder.build()), (List<String>)((Object)publicImports.build()), (List<? extends TypeElement>)((Object)types.build()), (List<ServiceElement>)((Object)services.build()), (List<ExtendElement>)((Object)extendElements.build()), (List<OptionElement>)((Object)options.build()));
    }

    private static ImmutableList.Builder<ExtendElement> toExtendElements(DescriptorProtos.FileDescriptorProto file, List<DescriptorProtos.FieldDescriptorProto> fields2) {
        LinkedHashMap<String, ImmutableList.Builder> extendFieldElements = new LinkedHashMap<String, ImmutableList.Builder>();
        for (DescriptorProtos.FieldDescriptorProto fd : fields2) {
            ImmutableList.Builder extendFields = extendFieldElements.computeIfAbsent(fd.getExtendee(), k -> ImmutableList.builder());
            extendFields.add(ProtobufSchema.toField(file, fd, false));
        }
        ImmutableList.Builder<ExtendElement> extendElements = ImmutableList.builder();
        for (Map.Entry extendFieldElement : extendFieldElements.entrySet()) {
            extendElements.add((Object)new ExtendElement(DEFAULT_LOCATION, (String)extendFieldElement.getKey(), "", (List<FieldElement>)((Object)((ImmutableList.Builder)extendFieldElement.getValue()).build())));
        }
        return extendElements;
    }

    private static List<OptionElement> toCustomOptions(GeneratedMessageV3.ExtendableMessage<?> options) {
        return ProtobufSchema.getExtensionFields(options).entrySet().stream().filter(e -> ((Descriptors.FieldDescriptor)e.getKey()).isExtension() && !((Descriptors.FieldDescriptor)e.getKey()).getFullName().startsWith(CONFLUENT_PREFIX)).flatMap(e -> ProtobufSchema.toOptionElements(((Descriptors.FieldDescriptor)e.getKey()).getFullName(), e.getValue())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Descriptors.FieldDescriptor, Object> getExtensionFields(GeneratedMessageV3.ExtendableMessage<?> options) {
        try {
            if (extensionFields != null) return (Map)extensionFields.invoke(options, new Object[0]);
            Class<ProtobufSchema> clazz = ProtobufSchema.class;
            synchronized (ProtobufSchema.class) {
                if (extensionFields == null) {
                    extensionFields = GeneratedMessageV3.ExtendableMessage.class.getDeclaredMethod("getExtensionFields", new Class[0]);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                extensionFields.setAccessible(true);
                return (Map)extensionFields.invoke(options, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Stream<OptionElement> toOptionElements(String name, Object value) {
        if (value instanceof List) {
            return ((List)value).stream().map(v -> ProtobufSchema.toOptionElement(name, v));
        }
        return Stream.of(ProtobufSchema.toOptionElement(name, value));
    }

    private static OptionElement toOptionElement(String name, Object value) {
        return new OptionElement(name, ProtobufSchema.toKind(value), ProtobufSchema.toOptionValue(value, false), true);
    }

    private static OptionElement.Kind toKind(Object value) {
        if (value instanceof String) {
            return OptionElement.Kind.STRING;
        }
        if (value instanceof Boolean) {
            return OptionElement.Kind.BOOLEAN;
        }
        if (value instanceof Number) {
            return OptionElement.Kind.NUMBER;
        }
        if (value instanceof Enum || value instanceof Descriptors.EnumValueDescriptor) {
            return OptionElement.Kind.ENUM;
        }
        if (value instanceof List) {
            return OptionElement.Kind.LIST;
        }
        if (value instanceof Message) {
            return OptionElement.Kind.MAP;
        }
        throw new IllegalArgumentException("Unsupported option type " + value.getClass().getName());
    }

    private static Object toOptionValue(Object value, boolean isMapValue) {
        if (value instanceof List) {
            return ((List)value).stream().map(o -> ProtobufSchema.toOptionValue(o, false)).collect(Collectors.toList());
        }
        if (value instanceof Message) {
            return ProtobufSchema.toOptionMap((Message)value);
        }
        if (isMapValue) {
            if (value instanceof Boolean) {
                return new OptionElement.OptionPrimitive(OptionElement.Kind.BOOLEAN, value);
            }
            if (value instanceof Enum) {
                return new OptionElement.OptionPrimitive(OptionElement.Kind.ENUM, value);
            }
            if (value instanceof Number) {
                return new OptionElement.OptionPrimitive(OptionElement.Kind.NUMBER, value);
            }
        }
        return value;
    }

    private static Map<String, Object> toOptionMap(Message message) {
        return message.getAllFields().entrySet().stream().map(e -> new Pair<String, Object>(ProtobufSchema.toOptionMapKey((Descriptors.FieldDescriptor)e.getKey()), ProtobufSchema.toOptionValue(e.getValue(), true))).filter(p -> p.getSecond() != null).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static String toOptionMapKey(Descriptors.FieldDescriptor field) {
        return field.isExtension() ? "[" + field.getFullName() + "]" : field.getName();
    }

    private static MessageElement toMessage(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.DescriptorProto descriptor2) {
        MetaProto.Meta meta;
        OptionElement option;
        ReservedElement reservedElem;
        String name = descriptor2.getName();
        log.trace("*** msg name: {}", (Object)name);
        ImmutableList.Builder fields2 = ImmutableList.builder();
        ImmutableList.Builder nested = ImmutableList.builder();
        ImmutableList.Builder reserved = ImmutableList.builder();
        ImmutableList.Builder extensions = ImmutableList.builder();
        LinkedHashMap oneofsMap = new LinkedHashMap();
        for (DescriptorProtos.OneofDescriptorProto oneofDescriptorProto : descriptor2.getOneofDeclList()) {
            oneofsMap.put(oneofDescriptorProto.getName(), ImmutableList.builder());
        }
        ArrayList oneofs = new ArrayList(oneofsMap.entrySet());
        for (DescriptorProtos.FieldDescriptorProto fieldDescriptorProto : descriptor2.getFieldList()) {
            FieldElement field;
            if (fieldDescriptorProto.hasOneofIndex() && !fieldDescriptorProto.getProto3Optional()) {
                field = ProtobufSchema.toField(file, fieldDescriptorProto, true);
                ((ImmutableList.Builder)((Map.Entry)oneofs.get(fieldDescriptorProto.getOneofIndex())).getValue()).add(field);
                continue;
            }
            field = ProtobufSchema.toField(file, fieldDescriptorProto, false);
            fields2.add(field);
        }
        for (DescriptorProtos.DescriptorProto descriptorProto : descriptor2.getNestedTypeList()) {
            MessageElement nestedMessage = ProtobufSchema.toMessage(file, descriptorProto);
            nested.add(nestedMessage);
        }
        for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : descriptor2.getEnumTypeList()) {
            EnumElement nestedEnum = ProtobufSchema.toEnum(enumDescriptorProto);
            nested.add(nestedEnum);
        }
        for (DescriptorProtos.DescriptorProto.ReservedRange reservedRange : descriptor2.getReservedRangeList()) {
            reservedElem = ProtobufSchema.toReserved(reservedRange);
            reserved.add(reservedElem);
        }
        for (String string : descriptor2.getReservedNameList()) {
            reservedElem = new ReservedElement(DEFAULT_LOCATION, "", Collections.singletonList(string));
            reserved.add(reservedElem);
        }
        for (DescriptorProtos.DescriptorProto.ExtensionRange extensionRange : descriptor2.getExtensionRangeList()) {
            ExtensionsElement extension = ProtobufSchema.toExtension(extensionRange);
            extensions.add(extension);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (descriptor2.getOptions().hasNoStandardDescriptorAccessor()) {
            OptionElement optionElement = new OptionElement(NO_STANDARD_DESCRIPTOR_ACCESSOR, OptionElement.Kind.BOOLEAN, descriptor2.getOptions().getNoStandardDescriptorAccessor(), false);
            builder.add(optionElement);
        }
        if (descriptor2.getOptions().hasDeprecated()) {
            OptionElement optionElement = new OptionElement(DEPRECATED, OptionElement.Kind.BOOLEAN, descriptor2.getOptions().getDeprecated(), false);
            builder.add(optionElement);
        }
        if (descriptor2.getOptions().hasMapEntry()) {
            OptionElement optionElement = new OptionElement(MAP_ENTRY, OptionElement.Kind.BOOLEAN, descriptor2.getOptions().getMapEntry(), false);
            builder.add(optionElement);
        }
        if (descriptor2.getOptions().hasExtension(MetaProto.messageMeta) && (option = ProtobufSchema.toOption(CONFLUENT_MESSAGE_META, meta = descriptor2.getOptions().getExtension(MetaProto.messageMeta))) != null) {
            builder.add(option);
        }
        builder.addAll(ProtobufSchema.toCustomOptions(descriptor2.getOptions()));
        ImmutableList.Builder<ExtendElement> builder2 = ProtobufSchema.toExtendElements(file, descriptor2.getExtensionList());
        return new MessageElement(DEFAULT_LOCATION, name, "", (List<? extends TypeElement>)((Object)nested.build()), (List<OptionElement>)((Object)builder.build()), (List<ReservedElement>)((Object)reserved.build()), (List<FieldElement>)((Object)fields2.build()), oneofs.stream().map(e -> ProtobufSchema.toOneof((String)e.getKey(), (ImmutableList.Builder)e.getValue())).filter(e -> !e.getFields().isEmpty()).collect(Collectors.toList()), (List<ExtensionsElement>)((Object)extensions.build()), Collections.emptyList(), (List<ExtendElement>)((Object)builder2.build()));
    }

    private static OptionElement toOption(String name, MetaProto.Meta meta) {
        ProtocolStringList tags;
        Map<String, String> params;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String doc = meta.getDoc();
        if (!doc.isEmpty()) {
            map.put(DOC_FIELD, doc);
        }
        if (!(params = meta.getParamsMap()).isEmpty()) {
            ArrayList keyValues = new ArrayList();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                LinkedHashMap<String, String> keyValue = new LinkedHashMap<String, String>();
                String key = entry.getKey();
                if (PRECISION_KEY.equals(key) || SCALE_KEY.equals(key)) {
                    keyValue.put(VALUE_FIELD, entry.getValue());
                    keyValue.put(KEY_FIELD, key);
                } else {
                    keyValue.put(KEY_FIELD, key);
                    keyValue.put(VALUE_FIELD, entry.getValue());
                }
                keyValues.add(keyValue);
            }
            map.put(PARAMS_FIELD, keyValues);
        }
        if (!(tags = meta.getTagsList()).isEmpty()) {
            map.put(TAGS_FIELD, tags);
        }
        return map.isEmpty() ? null : new OptionElement(name, OptionElement.Kind.MAP, map, true);
    }

    private static OneOfElement toOneof(String name, ImmutableList.Builder<FieldElement> fields2) {
        log.trace("*** oneof name: {}", (Object)name);
        return new OneOfElement(name, "", (List<FieldElement>)((Object)fields2.build()), Collections.emptyList(), Collections.emptyList(), DEFAULT_LOCATION);
    }

    private static EnumElement toEnum(DescriptorProtos.EnumDescriptorProto ed) {
        MetaProto.Meta meta;
        OptionElement option;
        OptionElement option2;
        ReservedElement reservedElem;
        String name = ed.getName();
        log.trace("*** enum name: {}", (Object)name);
        ImmutableList.Builder constants = ImmutableList.builder();
        for (DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto : ed.getValueList()) {
            MetaProto.Meta meta2;
            OptionElement option3;
            ImmutableList.Builder options = ImmutableList.builder();
            if (enumValueDescriptorProto.getOptions().hasDeprecated()) {
                OptionElement option22 = new OptionElement(DEPRECATED, OptionElement.Kind.BOOLEAN, enumValueDescriptorProto.getOptions().getDeprecated(), false);
                options.add(option22);
            }
            if (enumValueDescriptorProto.getOptions().hasExtension(MetaProto.enumValueMeta) && (option3 = ProtobufSchema.toOption(CONFLUENT_ENUM_VALUE_META, meta2 = enumValueDescriptorProto.getOptions().getExtension(MetaProto.enumValueMeta))) != null) {
                options.add(option3);
            }
            options.addAll(ProtobufSchema.toCustomOptions(enumValueDescriptorProto.getOptions()));
            constants.add(new EnumConstantElement(DEFAULT_LOCATION, enumValueDescriptorProto.getName(), enumValueDescriptorProto.getNumber(), "", (List<OptionElement>)((Object)options.build())));
        }
        ImmutableList.Builder reserved = ImmutableList.builder();
        for (DescriptorProtos.EnumDescriptorProto.EnumReservedRange range : ed.getReservedRangeList()) {
            reservedElem = ProtobufSchema.toReserved(range);
            reserved.add(reservedElem);
        }
        for (String reservedName : ed.getReservedNameList()) {
            reservedElem = new ReservedElement(DEFAULT_LOCATION, "", Collections.singletonList(reservedName));
            reserved.add(reservedElem);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (ed.getOptions().hasAllowAlias()) {
            option2 = new OptionElement(ALLOW_ALIAS, OptionElement.Kind.BOOLEAN, ed.getOptions().getAllowAlias(), false);
            builder.add(option2);
        }
        if (ed.getOptions().hasDeprecated()) {
            option2 = new OptionElement(DEPRECATED, OptionElement.Kind.BOOLEAN, ed.getOptions().getDeprecated(), false);
            builder.add(option2);
        }
        if (ed.getOptions().hasExtension(MetaProto.enumMeta) && (option = ProtobufSchema.toOption(CONFLUENT_ENUM_META, meta = ed.getOptions().getExtension(MetaProto.enumMeta))) != null) {
            builder.add(option);
        }
        builder.addAll(ProtobufSchema.toCustomOptions(ed.getOptions()));
        return new EnumElement(DEFAULT_LOCATION, name, "", (List<OptionElement>)((Object)builder.build()), (List<EnumConstantElement>)((Object)constants.build()), (List<ReservedElement>)((Object)reserved.build()));
    }

    private static ReservedElement toReserved(DescriptorProtos.DescriptorProto.ReservedRange range) {
        int end;
        ArrayList<Object> values2 = new ArrayList<Object>();
        int start = range.getStart();
        values2.add(start == (end = range.getEnd()) - 1 ? Integer.valueOf(start) : new IntRange(start, end - 1));
        return new ReservedElement(DEFAULT_LOCATION, "", values2);
    }

    private static ReservedElement toReserved(DescriptorProtos.EnumDescriptorProto.EnumReservedRange range) {
        int end;
        ArrayList<Object> values2 = new ArrayList<Object>();
        int start = range.getStart();
        values2.add(start == (end = range.getEnd()) ? Integer.valueOf(start) : new IntRange(start, end));
        return new ReservedElement(DEFAULT_LOCATION, "", values2);
    }

    private static ExtensionsElement toExtension(DescriptorProtos.DescriptorProto.ExtensionRange range) {
        int end;
        ArrayList<Object> values2 = new ArrayList<Object>();
        int start = range.getStart();
        values2.add(start == (end = range.getEnd()) - 1 ? Integer.valueOf(start) : new IntRange(start, end - 1));
        return new ExtensionsElement(DEFAULT_LOCATION, "", values2);
    }

    private static ServiceElement toService(DescriptorProtos.ServiceDescriptorProto sd) {
        String name = sd.getName();
        log.trace("*** service name: {}", (Object)name);
        ImmutableList.Builder methods2 = ImmutableList.builder();
        for (DescriptorProtos.MethodDescriptorProto method : sd.getMethodList()) {
            OptionElement option;
            ImmutableList.Builder options = ImmutableList.builder();
            if (method.getOptions().hasDeprecated()) {
                option = new OptionElement(DEPRECATED, OptionElement.Kind.BOOLEAN, method.getOptions().getDeprecated(), false);
                options.add(option);
            }
            if (method.getOptions().hasIdempotencyLevel()) {
                option = new OptionElement(IDEMPOTENCY_LEVEL, OptionElement.Kind.ENUM, method.getOptions().getIdempotencyLevel(), false);
                options.add(option);
            }
            options.addAll(ProtobufSchema.toCustomOptions(method.getOptions()));
            methods2.add(new RpcElement(DEFAULT_LOCATION, method.getName(), "", method.getInputType(), method.getOutputType(), method.getClientStreaming(), method.getServerStreaming(), (List<OptionElement>)((Object)options.build())));
        }
        ImmutableList.Builder options = ImmutableList.builder();
        if (sd.getOptions().hasDeprecated()) {
            OptionElement option = new OptionElement(DEPRECATED, OptionElement.Kind.BOOLEAN, sd.getOptions().getDeprecated(), false);
            options.add(option);
        }
        options.addAll(ProtobufSchema.toCustomOptions(sd.getOptions()));
        return new ServiceElement(DEFAULT_LOCATION, name, "", (List<RpcElement>)((Object)methods2.build()), (List<OptionElement>)((Object)options.build()));
    }

    private static FieldElement toField(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.FieldDescriptorProto fd, boolean inOneof) {
        MetaProto.Meta meta;
        OptionElement option;
        OptionElement option2;
        String name = fd.getName();
        log.trace("*** field name: {}", (Object)name);
        ImmutableList.Builder options = ImmutableList.builder();
        if (fd.getOptions().hasCtype()) {
            option2 = new OptionElement(CTYPE, OptionElement.Kind.ENUM, fd.getOptions().getCtype(), false);
            options.add(option2);
        }
        if (fd.getOptions().hasPacked()) {
            option2 = new OptionElement(PACKED, OptionElement.Kind.BOOLEAN, fd.getOptions().getPacked(), false);
            options.add(option2);
        }
        if (fd.getOptions().hasJstype()) {
            option2 = new OptionElement(JSTYPE, OptionElement.Kind.ENUM, fd.getOptions().getJstype(), false);
            options.add(option2);
        }
        if (fd.getOptions().hasDeprecated()) {
            option2 = new OptionElement(DEPRECATED, OptionElement.Kind.BOOLEAN, fd.getOptions().getDeprecated(), false);
            options.add(option2);
        }
        if (fd.getOptions().hasExtension(MetaProto.fieldMeta) && (option = ProtobufSchema.toOption(CONFLUENT_FIELD_META, meta = fd.getOptions().getExtension(MetaProto.fieldMeta))) != null) {
            options.add(option);
        }
        options.addAll(ProtobufSchema.toCustomOptions(fd.getOptions()));
        String jsonName = fd.hasJsonName() ? fd.getJsonName() : null;
        String defaultValue = !PROTO3.equals(file.getSyntax()) && fd.hasDefaultValue() ? fd.getDefaultValue() : null;
        return new FieldElement(DEFAULT_LOCATION, inOneof ? null : ProtobufSchema.label(file, fd), ProtobufSchema.dataType(fd), name, defaultValue, jsonName, fd.getNumber(), "", (List<OptionElement>)((Object)options.build()));
    }

    private static Field.Label label(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.FieldDescriptorProto fd) {
        if (fd.getProto3Optional()) {
            return Field.Label.OPTIONAL;
        }
        boolean isProto3 = file.getSyntax().equals(PROTO3);
        switch (fd.getLabel()) {
            case LABEL_REQUIRED: {
                return isProto3 ? null : Field.Label.REQUIRED;
            }
            case LABEL_OPTIONAL: {
                return isProto3 ? null : Field.Label.OPTIONAL;
            }
            case LABEL_REPEATED: {
                return Field.Label.REPEATED;
            }
        }
        throw new IllegalArgumentException("Unsupported label");
    }

    private static String dataType(DescriptorProtos.FieldDescriptorProto field) {
        if (field.hasTypeName()) {
            return field.getTypeName();
        }
        DescriptorProtos.FieldDescriptorProto.Type type = field.getType();
        return Descriptors.FieldDescriptor.Type.valueOf(type).name().toLowerCase();
    }

    public Descriptors.Descriptor toDescriptor() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.descriptor == null) {
            this.descriptor = this.toDescriptor(this.name());
        }
        return this.descriptor;
    }

    public Descriptors.Descriptor toDescriptor(String name) {
        return this.toDynamicSchema().getMessageDescriptor(name);
    }

    public DynamicMessage.Builder newMessageBuilder() {
        return this.newMessageBuilder(this.name());
    }

    public DynamicMessage.Builder newMessageBuilder(String name) {
        return this.toDynamicSchema().newMessageBuilder(name);
    }

    public Descriptors.EnumDescriptor getEnumDescriptor(String enumTypeName) {
        return this.toDynamicSchema().getEnumDescriptor(enumTypeName);
    }

    public Descriptors.EnumValueDescriptor getEnumValue(String enumTypeName, int enumNumber) {
        return this.toDynamicSchema().getEnumValue(enumTypeName, enumNumber);
    }

    private MessageElement firstMessage() {
        for (TypeElement typeElement : this.schemaObj.getTypes()) {
            if (!(typeElement instanceof MessageElement)) continue;
            return (MessageElement)typeElement;
        }
        return null;
    }

    private EnumElement firstEnum() {
        for (TypeElement typeElement : this.schemaObj.getTypes()) {
            if (!(typeElement instanceof EnumElement)) continue;
            return (EnumElement)typeElement;
        }
        return null;
    }

    public DynamicSchema toDynamicSchema() {
        return this.toDynamicSchema(DEFAULT_NAME);
    }

    public DynamicSchema toDynamicSchema(String name) {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.dynamicSchema == null) {
            HashMap<String, DynamicSchema> cache = new HashMap<String, DynamicSchema>();
            this.dynamicSchema = ProtobufSchema.toDynamicSchema(name, this.schemaObj, this.dependenciesWithLogicalTypes(), cache);
        }
        return this.dynamicSchema;
    }

    private static DynamicSchema toDynamicSchema(String name, ProtoFileElement rootElem, Map<String, ProtoFileElement> dependencies, Map<String, DynamicSchema> cache) {
        if (cache.containsKey(name)) {
            return cache.get(name);
        }
        if (log.isTraceEnabled()) {
            log.trace("*** toDynamicSchema: {}", (Object)ProtobufSchemaUtils.toString(rootElem));
        }
        DynamicSchema.Builder schema = DynamicSchema.newBuilder();
        try {
            OptionElement rubyPackage;
            OptionElement phpMetadataNamespace;
            OptionElement phpNamespace;
            OptionElement phpClassPrefix;
            OptionElement swiftPrefix;
            OptionElement csharpNamespace;
            OptionElement objcClassPrefix;
            OptionElement ccEnableArenas;
            OptionElement isDeprecated;
            OptionElement phpGenericServices;
            OptionElement pyGenericServices;
            OptionElement javaGenericServices;
            OptionElement ccGenericServices;
            OptionElement goPackage;
            OptionElement optimizeFor;
            OptionElement javaStringCheckUtf8;
            OptionElement javaGenerateEqualsAndHash;
            OptionElement javaMultipleFiles;
            OptionElement javaOuterClassname;
            ProtoFileElement dep;
            Syntax syntax = rootElem.getSyntax();
            if (syntax != null) {
                schema.setSyntax(syntax.toString());
            }
            if (rootElem.getPackageName() != null) {
                schema.setPackage(rootElem.getPackageName());
            }
            for (TypeElement typeElem : rootElem.getTypes()) {
                if (typeElem instanceof MessageElement) {
                    MessageDefinition message = ProtobufSchema.toDynamicMessage(syntax, (MessageElement)typeElem);
                    schema.addMessageDefinition(message);
                    continue;
                }
                if (!(typeElem instanceof EnumElement)) continue;
                EnumDefinition enumer = ProtobufSchema.toDynamicEnum((EnumElement)typeElem);
                schema.addEnumDefinition(enumer);
            }
            for (ServiceElement serviceElement : rootElem.getServices()) {
                ServiceDefinition service = ProtobufSchema.toDynamicService(serviceElement);
                schema.addServiceDefinition(service);
            }
            for (ExtendElement extendElement : rootElem.getExtendDeclarations()) {
                for (FieldElement field : extendElement.getFields()) {
                    Field.Label fieldLabel = field.getLabel();
                    String label = fieldLabel != null ? fieldLabel.toString().toLowerCase() : null;
                    String fieldType = field.getType();
                    String defaultVal = field.getDefaultValue();
                    String jsonName = field.getJsonName();
                    Map<String, OptionElement> options = ProtobufSchema.mergeOptions(field.getOptions());
                    DescriptorProtos.FieldOptions.CType ctype = ProtobufSchema.findOption(CTYPE, options).map(o -> DescriptorProtos.FieldOptions.CType.valueOf(o.getValue().toString())).orElse(null);
                    Boolean isPacked = ProtobufSchema.findOption(PACKED, options).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
                    DescriptorProtos.FieldOptions.JSType jstype = ProtobufSchema.findOption(JSTYPE, options).map(o -> DescriptorProtos.FieldOptions.JSType.valueOf(o.getValue().toString())).orElse(null);
                    Boolean isDeprecated2 = ProtobufSchema.findOption(DEPRECATED, options).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
                    ProtobufMeta metadata = ProtobufSchema.findMeta(CONFLUENT_FIELD_META, options);
                    schema.addExtendDefinition(extendElement.getName(), label, fieldType, field.getName(), field.getTag(), defaultVal, jsonName, metadata, ctype, isPacked, jstype, isDeprecated2);
                }
            }
            for (String ref : rootElem.getImports()) {
                dep = dependencies.get(ref);
                if (dep == null) continue;
                schema.addDependency(ref);
                schema.addSchema(ProtobufSchema.toDynamicSchema(ref, dep, dependencies, cache));
            }
            for (String ref : rootElem.getPublicImports()) {
                dep = dependencies.get(ref);
                if (dep == null) continue;
                schema.addPublicDependency(ref);
                schema.addSchema(ProtobufSchema.toDynamicSchema(ref, dep, dependencies, cache));
            }
            Map<String, OptionElement> options = ProtobufSchema.mergeOptions(rootElem.getOptions());
            OptionElement javaPackageName = options.get(JAVA_PACKAGE);
            if (javaPackageName != null) {
                schema.setJavaPackage(javaPackageName.getValue().toString());
            }
            if ((javaOuterClassname = options.get(JAVA_OUTER_CLASSNAME)) != null) {
                schema.setJavaOuterClassname(javaOuterClassname.getValue().toString());
            }
            if ((javaMultipleFiles = options.get(JAVA_MULTIPLE_FILES)) != null) {
                schema.setJavaMultipleFiles(Boolean.parseBoolean(javaMultipleFiles.getValue().toString()));
            }
            if ((javaGenerateEqualsAndHash = options.get(JAVA_GENERATE_EQUALS_AND_HASH)) != null) {
                schema.setJavaGenerateEqualsAndHash(Boolean.parseBoolean(javaGenerateEqualsAndHash.getValue().toString()));
            }
            if ((javaStringCheckUtf8 = options.get(JAVA_STRING_CHECK_UTF8)) != null) {
                schema.setJavaStringCheckUtf8(Boolean.parseBoolean(javaStringCheckUtf8.getValue().toString()));
            }
            if ((optimizeFor = options.get(OPTIMIZE_FOR)) != null) {
                schema.setOptimizeFor(DescriptorProtos.FileOptions.OptimizeMode.valueOf(optimizeFor.getValue().toString()));
            }
            if ((goPackage = options.get(GO_PACKAGE)) != null) {
                schema.setGoPackage(goPackage.getValue().toString());
            }
            if ((ccGenericServices = options.get(CC_GENERIC_SERVICES)) != null) {
                schema.setCcGenericServices(Boolean.parseBoolean(ccGenericServices.getValue().toString()));
            }
            if ((javaGenericServices = options.get(JAVA_GENERIC_SERVICES)) != null) {
                schema.setJavaGenericServices(Boolean.parseBoolean(javaGenericServices.getValue().toString()));
            }
            if ((pyGenericServices = options.get(PY_GENERIC_SERVICES)) != null) {
                schema.setPyGenericServices(Boolean.parseBoolean(pyGenericServices.getValue().toString()));
            }
            if ((phpGenericServices = options.get(PHP_GENERIC_SERVICES)) != null) {
                schema.setPhpGenericServices(Boolean.parseBoolean(phpGenericServices.getValue().toString()));
            }
            if ((isDeprecated = options.get(DEPRECATED)) != null) {
                schema.setDeprecated(Boolean.parseBoolean(isDeprecated.getValue().toString()));
            }
            if ((ccEnableArenas = options.get(CC_ENABLE_ARENAS)) != null) {
                schema.setCcEnableArenas(Boolean.parseBoolean(ccEnableArenas.getValue().toString()));
            }
            if ((objcClassPrefix = options.get(OBJC_CLASS_PREFIX)) != null) {
                schema.setObjcClassPrefix(objcClassPrefix.getValue().toString());
            }
            if ((csharpNamespace = options.get(CSHARP_NAMESPACE)) != null) {
                schema.setCsharpNamespace(csharpNamespace.getValue().toString());
            }
            if ((swiftPrefix = options.get(SWIFT_PREFIX)) != null) {
                schema.setSwiftPrefix(swiftPrefix.getValue().toString());
            }
            if ((phpClassPrefix = options.get(PHP_CLASS_PREFIX)) != null) {
                schema.setPhpClassPrefix(phpClassPrefix.getValue().toString());
            }
            if ((phpNamespace = options.get(PHP_NAMESPACE)) != null) {
                schema.setPhpNamespace(phpNamespace.getValue().toString());
            }
            if ((phpMetadataNamespace = options.get(PHP_METADATA_NAMESPACE)) != null) {
                schema.setPhpMetadataNamespace(phpMetadataNamespace.getValue().toString());
            }
            if ((rubyPackage = options.get(RUBY_PACKAGE)) != null) {
                schema.setRubyPackage(rubyPackage.getValue().toString());
            }
            ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_FILE_META, options);
            schema.setMeta(meta);
            schema.setName(name);
            DynamicSchema dynamicSchema = schema.build();
            cache.put(name, dynamicSchema);
            return dynamicSchema;
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, OptionElement> mergeOptions(List<OptionElement> options) {
        return options.stream().collect(Collectors.toMap(o -> o.getName().startsWith(".") ? o.getName().substring(1) : o.getName(), ProtobufSchema::transform, ProtobufSchema::merge));
    }

    protected static OptionElement merge(OptionElement existing, OptionElement replacement) {
        replacement = ProtobufSchema.transform(replacement);
        if (existing.getKind() == OptionElement.Kind.MAP && replacement.getKind() == OptionElement.Kind.MAP) {
            Map existingMap = (Map)existing.getValue();
            Map replacementMap = (Map)replacement.getValue();
            LinkedHashMap mergedMap = new LinkedHashMap(existingMap);
            for (Map.Entry entry : replacementMap.entrySet()) {
                mergedMap.merge(entry.getKey(), entry.getValue(), (v1, v2) -> {
                    LinkedHashSet<Object> set = new LinkedHashSet<Object>();
                    if (v1 instanceof List) {
                        set.addAll((List)v1);
                    } else {
                        set.add(v1);
                    }
                    if (v2 instanceof List) {
                        set.addAll((List)v2);
                    } else {
                        set.add(v2);
                    }
                    return new ArrayList(set);
                });
            }
            return new OptionElement(replacement.getName(), OptionElement.Kind.MAP, mergedMap, replacement.isParenthesized());
        }
        return replacement;
    }

    protected static OptionElement transform(OptionElement option) {
        if (option.getKind() == OptionElement.Kind.OPTION) {
            Map<String, ?> map = ProtobufSchema.transformOptionMap(option);
            return new OptionElement(option.getName(), OptionElement.Kind.MAP, map, option.isParenthesized());
        }
        return option;
    }

    private static Map<String, ?> transformOptionMap(OptionElement option) {
        if (option.getKind() != OptionElement.Kind.OPTION) {
            throw new IllegalArgumentException("Expected option of kind OPTION");
        }
        OptionElement value = (OptionElement)option.getValue();
        Map<String, ?> mapValue = value.getValue();
        OptionElement.Kind kind2 = value.getKind();
        if (kind2 == OptionElement.Kind.BOOLEAN || kind2 == OptionElement.Kind.ENUM || kind2 == OptionElement.Kind.NUMBER) {
            mapValue = new OptionElement.OptionPrimitive(kind2, mapValue);
        } else if (kind2 == OptionElement.Kind.OPTION) {
            mapValue = ProtobufSchema.transformOptionMap(value);
        }
        return Collections.singletonMap(value.getName(), mapValue);
    }

    private static MessageDefinition toDynamicMessage(Syntax syntax, MessageElement messageElem) {
        log.trace("*** message: {}", (Object)messageElem.getName());
        MessageDefinition.Builder message = MessageDefinition.newBuilder(messageElem.getName());
        for (TypeElement typeElement : messageElem.getNestedTypes()) {
            if (typeElement instanceof MessageElement) {
                message.addMessageDefinition(ProtobufSchema.toDynamicMessage(syntax, (MessageElement)typeElement));
                continue;
            }
            if (!(typeElement instanceof EnumElement)) continue;
            message.addEnumDefinition(ProtobufSchema.toDynamicEnum((EnumElement)typeElement));
        }
        HashSet<String> added = new HashSet<String>();
        for (OneOfElement oneof : messageElem.getOneOfs()) {
            MessageDefinition.OneofBuilder oneofBuilder = message.addOneof(oneof.getName());
            for (FieldElement field : oneof.getFields()) {
                String defaultVal = field.getDefaultValue();
                String jsonName = field.getJsonName();
                Map<String, OptionElement> options = ProtobufSchema.mergeOptions(field.getOptions());
                DescriptorProtos.FieldOptions.CType ctype = ProtobufSchema.findOption(CTYPE, options).map(o -> DescriptorProtos.FieldOptions.CType.valueOf(o.getValue().toString())).orElse(null);
                DescriptorProtos.FieldOptions.JSType jstype = ProtobufSchema.findOption(JSTYPE, options).map(o -> DescriptorProtos.FieldOptions.JSType.valueOf(o.getValue().toString())).orElse(null);
                Boolean isDeprecated = ProtobufSchema.findOption(DEPRECATED, options).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
                ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_FIELD_META, options);
                oneofBuilder.addField(false, field.getType(), field.getName(), field.getTag(), defaultVal, jsonName, meta, ctype, jstype, isDeprecated);
                added.add(field.getName());
            }
        }
        for (FieldElement field : messageElem.getFields()) {
            if (added.contains(field.getName())) continue;
            Field.Label fieldLabel = field.getLabel();
            String label = fieldLabel != null ? fieldLabel.toString().toLowerCase() : null;
            boolean isProto3Optional = "optional".equals(label) && syntax == Syntax.PROTO_3;
            String fieldType = field.getType();
            String defaultVal = field.getDefaultValue();
            String jsonName = field.getJsonName();
            Map<String, OptionElement> options = ProtobufSchema.mergeOptions(field.getOptions());
            DescriptorProtos.FieldOptions.CType ctype = ProtobufSchema.findOption(CTYPE, options).map(o -> DescriptorProtos.FieldOptions.CType.valueOf(o.getValue().toString())).orElse(null);
            Boolean isPacked = ProtobufSchema.findOption(PACKED, options).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
            DescriptorProtos.FieldOptions.JSType jstype = ProtobufSchema.findOption(JSTYPE, options).map(o -> DescriptorProtos.FieldOptions.JSType.valueOf(o.getValue().toString())).orElse(null);
            Boolean isDeprecated = ProtobufSchema.findOption(DEPRECATED, options).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
            ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_FIELD_META, options);
            ProtoType protoType = ProtoType.get(fieldType);
            ProtoType keyType = protoType.getKeyType();
            ProtoType valueType = protoType.getValueType();
            if (protoType.isMap() && keyType != null && valueType != null) {
                label = "repeated";
                fieldType = ProtobufSchema.toMapEntry(field.getName());
                MessageDefinition.Builder mapMessage = MessageDefinition.newBuilder(fieldType);
                mapMessage.setMapEntry(true);
                mapMessage.addField(null, keyType.toString(), KEY_FIELD, 1, null, null);
                mapMessage.addField(null, valueType.toString(), VALUE_FIELD, 2, null, null);
                message.addMessageDefinition(mapMessage.build());
            }
            if (isProto3Optional) {
                MessageDefinition.OneofBuilder oneofBuilder = message.addOneof("_" + field.getName());
                oneofBuilder.addField(true, fieldType, field.getName(), field.getTag(), defaultVal, jsonName, meta, ctype, jstype, isDeprecated);
                continue;
            }
            message.addField(label, fieldType, field.getName(), field.getTag(), defaultVal, jsonName, meta, ctype, isPacked, jstype, isDeprecated);
        }
        for (ReservedElement reserved : messageElem.getReserveds()) {
            for (Object elem : reserved.getValues()) {
                if (elem instanceof String) {
                    message.addReservedName((String)elem);
                    continue;
                }
                if (elem instanceof Integer) {
                    int tag = (Integer)elem;
                    message.addReservedRange(tag, tag + 1);
                    continue;
                }
                if (elem instanceof IntRange) {
                    IntRange range = (IntRange)elem;
                    message.addReservedRange(range.getStart(), range.getEndInclusive() + 1);
                    continue;
                }
                throw new IllegalStateException("Unsupported reserved type: " + elem.getClass().getName());
            }
        }
        for (ExtensionsElement extension : messageElem.getExtensions()) {
            for (Object elem : extension.getValues()) {
                if (elem instanceof Integer) {
                    int tag = (Integer)elem;
                    message.addExtensionRange(tag, tag + 1);
                    continue;
                }
                if (elem instanceof IntRange) {
                    IntRange range = (IntRange)elem;
                    message.addExtensionRange(range.getStart(), range.getEndInclusive() + 1);
                    continue;
                }
                throw new IllegalStateException("Unsupported extensions type: " + elem.getClass().getName());
            }
        }
        for (ExtendElement extendElement : messageElem.getExtendDeclarations()) {
            for (FieldElement field : extendElement.getFields()) {
                Field.Label fieldLabel = field.getLabel();
                String label = fieldLabel != null ? fieldLabel.toString().toLowerCase() : null;
                String fieldType = field.getType();
                String defaultVal = field.getDefaultValue();
                String jsonName = field.getJsonName();
                Map<String, OptionElement> options = ProtobufSchema.mergeOptions(field.getOptions());
                DescriptorProtos.FieldOptions.CType ctype = ProtobufSchema.findOption(CTYPE, options).map(o -> DescriptorProtos.FieldOptions.CType.valueOf(o.getValue().toString())).orElse(null);
                Boolean isPacked = ProtobufSchema.findOption(PACKED, options).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
                DescriptorProtos.FieldOptions.JSType jstype = ProtobufSchema.findOption(JSTYPE, options).map(o -> DescriptorProtos.FieldOptions.JSType.valueOf(o.getValue().toString())).orElse(null);
                Boolean isDeprecated = ProtobufSchema.findOption(DEPRECATED, options).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
                ProtobufMeta metadata = ProtobufSchema.findMeta(CONFLUENT_FIELD_META, options);
                message.addExtendDefinition(extendElement.getName(), label, fieldType, field.getName(), field.getTag(), defaultVal, jsonName, metadata, ctype, isPacked, jstype, isDeprecated);
            }
        }
        Map<String, OptionElement> map = ProtobufSchema.mergeOptions(messageElem.getOptions());
        ProtobufSchema.findOption(NO_STANDARD_DESCRIPTOR_ACCESSOR, map).map(o -> Boolean.valueOf(o.getValue().toString())).ifPresent(message::setNoStandardDescriptorAccessor);
        ProtobufSchema.findOption(DEPRECATED, map).map(o -> Boolean.valueOf(o.getValue().toString())).ifPresent(message::setDeprecated);
        ProtobufSchema.findOption(MAP_ENTRY, map).map(o -> Boolean.valueOf(o.getValue().toString())).ifPresent(message::setMapEntry);
        ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_MESSAGE_META, map);
        message.setMeta(meta);
        return message.build();
    }

    public static Optional<OptionElement> findOption(String name, List<OptionElement> options) {
        return ProtobufSchema.findOption(name, ProtobufSchema.mergeOptions(options));
    }

    public static Optional<OptionElement> findOption(String name, Map<String, OptionElement> options) {
        return Optional.ofNullable(options.get(name));
    }

    public static ProtobufMeta findMeta(String name, List<OptionElement> options) {
        return ProtobufSchema.findMeta(name, ProtobufSchema.mergeOptions(options));
    }

    public static ProtobufMeta findMeta(String name, Map<String, OptionElement> options) {
        Optional<OptionElement> meta = ProtobufSchema.findOption(name, options);
        if (!meta.isPresent()) {
            return null;
        }
        return new ProtobufMeta(ProtobufSchema.findDoc(meta), ProtobufSchema.findParams(meta), ProtobufSchema.findTags(meta));
    }

    public static String findDoc(Optional<OptionElement> meta) {
        return (String)ProtobufSchema.findMetaField(meta, DOC_FIELD);
    }

    public static Map<String, String> findParams(Optional<OptionElement> meta) {
        Object result = ProtobufSchema.findMetaField(meta, PARAMS_FIELD);
        if (result == null) {
            return null;
        }
        if (result instanceof Map) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            Map keyValue = (Map)result;
            String key = (String)keyValue.get(KEY_FIELD);
            String value = (String)keyValue.get(VALUE_FIELD);
            params.put(key, value);
            return params;
        }
        if (result instanceof List) {
            List keyValues = (List)result;
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            for (Map keyValue : keyValues) {
                String key = (String)keyValue.get(KEY_FIELD);
                String value = (String)keyValue.get(VALUE_FIELD);
                params.put(key, value);
            }
            return params;
        }
        throw new IllegalStateException("Unrecognized params type " + result.getClass().getName());
    }

    public static List<String> findTags(Optional<OptionElement> meta) {
        Object result = ProtobufSchema.findMetaField(meta, TAGS_FIELD);
        if (result instanceof List) {
            return (List)result;
        }
        return result != null ? Collections.singletonList(result.toString()) : null;
    }

    private static Object findMetaField(Optional<OptionElement> meta, String name) {
        OptionElement options = meta.get();
        switch (options.getKind()) {
            case OPTION: {
                OptionElement option = (OptionElement)options.getValue();
                if (option.getName().equals(name)) {
                    return option.getValue();
                }
                return null;
            }
            case MAP: {
                Map map = (Map)options.getValue();
                return map.get(name);
            }
        }
        throw new IllegalStateException("Unexpected custom option kind " + (Object)((Object)options.getKind()));
    }

    private static EnumDefinition toDynamicEnum(EnumElement enumElem) {
        Map<String, OptionElement> enumOptions = ProtobufSchema.mergeOptions(enumElem.getOptions());
        Boolean allowAlias = ProtobufSchema.findOption(ALLOW_ALIAS, enumOptions).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
        Boolean isDeprecated = ProtobufSchema.findOption(DEPRECATED, enumOptions).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
        EnumDefinition.Builder enumer = EnumDefinition.newBuilder(enumElem.getName(), allowAlias, isDeprecated);
        for (ReservedElement reserved : enumElem.getReserveds()) {
            for (Object elem : reserved.getValues()) {
                if (elem instanceof String) {
                    enumer.addReservedName((String)elem);
                    continue;
                }
                if (elem instanceof Integer) {
                    int tag = (Integer)elem;
                    enumer.addReservedRange(tag, tag);
                    continue;
                }
                if (elem instanceof IntRange) {
                    IntRange range = (IntRange)elem;
                    enumer.addReservedRange(range.getStart(), range.getEndInclusive());
                    continue;
                }
                throw new IllegalStateException("Unsupported reserved type: " + elem.getClass().getName());
            }
        }
        for (EnumConstantElement constant : enumElem.getConstants()) {
            Map<String, OptionElement> constantOptions = ProtobufSchema.mergeOptions(constant.getOptions());
            Boolean isConstDeprecated = ProtobufSchema.findOption(DEPRECATED, constantOptions).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
            ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_ENUM_VALUE_META, constantOptions);
            enumer.addValue(constant.getName(), constant.getTag(), meta, isConstDeprecated);
        }
        ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_ENUM_META, enumOptions);
        enumer.setMeta(meta);
        return enumer.build();
    }

    private static ServiceDefinition toDynamicService(ServiceElement serviceElement) {
        ServiceDefinition.Builder service = ServiceDefinition.newBuilder(serviceElement.getName());
        Map<String, OptionElement> serviceOptions = ProtobufSchema.mergeOptions(serviceElement.getOptions());
        ProtobufSchema.findOption(DEPRECATED, serviceOptions).map(o -> Boolean.valueOf(o.getValue().toString())).ifPresent(service::setDeprecated);
        for (RpcElement method : serviceElement.getRpcs()) {
            Map<String, OptionElement> methodOptions = ProtobufSchema.mergeOptions(method.getOptions());
            Boolean isMethodDeprecated = ProtobufSchema.findOption(DEPRECATED, methodOptions).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
            DescriptorProtos.MethodOptions.IdempotencyLevel idempotencyLevel = ProtobufSchema.findOption(IDEMPOTENCY_LEVEL, methodOptions).map(o -> DescriptorProtos.MethodOptions.IdempotencyLevel.valueOf(o.getValue().toString())).orElse(null);
            service.addMethod(method.getName(), method.getRequestType(), method.getResponseType(), method.getRequestStreaming(), method.getResponseStreaming(), isMethodDeprecated, idempotencyLevel);
        }
        return service.build();
    }

    @Override
    public ProtoFileElement rawSchema() {
        return this.schemaObj;
    }

    @Override
    public boolean hasTopLevelField(String field) {
        return this.schemaObj != null && this.schemaObj.getTypes().stream().map(ProtobufSchema::getFieldNames).flatMap(Collection::stream).anyMatch(property -> property.equals(field));
    }

    @Override
    public String schemaType() {
        return TYPE;
    }

    @Override
    public String name() {
        if (this.name != null) {
            return this.name;
        }
        TypeElement typeElement = this.firstMessage();
        if (typeElement == null) {
            typeElement = this.firstEnum();
        }
        if (typeElement == null) {
            throw new IllegalArgumentException("Protobuf schema definition contains no type definitions");
        }
        String typeName = typeElement.getName();
        String packageName = this.schemaObj.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + '.' + typeName : typeName;
    }

    @Override
    public String canonicalString() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.canonicalString == null) {
            this.canonicalString = ProtobufSchemaUtils.toString(this.schemaObj);
        }
        return this.canonicalString;
    }

    @Override
    public String formattedString(String format) {
        if (format == null || format.trim().isEmpty()) {
            return this.canonicalString();
        }
        Format formatEnum = Format.get(format);
        switch (formatEnum) {
            case DEFAULT: {
                return this.canonicalString();
            }
            case IGNORE_EXTENSIONS: {
                ProtobufSchemaUtils.FormatContext ctx = new ProtobufSchemaUtils.FormatContext(true, false);
                return ProtobufSchemaUtils.toFormattedString(ctx, this);
            }
            case SERIALIZED: {
                DescriptorProtos.FileDescriptorProto file = this.toDynamicSchema().getFileDescriptorProto();
                return base64Encoder.encodeToString(file.toByteArray());
            }
        }
        log.warn("Unsupported format {}", (Object)format);
        return this.canonicalString();
    }

    @Override
    public Integer version() {
        return this.version;
    }

    @Override
    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.dependencies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ProtobufSchemaUtils.toString((ProtoFileElement)e.getValue())));
    }

    public Map<String, ProtoFileElement> dependencies() {
        return this.dependencies;
    }

    public Map<String, ProtoFileElement> dependenciesWithLogicalTypes() {
        HashMap<String, ProtoFileElement> deps = new HashMap<String, ProtoFileElement>(this.dependencies);
        for (Map.Entry<String, ProtoFileElement> entry : KNOWN_DEPENDENCIES.entrySet()) {
            if (deps.containsKey(entry.getKey())) continue;
            deps.put(entry.getKey(), entry.getValue());
        }
        return deps;
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public RuleSet ruleSet() {
        return this.ruleSet;
    }

    @Override
    public ProtobufSchema normalize() {
        String normalized = ProtobufSchemaUtils.toNormalizedString(this);
        return new ProtobufSchema(this.toProtoFile(normalized), this.version, this.name, this.references.stream().sorted().distinct().collect(Collectors.toList()), this.dependencies, this.metadata, this.ruleSet, normalized, null, null);
    }

    @Override
    public void validate(boolean strict) {
        this.normalize();
    }

    @Override
    public List<String> isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return Lists.newArrayList("Incompatible because of different schema type");
        }
        List<Difference> differences = SchemaDiff.compare((ProtobufSchema)previousSchema, this);
        List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains((Object)diff.getType())).collect(Collectors.toList());
        boolean isCompatible = incompatibleDiffs.isEmpty();
        if (!isCompatible) {
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (Difference incompatibleDiff : incompatibleDiffs) {
                errorMessages.add(incompatibleDiff.toString());
            }
            return errorMessages;
        }
        return new ArrayList<String>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtobufSchema that = (ProtobufSchema)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.references, that.references) && Objects.equals(this.canonicalString(), that.canonicalString()) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet);
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.canonicalString(), this.references, this.version, this.metadata, this.ruleSet);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.canonicalString();
    }

    public Descriptors.GenericDescriptor toSpecificDescriptor(String originalPath) {
        String clsName = this.fullName(originalPath);
        if (clsName == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(clsName);
            Method parseMethod = cls.getDeclaredMethod("getDescriptor", new Class[0]);
            return (Descriptors.GenericDescriptor)parseMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + clsName + " could not be found.");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + clsName + " is not a valid protobuf message class", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Not a valid protobuf builder");
        }
    }

    public String fullName() {
        return this.fullName(null);
    }

    public String fullName(String originalPath) {
        Map<String, OptionElement> options = ProtobufSchema.mergeOptions(this.schemaObj.getOptions());
        OptionElement javaPackageName = options.get(JAVA_PACKAGE);
        OptionElement javaOuterClassname = options.get(JAVA_OUTER_CLASSNAME);
        OptionElement javaMultipleFiles = options.get(JAVA_MULTIPLE_FILES);
        String outer = "";
        if (javaMultipleFiles == null || !Boolean.parseBoolean(javaMultipleFiles.getValue().toString())) {
            if (javaOuterClassname != null) {
                outer = javaOuterClassname.getValue().toString();
            } else if (originalPath != null) {
                Path path = Paths.get(originalPath, new String[0]).getFileName();
                if (path != null) {
                    String fileName = path.toString();
                    if (fileName.endsWith(".proto")) {
                        fileName = fileName.substring(0, fileName.length() - ".proto".length());
                    }
                    if (this.hasConflictingClassName(outer = ProtobufSchema.underscoresToCamelCase(fileName, true))) {
                        outer = outer + "OuterClass";
                    }
                }
            } else {
                return null;
            }
        }
        String p = javaPackageName != null ? javaPackageName.getValue().toString() : this.schemaObj.getPackageName();
        StringBuilder inner = new StringBuilder();
        String typeName = this.name;
        if (typeName == null && !this.schemaObj.getTypes().isEmpty()) {
            typeName = this.name();
        }
        List<TypeElement> typeElems = this.toTypeElements(typeName);
        for (TypeElement typeElem : typeElems) {
            if (inner.length() > 0) {
                inner.append("$");
            }
            inner.append(typeElem.getName());
        }
        String d1 = !outer.isEmpty() || inner.length() != 0 ? "." : "";
        String d2 = !outer.isEmpty() && inner.length() != 0 ? "$" : "";
        return p + d1 + outer + d2 + inner;
    }

    private boolean hasConflictingClassName(String className) {
        for (TypeElement type : this.schemaObj.getTypes()) {
            if (type.getName().equals(className)) {
                return true;
            }
            if (!(type instanceof MessageElement) || !this.messageHasConflictingClassName(className, (MessageElement)type)) continue;
            return true;
        }
        for (ServiceElement service : this.schemaObj.getServices()) {
            if (!service.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private boolean messageHasConflictingClassName(String className, MessageElement message) {
        for (TypeElement type : message.getNestedTypes()) {
            if (type.getName().equals(className)) {
                return true;
            }
            if (!(type instanceof MessageElement) || !this.messageHasConflictingClassName(className, (MessageElement)type)) continue;
            return true;
        }
        return false;
    }

    public MessageIndexes toMessageIndexes(String name) {
        return this.toMessageIndexes(name, false);
    }

    public MessageIndexes toMessageIndexes(String name, boolean normalize) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        String[] parts = name.split("\\.");
        List<TypeElement> types = this.schemaObj.getTypes();
        block0: for (String part : parts) {
            int i = 0;
            for (TypeElement type : types) {
                boolean isMapEntry;
                if (!(type instanceof MessageElement) || normalize && (isMapEntry = ProtobufSchema.findOption(MAP_ENTRY, type.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(false).booleanValue())) continue;
                if (type.getName().equals(part)) {
                    indexes.add(i);
                    types = type.getNestedTypes();
                    continue block0;
                }
                ++i;
            }
        }
        return new MessageIndexes(indexes);
    }

    public String toMessageName(MessageIndexes indexes) {
        StringBuilder sb = new StringBuilder();
        List<TypeElement> types = this.schemaObj.getTypes();
        boolean first = true;
        for (Integer index : indexes.indexes()) {
            if (!first) {
                sb.append(".");
            } else {
                first = false;
            }
            MessageElement message = this.getMessageAtIndex(types, index);
            if (message == null) {
                throw new IllegalArgumentException("Invalid message indexes: " + indexes);
            }
            sb.append(message.getName());
            types = message.getNestedTypes();
        }
        String messageName = sb.toString();
        String packageName = this.schemaObj.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + '.' + messageName : messageName;
    }

    private MessageElement getMessageAtIndex(List<TypeElement> types, int index) {
        int i = 0;
        for (TypeElement type : types) {
            if (!(type instanceof MessageElement)) continue;
            if (index == i) {
                return (MessageElement)type;
            }
            ++i;
        }
        return null;
    }

    private List<TypeElement> toTypeElements(String name) {
        ArrayList<TypeElement> typeElems = new ArrayList<TypeElement>();
        if (name == null) {
            return Collections.emptyList();
        }
        String[] parts = name.split("\\.");
        List<TypeElement> types = this.schemaObj.getTypes();
        block0: for (String part : parts) {
            for (TypeElement type : types) {
                if (!type.getName().equals(part)) continue;
                typeElems.add(type);
                types = type.getNestedTypes();
                continue block0;
            }
        }
        return typeElems;
    }

    public static String toMapEntry(String s2) {
        if (s2.contains("_")) {
            s2 = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s2);
        }
        return s2 + MAP_ENTRY_SUFFIX;
    }

    public static String toMapField(String s2) {
        CharSequence[] parts = s2.split("\\.");
        String lastPart = parts[parts.length - 1];
        if (lastPart.endsWith(MAP_ENTRY_SUFFIX)) {
            lastPart = lastPart.substring(0, lastPart.length() - MAP_ENTRY_SUFFIX.length());
            lastPart = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, lastPart);
            parts[parts.length - 1] = lastPart;
        }
        return String.join((CharSequence)".", parts);
    }

    @Override
    public Object fromJson(JsonNode json) throws IOException {
        return ProtobufSchemaUtils.toObject(json, this);
    }

    @Override
    public JsonNode toJson(Object message) throws IOException {
        if (message instanceof JsonNode) {
            return (JsonNode)message;
        }
        return JacksonMapper.INSTANCE.readTree(ProtobufSchemaUtils.toJson((Message)message));
    }

    @Override
    public Object copyMessage(Object message) {
        return message;
    }

    @Override
    public Object transformMessage(RuleContext ctx, FieldTransform transform, Object message) throws RuleException {
        try {
            Message msg = (Message)message;
            Descriptors.Descriptor desc = this.toDescriptor(msg.getDescriptorForType().getFullName());
            return this.toTransformedMessage(ctx, desc, msg, transform);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RuleException) {
                throw (RuleException)e.getCause();
            }
            throw e;
        }
    }

    private Object toTransformedMessage(RuleContext ctx, Descriptors.Descriptor desc, Object message, FieldTransform transform) {
        RuleContext.FieldContext fieldCtx = ctx.currentField();
        if (desc == null) {
            return message;
        }
        if (message instanceof List) {
            return ((List)message).stream().map(it -> this.toTransformedMessage(ctx, desc, it, transform)).collect(Collectors.toList());
        }
        if (message instanceof Map) {
            return message;
        }
        if (message instanceof Message) {
            Message.Builder copy = ((Message)message).toBuilder();
            for (Descriptors.FieldDescriptor fd : copy.getDescriptorForType().getFields()) {
                Descriptors.FieldDescriptor schemaFd = desc.findFieldByName(fd.getName());
                RuleContext.FieldContext fc = ctx.enterField(message, fd.getFullName(), fd.getName(), this.getType(fd), this.getInlineTags(schemaFd));
                Throwable throwable = null;
                try {
                    if (fc == null) continue;
                    Object value = copy.getField(fd);
                    Descriptors.Descriptor d = desc;
                    if (schemaFd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                        d = schemaFd.getMessageType();
                    }
                    Object newValue = this.toTransformedMessage(ctx, d, value, transform);
                    if (ctx.rule().getKind() == RuleKind.CONDITION) {
                        if (!Boolean.FALSE.equals(newValue)) continue;
                        throw new RuntimeException(new RuleConditionException(ctx.rule()));
                    }
                    copy.setField(fd, newValue);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fc == null) continue;
                    if (throwable != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fc.close();
                }
            }
            return copy.build();
        }
        if (fieldCtx != null) {
            try {
                SortedSet<String> ruleTags = ctx.rule().getTags();
                if (ruleTags.isEmpty()) {
                    return ProtobufSchema.fieldTransform(ctx, message, transform, fieldCtx);
                }
                if (!RuleContext.disjoint(fieldCtx.getTags(), ruleTags)) {
                    return ProtobufSchema.fieldTransform(ctx, message, transform, fieldCtx);
                }
            }
            catch (RuleException e) {
                throw new RuntimeException(e);
            }
        }
        return message;
    }

    private static Object fieldTransform(RuleContext ctx, Object message, FieldTransform transform, RuleContext.FieldContext fieldCtx) throws RuleException {
        Object result;
        if (message instanceof ByteString) {
            message = ((ByteString)message).toByteArray();
        }
        if ((result = transform.transform(ctx, fieldCtx, message)) instanceof byte[]) {
            result = ByteString.copyFrom((byte[])result);
        }
        return result;
    }

    private RuleContext.Type getType(Descriptors.FieldDescriptor field) {
        if (field.isMapField()) {
            return RuleContext.Type.MAP;
        }
        switch (field.getType()) {
            case MESSAGE: {
                return RuleContext.Type.RECORD;
            }
            case ENUM: {
                return RuleContext.Type.ENUM;
            }
            case STRING: {
                return RuleContext.Type.STRING;
            }
            case BYTES: {
                return RuleContext.Type.BYTES;
            }
            case INT32: 
            case UINT32: 
            case FIXED32: 
            case SFIXED32: {
                return RuleContext.Type.INT;
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: {
                return RuleContext.Type.LONG;
            }
            case FLOAT: {
                return RuleContext.Type.FLOAT;
            }
            case DOUBLE: {
                return RuleContext.Type.DOUBLE;
            }
            case BOOL: {
                return RuleContext.Type.BOOLEAN;
            }
        }
        return RuleContext.Type.NULL;
    }

    @Override
    public Set<String> inlineTags() {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (this.schemaObj == null) {
            return tags;
        }
        ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_FILE_META, this.schemaObj.getOptions());
        if (meta != null && meta.getTags() != null) {
            tags.addAll(meta.getTags());
        }
        for (TypeElement type : this.schemaObj.getTypes()) {
            if (type instanceof MessageElement) {
                this.getInlineTagsRecursively(tags, (MessageElement)type);
                continue;
            }
            if (!(type instanceof EnumElement)) continue;
            this.getInlineTagsRecursively(tags, (EnumElement)type);
        }
        return tags;
    }

    private void getInlineTagsRecursively(Set<String> tags, MessageElement messageElem) {
        ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_MESSAGE_META, messageElem.getOptions());
        if (meta != null && meta.getTags() != null) {
            tags.addAll(meta.getTags());
        }
        for (FieldElement field : messageElem.getFields()) {
            ProtobufMeta fieldMeta = ProtobufSchema.findMeta(CONFLUENT_FIELD_META, field.getOptions());
            if (fieldMeta == null || fieldMeta.getTags() == null) continue;
            tags.addAll(fieldMeta.getTags());
        }
        for (TypeElement type : messageElem.getNestedTypes()) {
            if (type instanceof MessageElement) {
                this.getInlineTagsRecursively(tags, (MessageElement)type);
                continue;
            }
            if (!(type instanceof EnumElement)) continue;
            this.getInlineTagsRecursively(tags, (EnumElement)type);
        }
        for (OneOfElement oneOfElement : messageElem.getOneOfs()) {
            for (FieldElement oneOfField : oneOfElement.getFields()) {
                ProtobufMeta fieldMeta = ProtobufSchema.findMeta(CONFLUENT_FIELD_META, oneOfField.getOptions());
                if (fieldMeta == null || fieldMeta.getTags() == null) continue;
                tags.addAll(fieldMeta.getTags());
            }
        }
    }

    private void getInlineTagsRecursively(Set<String> tags, EnumElement enumElem) {
        ProtobufMeta meta = ProtobufSchema.findMeta(CONFLUENT_ENUM_META, enumElem.getOptions());
        if (meta != null && meta.getTags() != null) {
            tags.addAll(meta.getTags());
        }
        for (EnumConstantElement constant : enumElem.getConstants()) {
            ProtobufMeta constantMeta = ProtobufSchema.findMeta(CONFLUENT_ENUM_VALUE_META, constant.getOptions());
            if (constantMeta == null || constantMeta.getTags() == null) continue;
            tags.addAll(constantMeta.getTags());
        }
    }

    @Override
    public Map<SchemaEntity, Set<String>> inlineTaggedEntities() {
        LinkedHashMap<SchemaEntity, Set<String>> tags = new LinkedHashMap<SchemaEntity, Set<String>>();
        ProtoFileElement schema = this.rawSchema();
        if (schema == null) {
            return tags;
        }
        this.getInlineTaggedEntitiesRecursively(tags, schema.getTypes(), "");
        return tags;
    }

    private void getInlineTaggedEntitiesRecursively(Map<SchemaEntity, Set<String>> tags, List<TypeElement> types, String scope) {
        for (TypeElement type : types) {
            if (!(type instanceof MessageElement)) continue;
            this.getInlineTaggedEntitiesRecursively(tags, (MessageElement)type, scope);
        }
    }

    private void getInlineTaggedEntitiesRecursively(Map<SchemaEntity, Set<String>> tags, MessageElement message, String scope) {
        String scopedName = scope + message.getName();
        Set<String> recordTags = this.getInlineTags(CONFLUENT_MESSAGE_META, message.getOptions());
        if (!recordTags.isEmpty()) {
            tags.put(new SchemaEntity(scopedName, SchemaEntity.EntityType.SR_RECORD), recordTags);
        }
        for (OneOfElement oneOf : message.getOneOfs()) {
            for (FieldElement field : oneOf.getFields()) {
                Set<String> fieldTags = this.getInlineTags(CONFLUENT_FIELD_META, field.getOptions());
                if (fieldTags.isEmpty()) continue;
                tags.put(new SchemaEntity(scopedName + "." + field.getName(), SchemaEntity.EntityType.SR_FIELD), fieldTags);
            }
        }
        for (FieldElement field : message.getFields()) {
            Set<String> fieldTags = this.getInlineTags(CONFLUENT_FIELD_META, field.getOptions());
            if (fieldTags.isEmpty()) continue;
            tags.put(new SchemaEntity(scopedName + "." + field.getName(), SchemaEntity.EntityType.SR_FIELD), fieldTags);
        }
        this.getInlineTaggedEntitiesRecursively(tags, message.getNestedTypes(), scopedName + ".");
    }

    private Set<String> getInlineTags(Descriptors.FieldDescriptor fd) {
        if (fd.getOptions().hasExtension(MetaProto.fieldMeta)) {
            MetaProto.Meta meta = fd.getOptions().getExtension(MetaProto.fieldMeta);
            return new LinkedHashSet<String>(meta.getTagsList());
        }
        return Collections.emptySet();
    }

    private Set<String> getInlineTags(String optionName, List<OptionElement> options) {
        ProtobufMeta meta = ProtobufSchema.findMeta(optionName, options);
        if (meta != null && meta.getTags() != null) {
            return new LinkedHashSet<String>(meta.getTags());
        }
        return Collections.emptySet();
    }

    private void modifySchemaTags(ProtoFileElement original, JsonNode node, Map<SchemaEntity, Set<String>> tagsToAddMap, Map<SchemaEntity, Set<String>> tagsToRemoveMap) {
        LinkedHashSet<SchemaEntity> entityToModify = new LinkedHashSet<SchemaEntity>(tagsToAddMap.keySet());
        entityToModify.addAll(tagsToRemoveMap.keySet());
        HashMap<Object, OptionElement> optionCache = new HashMap<Object, OptionElement>();
        for (SchemaEntity entity : entityToModify) {
            LinkedHashMap<String, List> metaMap;
            Object tagsObj;
            OptionElement metaOptionElement;
            OptionElement cachedOptionElement;
            JsonNode entityNode;
            Object matchingElement;
            String metaName;
            String[] identifiers = entity.getNormalizedPath().split("\\.");
            LinkedList<OptionElement> allOptions = new LinkedList<OptionElement>();
            if (SchemaEntity.EntityType.SR_RECORD == entity.getEntityType()) {
                metaName = CONFLUENT_MESSAGE_META;
                matchingElement = ProtobufSchemaUtils.findMatchingElement(original, identifiers, false);
                MessageElement messageElement = (MessageElement)matchingElement;
                entityNode = ProtobufSchemaUtils.findMatchingNode(node, identifiers, false);
                cachedOptionElement = (OptionElement)optionCache.get(matchingElement);
                if (cachedOptionElement != null) {
                    allOptions.add(cachedOptionElement);
                } else {
                    allOptions.addAll(messageElement.getOptions());
                }
            } else {
                metaName = CONFLUENT_FIELD_META;
                matchingElement = ProtobufSchemaUtils.findMatchingElement(original, identifiers, true);
                FieldElement fieldElement = (FieldElement)matchingElement;
                entityNode = ProtobufSchemaUtils.findMatchingNode(node, identifiers, true);
                cachedOptionElement = (OptionElement)optionCache.get(matchingElement);
                if (cachedOptionElement != null) {
                    allOptions.add(cachedOptionElement);
                } else {
                    allOptions.addAll(fieldElement.getOptions());
                }
            }
            Set<String> tagsToAdd = tagsToAddMap.get(entity);
            if (tagsToAdd != null && !tagsToAdd.isEmpty()) {
                OptionElement newOption = new OptionElement(metaName, OptionElement.Kind.OPTION, new OptionElement(TAGS_FIELD, OptionElement.Kind.LIST, new ArrayList<String>(tagsToAdd), false), true);
                allOptions.add(newOption);
            }
            Map<String, OptionElement> mergedOptions = ProtobufSchema.mergeOptions(allOptions);
            Set<String> tagsToRemove = tagsToRemoveMap.get(entity);
            if (tagsToRemove != null && !tagsToRemove.isEmpty() && (metaOptionElement = mergedOptions.get(metaName)) != null && (tagsObj = (metaMap = new LinkedHashMap<String, List>((Map)metaOptionElement.getValue())).get(TAGS_FIELD)) != null) {
                List allTags = tagsObj instanceof List ? (List)tagsObj : Collections.singletonList(tagsObj);
                List remainingTags = allTags.stream().filter(tag -> !tagsToRemove.contains(tag)).collect(Collectors.toCollection(ArrayList::new));
                if (remainingTags.isEmpty()) {
                    metaMap.remove(TAGS_FIELD);
                } else {
                    metaMap.put(TAGS_FIELD, remainingTags);
                }
                if (metaMap.isEmpty()) {
                    mergedOptions.remove(metaName);
                } else {
                    mergedOptions.put(metaName, new OptionElement(metaName, OptionElement.Kind.MAP, metaMap, true));
                }
            }
            optionCache.put(matchingElement, mergedOptions.get(metaName));
            ((ObjectNode)entityNode).replace("options", (JsonNode)jsonMapper.valueToTree(mergedOptions.values()));
        }
    }

    public static String underscoresToCamelCase(String input, boolean capitalizeNextLetter) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if ('a' <= c && c <= 'z') {
                if (capitalizeNextLetter) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                capitalizeNextLetter = false;
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                if (i == 0 && !capitalizeNextLetter) {
                    result.append(Character.toLowerCase(c));
                } else {
                    result.append(c);
                }
                capitalizeNextLetter = false;
                continue;
            }
            if ('0' <= c && c <= '9') {
                result.append(c);
                capitalizeNextLetter = true;
                continue;
            }
            capitalizeNextLetter = true;
        }
        return result.toString();
    }

    private static List<String> getFieldNames(TypeElement typeElement) {
        if (typeElement instanceof MessageElement) {
            return ((MessageElement)typeElement).getFields().stream().map(FieldElement::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static {
        KNOWN_DEPENDENCIES.put(CFLT_META_LOCATION, CFLT_META_SCHEMA);
        KNOWN_DEPENDENCIES.put(CFLT_DECIMAL_LOCATION, CFLT_DECIMAL_SCHEMA);
        KNOWN_DEPENDENCIES.put(CALENDAR_PERIOD_LOCATION, CALENDAR_PERIOD_SCHEMA);
        KNOWN_DEPENDENCIES.put(COLOR_LOCATION, COLOR_SCHEMA);
        KNOWN_DEPENDENCIES.put(DATE_LOCATION, DATE_SCHEMA);
        KNOWN_DEPENDENCIES.put(DATETIME_LOCATION, DATETIME_SCHEMA);
        KNOWN_DEPENDENCIES.put(DAY_OF_WEEK_LOCATION, DAY_OF_WEEK_SCHEMA);
        KNOWN_DEPENDENCIES.put(DECIMAL_LOCATION, DECIMAL_SCHEMA);
        KNOWN_DEPENDENCIES.put(EXPR_LOCATION, EXPR_SCHEMA);
        KNOWN_DEPENDENCIES.put(FRACTION_LOCATION, FRACTION_SCHEMA);
        KNOWN_DEPENDENCIES.put(INTERVAL_LOCATION, INTERVAL_SCHEMA);
        KNOWN_DEPENDENCIES.put(LATLNG_LOCATION, LATLNG_SCHEMA);
        KNOWN_DEPENDENCIES.put(MONEY_LOCATION, MONEY_SCHEMA);
        KNOWN_DEPENDENCIES.put(MONTH_LOCATION, MONTH_SCHEMA);
        KNOWN_DEPENDENCIES.put(PHONE_NUMBER_LOCATION, PHONE_NUMBER_SCHEMA);
        KNOWN_DEPENDENCIES.put(POSTAL_ADDRESS_LOCATION, POSTAL_ADDRESS_SCHEMA);
        KNOWN_DEPENDENCIES.put(QUATERNION_LOCATION, QUATERNION_SCHEMA);
        KNOWN_DEPENDENCIES.put(TIME_OF_DAY_LOCATION, TIME_OF_DAY_SCHEMA);
        KNOWN_DEPENDENCIES.put(ANY_LOCATION, ANY_SCHEMA);
        KNOWN_DEPENDENCIES.put(API_LOCATION, API_SCHEMA);
        KNOWN_DEPENDENCIES.put(DESCRIPTOR_LOCATION, DESCRIPTOR_SCHEMA);
        KNOWN_DEPENDENCIES.put(DURATION_LOCATION, DURATION_SCHEMA);
        KNOWN_DEPENDENCIES.put(EMPTY_LOCATION, EMPTY_SCHEMA);
        KNOWN_DEPENDENCIES.put(FIELD_MASK_LOCATION, FIELD_MASK_SCHEMA);
        KNOWN_DEPENDENCIES.put(SOURCE_CONTEXT_LOCATION, SOURCE_CONTEXT_SCHEMA);
        KNOWN_DEPENDENCIES.put(STRUCT_LOCATION, STRUCT_SCHEMA);
        KNOWN_DEPENDENCIES.put(TIMESTAMP_LOCATION, TIMESTAMP_SCHEMA);
        KNOWN_DEPENDENCIES.put(TYPE_LOCATION, TYPE_SCHEMA);
        KNOWN_DEPENDENCIES.put(WRAPPER_LOCATION, WRAPPER_SCHEMA);
        base64Encoder = Base64.getEncoder();
        base64Decoder = Base64.getDecoder();
        jsonMapper = JacksonMapper.INSTANCE;
    }

    public static class ProtobufMeta {
        private final String doc;
        private final Map<String, String> params;
        private final List<String> tags;

        public ProtobufMeta(String doc, Map<String, String> params, List<String> tags) {
            this.doc = doc;
            this.params = params;
            this.tags = tags;
        }

        public String getDoc() {
            return this.doc;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public boolean isEmpty() {
            return !(this.doc != null || this.params != null && !this.params.isEmpty() || this.tags != null && !this.tags.isEmpty());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProtobufMeta metadata = (ProtobufMeta)o;
            return Objects.equals(this.doc, metadata.doc) && Objects.equals(this.params, metadata.params) && Objects.equals(this.tags, metadata.tags);
        }

        public int hashCode() {
            return Objects.hash(this.doc, this.params, this.tags);
        }
    }

    public static enum Format {
        DEFAULT("default"),
        IGNORE_EXTENSIONS("ignore_extensions"),
        SERIALIZED("serialized");

        private static final EnumHashBiMap<Format, String> lookup;
        private final String symbol;

        private Format(String symbol) {
            this.symbol = symbol;
        }

        public String symbol() {
            return this.symbol;
        }

        public static Format get(String symbol) {
            return (Format)((Object)lookup.inverse().get(symbol));
        }

        public static Set<String> symbols() {
            return lookup.inverse().keySet();
        }

        public String toString() {
            return this.symbol();
        }

        static {
            lookup = EnumHashBiMap.create(Format.class);
            for (Format type : Format.values()) {
                lookup.put(type, type.symbol());
            }
        }
    }
}

