/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.RetryLoop;
import org.apache.curator.drivers.OperationTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.SetDataBackgroundVersionable;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.VersionPathAndBytesable;
import org.apache.curator.framework.api.transaction.OperationType;
import org.apache.curator.framework.api.transaction.TransactionSetDataBuilder;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.PathAndBytes;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.data.Stat;

public class SetDataBuilderImpl
implements SetDataBuilder,
BackgroundOperation<PathAndBytes>,
ErrorListenerPathAndBytesable<Stat> {
    private final CuratorFrameworkBase client;
    private Backgrounding backgrounding;
    private int version;
    private boolean compress;
    private boolean idempotent = false;
    @VisibleForTesting
    boolean failNextSetForTesting = false;
    @VisibleForTesting
    boolean failBeforeNextSetForTesting = false;
    @VisibleForTesting
    boolean failNextIdempotentCheckForTesting = false;

    SetDataBuilderImpl(CuratorFrameworkBase client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.version = -1;
        this.compress = client.compressionEnabled();
    }

    public SetDataBuilderImpl(CuratorFrameworkBase client, Backgrounding backgrounding, int version, boolean compress) {
        this.client = client;
        this.backgrounding = backgrounding;
        this.version = version;
        this.compress = compress;
    }

    <T> TransactionSetDataBuilder<T> asTransactionSetDataBuilder(final T context, final CuratorMultiTransactionRecord transaction) {
        return new TransactionSetDataBuilder<T>(){
            final /* synthetic */ SetDataBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T forPath(String path, byte[] data) throws Exception {
                if (this.this$0.compress) {
                    data = this.this$0.client.getCompressionProvider().compress(path, data);
                }
                String fixedPath = this.this$0.client.fixForNamespace(path);
                transaction.add(Op.setData((String)fixedPath, (byte[])data, (int)this.this$0.version), OperationType.SET_DATA, path);
                return context;
            }

            @Override
            public T forPath(String path) throws Exception {
                return this.forPath(path, this.this$0.client.getDefaultData());
            }

            @Override
            public PathAndBytesable<T> withVersion(int version) {
                this.this$0.withVersion(version);
                return this;
            }

            @Override
            public VersionPathAndBytesable<T> compressed() {
                this.this$0.compress = true;
                return this;
            }

            @Override
            public VersionPathAndBytesable<T> uncompressed() {
                this.this$0.compress = false;
                return this;
            }
        };
    }

    @Override
    public SetDataBackgroundVersionable compressed() {
        return this.withCompression(true);
    }

    @Override
    public SetDataBackgroundVersionable uncompressed() {
        return this.withCompression(false);
    }

    public SetDataBackgroundVersionable withCompression(boolean compress) {
        this.compress = compress;
        return new SetDataBackgroundVersionable(){

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground() {
                return SetDataBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
                return SetDataBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(Object context) {
                return SetDataBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
                return SetDataBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public Stat forPath(String path, byte[] data) throws Exception {
                return SetDataBuilderImpl.this.forPath(path, data);
            }

            @Override
            public Stat forPath(String path) throws Exception {
                return SetDataBuilderImpl.this.forPath(path);
            }

            @Override
            public BackgroundPathAndBytesable<Stat> withVersion(int version) {
                return SetDataBuilderImpl.this.withVersion(version);
            }
        };
    }

    @Override
    public BackgroundPathAndBytesable<Stat> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public SetDataBuilder idempotent() {
        this.idempotent = true;
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    private void backgroundCheckIdempotent(final CuratorFrameworkBase client, final OperationAndData<PathAndBytes> mainOperationAndData, final String path, final Backgrounding backgrounding) {
        final AsyncCallback.DataCallback dataCallback = new AsyncCallback.DataCallback(){
            final /* synthetic */ SetDataBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                if (rc == KeeperException.Code.OK.intValue()) {
                    if (this.this$0.failNextIdempotentCheckForTesting) {
                        this.this$0.failNextIdempotentCheckForTesting = false;
                        rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                    } else if (!this.this$0.idempotentSetMatches(stat.getVersion(), ((PathAndBytes)mainOperationAndData.getData()).getData(), data)) {
                        rc = KeeperException.Code.BADVERSION.intValue();
                    }
                }
                CuratorEventImpl event = new CuratorEventImpl(client, CuratorEventType.SET_DATA, rc, path, null, ctx, stat, null, null, null, null, null);
                client.processBackgroundOperation(mainOperationAndData, event);
            }
        };
        BackgroundOperation<PathAndBytes> operation = new BackgroundOperation<PathAndBytes>(){
            final /* synthetic */ SetDataBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void performBackgroundOperation(OperationAndData<PathAndBytes> op) throws Exception {
                client.getZooKeeper().getData(path, false, dataCallback, backgrounding.getContext());
            }

            @Override
            public CuratorEventType getBackgroundEventType() {
                return CuratorEventType.SET_DATA;
            }
        };
        client.queueOperation(new OperationAndData<PathAndBytes>(operation, mainOperationAndData));
    }

    @Override
    public CuratorEventType getBackgroundEventType() {
        return CuratorEventType.SET_DATA;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SetDataBuilderImpl-Background");
            final byte[] data = operationAndData.getData().getData();
            this.client.getZooKeeper().setData(operationAndData.getData().getPath(), data, this.version, new AsyncCallback.StatCallback(){
                final /* synthetic */ SetDataBuilderImpl this$0;
                {
                    this.this$0 = this$0;
                }

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    trace.setReturnCode(rc).setRequestBytesLength(data).setPath(path).setStat(stat).commit();
                    if (rc == KeeperException.Code.OK.intValue() && this.this$0.failNextSetForTesting) {
                        this.this$0.failNextSetForTesting = false;
                        rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                    }
                    if (rc == KeeperException.Code.BADVERSION.intValue() && this.this$0.idempotent) {
                        this.this$0.backgroundCheckIdempotent(this.this$0.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), this.this$0.backgrounding);
                    } else {
                        CuratorEventImpl event = new CuratorEventImpl(this.this$0.client, CuratorEventType.SET_DATA, rc, path, null, ctx, stat, null, null, null, null, null);
                        this.this$0.client.processBackgroundOperation(operationAndData, event);
                    }
                }
            }, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    @Override
    public Stat forPath(String path) throws Exception {
        return this.forPath(path, this.client.getDefaultData());
    }

    @Override
    public Stat forPath(String path, byte[] data) throws Exception {
        this.client.getSchemaSet().getSchema(path).validateGeneral(path, data, null);
        if (this.compress) {
            data = this.client.getCompressionProvider().compress(path, data);
        }
        path = this.client.fixForNamespace(path);
        Stat resultStat = null;
        if (this.backgrounding.inBackground()) {
            OperationAndData<PathAndBytes> operationAndData = new OperationAndData<PathAndBytes>((BackgroundOperation)this, new PathAndBytes(path, data), this.backgrounding.getCallback(), null, this.backgrounding.getContext(), null){

                @Override
                void callPerformBackgroundOperation() throws Exception {
                    if (SetDataBuilderImpl.this.failBeforeNextSetForTesting) {
                        SetDataBuilderImpl.this.failBeforeNextSetForTesting = false;
                        throw new KeeperException.ConnectionLossException();
                    }
                    super.callPerformBackgroundOperation();
                }
            };
            this.client.processBackgroundOperation(operationAndData, null);
        } else {
            resultStat = this.pathInForeground(path, data);
        }
        return resultStat;
    }

    int getVersion() {
        return this.version;
    }

    private boolean idempotentSetMatches(int getVersion, byte[] data, byte[] getData) {
        return (this.version == -1 || this.version + 1 == getVersion) && Arrays.equals(data, getData);
    }

    private Stat pathInForeground(final String path, final byte[] data) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SetDataBuilderImpl-Foreground");
        Stat resultStat = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Stat>(){
            final /* synthetic */ SetDataBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Stat call() throws Exception {
                if (this.this$0.failBeforeNextSetForTesting) {
                    this.this$0.failBeforeNextSetForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                Stat localResultStat = null;
                try {
                    localResultStat = this.this$0.client.getZooKeeper().setData(path, data, this.this$0.version);
                }
                catch (KeeperException.BadVersionException e) {
                    if (!this.this$0.idempotent) {
                        throw e;
                    }
                    Stat getStat = new Stat();
                    if (this.this$0.failNextIdempotentCheckForTesting) {
                        this.this$0.failNextIdempotentCheckForTesting = false;
                        throw new KeeperException.ConnectionLossException();
                    }
                    byte[] existingData = this.this$0.client.getZooKeeper().getData(path, false, getStat);
                    if (this.this$0.idempotentSetMatches(getStat.getVersion(), data, existingData)) {
                        localResultStat = getStat;
                    }
                    throw e;
                }
                if (this.this$0.failNextSetForTesting) {
                    this.this$0.failNextSetForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                return localResultStat;
            }
        });
        trace.setRequestBytesLength(data).setPath(path).setStat(resultStat).commit();
        return resultStat;
    }
}

