/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.spark;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.pinot.plugin.ingestion.batch.spark.common.BaseSparkSegmentMetadataPushJobRunner;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.VoidFunction;

public class SparkSegmentMetadataPushJobRunner
extends BaseSparkSegmentMetadataPushJobRunner {
    public SparkSegmentMetadataPushJobRunner() {
    }

    public SparkSegmentMetadataPushJobRunner(SegmentGenerationJobSpec spec) {
        this.init(spec);
    }

    @Override
    public void parallelizeMetadataPushJob(List<String> segmentsToPush, final List<PinotFSSpec> pinotFSSpecs, int pushParallelism, URI outputDirURI) {
        JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)SparkContext.getOrCreate());
        JavaRDD pathRDD = sparkContext.parallelize(segmentsToPush, pushParallelism);
        final URI finalOutputDirURI = outputDirURI;
        pathRDD.foreach((VoidFunction)new VoidFunction<String>(){

            public void call(String segmentTarPath) throws Exception {
                PluginManager.get().init();
                for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
                    PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
                }
                try {
                    Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)finalOutputDirURI, (PushJobSpec)SparkSegmentMetadataPushJobRunner.this._spec.getPushJobSpec(), (String[])new String[]{segmentTarPath});
                    SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)SparkSegmentMetadataPushJobRunner.this._spec, (PinotFS)PinotFSFactory.create((String)finalOutputDirURI.getScheme()), (Map)segmentUriToTarPathMap);
                }
                catch (AttemptsExceededException | RetriableOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

