/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001}4Aa\u0006\r\u0001;!IA\u0005\u0001B\u0001B\u0003%QE\u000e\u0005\u0006o\u0001!\t\u0001\u000f\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u0019!\u0005\u0001)A\u0005}!9Q\t\u0001b\u0001\n\u0013i\u0004B\u0002$\u0001A\u0003%a\bC\u0004H\u0001\t\u0007I\u0011\u0002%\t\r1\u0003\u0001\u0015!\u0003J\u0011\u001di\u0005A1A\u0005\n!CaA\u0014\u0001!\u0002\u0013I\u0005bB(\u0001\u0005\u0004%I\u0001\u0013\u0005\u0007!\u0002\u0001\u000b\u0011B%\t\u000fE\u0003!\u0019!C\u0005\u0011\"1!\u000b\u0001Q\u0001\n%CQa\u0015\u0001\u0005\u0002QCQ!\u001b\u0001\u0005\u0002)DQa\u001b\u0001\u0005\u0002)DQ\u0001\u001c\u0001\u0005\u0002)DQ!\u001c\u0001\u0005\u0002)DQA\u001c\u0001\u0005\u0002=DQ\u0001\u001f\u0001\u0005\u0002eDQA\u001f\u0001\u0005\u0002m\u0014QCR3biV\u0014XmQ8n[\u0006tGm\u00149uS>t7O\u0003\u0002\u001a5\u0005)\u0011\rZ7j]*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\u001b\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0003EA\u000bD_6l\u0017M\u001c3EK\u001a\fW\u000f\u001c;PaRLwN\\:\u0002\t\u0005\u0014xm\u001d\t\u0004M%ZS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u00051\u001adBA\u00172!\tqs%D\u00010\u0015\t\u0001D$\u0001\u0004=e>|GOP\u0005\u0003e\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!gJ\u0005\u0003I\t\na\u0001P5oSRtDCA\u001d<!\tQ\u0004!D\u0001\u0019\u0011\u0015!#\u00011\u0001&\u0003I\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014x\n\u001d;\u0016\u0003y\u00022a\u0010\",\u001b\u0005\u0001%\"A!\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0002D\u0001\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000e\f1CY8piN$(/\u00199TKJ4XM](qi\u0002\n\u0001cY8n[\u0006tGmQ8oM&<w\n\u001d;\u0002#\r|W.\\1oI\u000e{gNZ5h\u001fB$\b%A\u0006eKN\u001c'/\u001b2f\u001fB$X#A%\u0011\u0005}R\u0015BA&A\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\rI\u0016\u001c8M]5cK>\u0003H\u000fI\u0001\u000ekB<'/\u00193f\u00032dw\n\u001d;\u0002\u001dU\u0004xM]1eK\u0006cGn\u00149uA\u0005yAm\\<oOJ\fG-Z!mY>\u0003H/\u0001\te_^twM]1eK\u0006cGn\u00149uA\u0005IAM]=Sk:|\u0005\u000f^\u0001\u000bIJL(+\u001e8PaR\u0004\u0013a\u00015bgR\u0011Q\u000b\u0017\t\u0003MYK!aV\u0014\u0003\u000f\t{w\u000e\\3b]\")\u0011l\u0004a\u00015\u00069!-^5mI\u0016\u0014\bGA.a!\ryDLX\u0005\u0003;\u0002\u0013!b\u00149uS>t7\u000b]3d!\ty\u0006\r\u0004\u0001\u0005\u0013\u0005D\u0016\u0011!A\u0001\u0006\u0003\u0011'aA0%cE\u00111M\u001a\t\u0003M\u0011L!!Z\u0014\u0003\u000f9{G\u000f[5oOB\u0011aeZ\u0005\u0003Q\u001e\u00121!\u00118z\u0003EA\u0017m\u001d#fg\u000e\u0014\u0018NY3PaRLwN\\\u000b\u0002+\u0006y\u0001.Y:Eef\u0014VO\\(qi&|g.A\niCN,\u0006o\u001a:bI\u0016\fE\u000e\\(qi&|g.A\u000biCN$un\u001e8he\u0006$W-\u00117m\u001fB$\u0018n\u001c8\u0002\u001b\r|W.\\1oI\u000e{gNZ5h+\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003\u0011)H/\u001b7\u000b\u0003U\fAA[1wC&\u0011qO\u001d\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t+\u0005Y\u0013!C2iK\u000e\\\u0017I]4t)\u0005a\bC\u0001\u0014~\u0013\tqxE\u0001\u0003V]&$\b")
public class FeatureCommandOptions
extends CommandDefaultOptions {
    private final ArgumentAcceptingOptionSpec<String> bootstrapServerOpt = this.parser().accepts("bootstrap-server", "REQUIRED: A comma-separated list of host:port pairs to use for establishing the connection to the Kafka cluster.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
    private final ArgumentAcceptingOptionSpec<String> commandConfigOpt = this.parser().accepts("command-config", "Property file containing configs to be passed to Admin Client. This is used with --bootstrap-server option when required.").withOptionalArg().describedAs("command config property file").ofType(String.class);
    private final OptionSpecBuilder describeOpt = this.parser().accepts("describe", "Describe supported and finalized features from a random broker.");
    private final OptionSpecBuilder upgradeAllOpt = this.parser().accepts("upgrade-all", "Upgrades all finalized features to the maximum version levels known to the tool. This command finalizes new features known to the tool that were never finalized previously in the cluster, but it is guaranteed to not delete any existing feature.");
    private final OptionSpecBuilder downgradeAllOpt = this.parser().accepts("downgrade-all", "Downgrades all finalized features to the maximum version levels known to the tool. This command deletes unknown features from the list of finalized features in the cluster, but it is guaranteed to not add a new feature.");
    private final OptionSpecBuilder dryRunOpt = this.parser().accepts("dry-run", "Performs a dry-run of upgrade/downgrade mutations to finalized feature without applying them.");

    private ArgumentAcceptingOptionSpec<String> bootstrapServerOpt() {
        return this.bootstrapServerOpt;
    }

    private ArgumentAcceptingOptionSpec<String> commandConfigOpt() {
        return this.commandConfigOpt;
    }

    private OptionSpecBuilder describeOpt() {
        return this.describeOpt;
    }

    private OptionSpecBuilder upgradeAllOpt() {
        return this.upgradeAllOpt;
    }

    private OptionSpecBuilder downgradeAllOpt() {
        return this.downgradeAllOpt;
    }

    private OptionSpecBuilder dryRunOpt() {
        return this.dryRunOpt;
    }

    public boolean has(OptionSpec<?> builder) {
        return this.options().has(builder);
    }

    public boolean hasDescribeOption() {
        return this.has(this.describeOpt());
    }

    public boolean hasDryRunOption() {
        return this.has(this.dryRunOpt());
    }

    public boolean hasUpgradeAllOption() {
        return this.has(this.upgradeAllOpt());
    }

    public boolean hasDowngradeAllOption() {
        return this.has(this.downgradeAllOpt());
    }

    public Properties commandConfig() {
        if (this.has(this.commandConfigOpt())) {
            return Utils.loadProps(this.options().valueOf(this.commandConfigOpt()));
        }
        return new Properties();
    }

    public String bootstrapServers() {
        return this.options().valueOf(this.bootstrapServerOpt());
    }

    public void checkArgs() {
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(this, "This tool describes and updates finalized features.");
        if (new $colon$colon<Nothing$>((Nothing$)((Object)this.describeOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.upgradeAllOpt()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.downgradeAllOpt()), Nil$.MODULE$))).count((Function1<OptionSpec, Object> & java.io.Serializable & Serializable)builder -> BoxesRunTime.boxToBoolean(this.has(builder))) != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Command must include exactly one action: --describe, --upgrade-all, --downgrade-all.");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServerOpt()}));
        if (this.hasDryRunOption() && !this.hasUpgradeAllOption() && !this.hasDowngradeAllOption()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Command can contain --dry-run option only when either --upgrade-all or --downgrade-all actions are provided.");
        }
    }

    public FeatureCommandOptions(String[] args) {
        super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
        this.options_$eq(this.parser().parse(super.args()));
        this.checkArgs();
    }
}

