/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.metrics.LinuxIoMetricsCollector$;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u000f\u001f\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tm\u0001\u0011)\u0019!C\u0001o!AQ\t\u0001B\u0001B\u0003%\u0001\b\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0001H\u0011!q\u0005A!A!\u0002\u0013A\u0005\"B(\u0001\t\u0003\u0001\u0006b\u0002,\u0001\u0001\u0004%\ta\u0016\u0005\b7\u0002\u0001\r\u0011\"\u0001]\u0011\u0019\u0011\u0007\u0001)Q\u00051\"91\r\u0001a\u0001\n\u00039\u0006b\u00023\u0001\u0001\u0004%\t!\u001a\u0005\u0007O\u0002\u0001\u000b\u0015\u0002-\t\u000f!\u0004\u0001\u0019!C\u0001/\"9\u0011\u000e\u0001a\u0001\n\u0003Q\u0007B\u00027\u0001A\u0003&\u0001\fC\u0004n\u0001\t\u0007I\u0011\u00018\t\re\u0004\u0001\u0015!\u0003p\u0011\u0015Q\b\u0001\"\u0001|\u0011\u0015a\b\u0001\"\u0001|\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u00179q!!\u0004\u001f\u0011\u0003\tyA\u0002\u0004\u001e=!\u0005\u0011\u0011\u0003\u0005\u0007\u001f^!\t!a\u0005\t\u0013\u0005UqC1A\u0005\u0002\u0005]\u0001\u0002CA\u0012/\u0001\u0006I!!\u0007\t\u0013\u0005\u0015rC1A\u0005\u0002\u0005]\u0001\u0002CA\u0014/\u0001\u0006I!!\u0007\u0003/1Kg.\u001e=J_6+GO]5dg\u000e{G\u000e\\3di>\u0014(BA\u0010!\u0003\u001diW\r\u001e:jGNT\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\taJ|7MU8piB\u0011Af\r\b\u0003[E\u0002\"A\f\u0014\u000e\u0003=R!\u0001\r\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0011d%\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a'\u0003\u0011!\u0018.\\3\u0016\u0003a\u0002\"!O\"\u000e\u0003iR!a\u000f\u001f\u0002\u000bU$\u0018\u000e\\:\u000b\u0005ur\u0014AB2p[6|gN\u0003\u0002\"\u007f)\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0013\t!%H\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u00027pO\u001e,'/F\u0001I!\tIE*D\u0001K\u0015\tY\u0015)A\u0003tY\u001a$$.\u0003\u0002N\u0015\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005#N#V\u000b\u0005\u0002S\u00015\ta\u0004C\u0003+\r\u0001\u00071\u0006C\u00037\r\u0001\u0007\u0001\bC\u0003G\r\u0001\u0007\u0001*\u0001\u0007mCN$X\u000b\u001d3bi\u0016l5/F\u0001Y!\t)\u0013,\u0003\u0002[M\t!Aj\u001c8h\u0003Aa\u0017m\u001d;Va\u0012\fG/Z't?\u0012*\u0017\u000f\u0006\u0002^AB\u0011QEX\u0005\u0003?\u001a\u0012A!\u00168ji\"9\u0011\rCA\u0001\u0002\u0004A\u0016a\u0001=%c\u0005iA.Y:u+B$\u0017\r^3Ng\u0002\nqbY1dQ\u0016$'+Z1e\u0005f$Xm]\u0001\u0014G\u0006\u001c\u0007.\u001a3SK\u0006$')\u001f;fg~#S-\u001d\u000b\u0003;\u001aDq!Y\u0006\u0002\u0002\u0003\u0007\u0001,\u0001\tdC\u000eDW\r\u001a*fC\u0012\u0014\u0015\u0010^3tA\u0005\u00012-Y2iK\u0012<&/\u001b;f\u0005f$Xm]\u0001\u0015G\u0006\u001c\u0007.\u001a3Xe&$XMQ=uKN|F%Z9\u0015\u0005u[\u0007bB1\u000f\u0003\u0003\u0005\r\u0001W\u0001\u0012G\u0006\u001c\u0007.\u001a3Xe&$XMQ=uKN\u0004\u0013\u0001\u00029bi\",\u0012a\u001c\t\u0003a^l\u0011!\u001d\u0006\u0003eN\fAAZ5mK*\u0011A/^\u0001\u0004]&|'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qF\u0014A\u0001U1uQ\u0006)\u0001/\u0019;iA\u0005I!/Z1e\u0005f$Xm\u001d\u000b\u00021\u0006QqO]5uK\nKH/Z:\u0002\u0019U\u0004H-\u0019;f-\u0006dW/Z:\u0015\u0007}\f)\u0001E\u0002&\u0003\u0003I1!a\u0001'\u0005\u001d\u0011un\u001c7fC:Da!a\u0002\u0015\u0001\u0004A\u0016a\u00018po\u00061Qo]1cY\u0016$\u0012a`\u0001\u0018\u0019&tW\u000f_%p\u001b\u0016$(/[2t\u0007>dG.Z2u_J\u0004\"AU\f\u0014\u0005]!CCAA\b\u0003E\u0011V)\u0011#`\u0005f#ViU0Q%\u00163\u0015\nW\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?)\u0018\u0001\u00027b]\u001eL1\u0001NA\u000f\u0003I\u0011V)\u0011#`\u0005f#ViU0Q%\u00163\u0015\n\u0017\u0011\u0002%]\u0013\u0016\nV#`\u0005f#ViU0Q%\u00163\u0015\nW\u0001\u0014/JKE+R0C3R+5k\u0018)S\u000b\u001aK\u0005\f\t")
public class LinuxIoMetricsCollector {
    private final Time time;
    private final Logger logger;
    private long lastUpdateMs;
    private long cachedReadBytes;
    private long cachedWriteBytes;
    private final Path path;

    public static String WRITE_BYTES_PREFIX() {
        return LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX();
    }

    public static String READ_BYTES_PREFIX() {
        return LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX();
    }

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    public long lastUpdateMs() {
        return this.lastUpdateMs;
    }

    public void lastUpdateMs_$eq(long x$1) {
        this.lastUpdateMs = x$1;
    }

    public long cachedReadBytes() {
        return this.cachedReadBytes;
    }

    public void cachedReadBytes_$eq(long x$1) {
        this.cachedReadBytes = x$1;
    }

    public long cachedWriteBytes() {
        return this.cachedWriteBytes;
    }

    public void cachedWriteBytes_$eq(long x$1) {
        this.cachedWriteBytes = x$1;
    }

    public Path path() {
        return this.path;
    }

    public synchronized long readBytes() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastUpdateMs()) {
            this.updateValues(curMs);
        }
        return this.cachedReadBytes();
    }

    public synchronized long writeBytes() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastUpdateMs()) {
            this.updateValues(curMs);
        }
        return this.cachedWriteBytes();
    }

    public synchronized boolean updateValues(long now) {
        try {
            this.cachedReadBytes_$eq(-1L);
            this.cachedWriteBytes_$eq(-1L);
            CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.path())).asScala().foreach((Function1<String, Object> & java.io.Serializable & Serializable)line -> {
                LinuxIoMetricsCollector.$anonfun$updateValues$1(this, line);
                return BoxedUnit.UNIT;
            });
            this.lastUpdateMs_$eq(now);
            return true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update IO metrics", t);
            return false;
        }
    }

    public boolean usable() {
        if (this.path().toFile().exists()) {
            return this.updateValues(this.time().milliseconds());
        }
        this.logger().debug(new StringBuilder(56).append("disabling IO metrics collection because ").append(this.path()).append(" does not exist.").toString());
        return false;
    }

    public static final /* synthetic */ void $anonfun$updateValues$1(LinuxIoMetricsCollector $this, String line) {
        if (line.startsWith(LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX())) {
            $this.cachedReadBytes_$eq(new StringOps(Predef$.MODULE$.augmentString(line.substring(new StringOps(Predef$.MODULE$.augmentString(LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX())).size()))).toLong());
            return;
        }
        if (line.startsWith(LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX())) {
            $this.cachedWriteBytes_$eq(new StringOps(Predef$.MODULE$.augmentString(line.substring(new StringOps(Predef$.MODULE$.augmentString(LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX())).size()))).toLong());
        }
    }

    public LinuxIoMetricsCollector(String procRoot, Time time, Logger logger) {
        this.time = time;
        this.logger = logger;
        this.lastUpdateMs = -1L;
        this.cachedReadBytes = 0L;
        this.cachedWriteBytes = 0L;
        this.path = Paths.get(procRoot, "self", "io");
    }
}

