/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\r\u001b\u0001}A\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003?\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t/\u0002\u0011)\u0019!C\u00011\"Aq\f\u0001B\u0001B\u0003%\u0011\fC\u0003a\u0001\u0011\u0005\u0011\r\u0003\u0005i\u0001\t\u0007I\u0011\u0001\u000ej\u0011\u0019I\b\u0001)A\u0005U\"9!\u0010\u0001b\u0001\n\u0013Y\bbBA\u0005\u0001\u0001\u0006I\u0001 \u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\t)\u0002\u0001C!\u0003\u001bAq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002&\u0001!\t%a\n\t\u0011\u00055\u0002\u0001\"\u0001\u001b\u0003\u001bA\u0001\"a\f\u0001\t\u0003Q\u0012Q\u0002\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!a\u0019\u0001\t\u0003\t)G\u0001\fEK\u001a\fW\u000f\u001c;BYR,'/S:s\u001b\u0006t\u0017mZ3s\u0015\tYB$\u0001\u0004tKJ4XM\u001d\u0006\u0002;\u0005)1.\u00194lC\u000e\u00011#\u0002\u0001!M)\u0002\u0004CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\t!$\u0003\u0002*5\ty\u0011\t\u001c;fe&\u001b(/T1oC\u001e,'\u000f\u0005\u0002,]5\tAF\u0003\u0002.9\u0005)Q\u000f^5mg&\u0011q\u0006\f\u0002\b\u0019><w-\u001b8h!\t\tD'D\u00013\u0015\t\u0019D$A\u0004nKR\u0014\u0018nY:\n\u0005U\u0012$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006A2m\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0016\u0003a\u0002\"aJ\u001d\n\u0005iR\"\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\f\u0011dY8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3sA\u0005I1o\u00195fIVdWM]\u000b\u0002}A\u00111fP\u0005\u0003\u00012\u0012\u0011bU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%\u0001\u0003uS6,W#\u0001#\u0011\u0005\u0015sU\"\u0001$\u000b\u00055:%B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011QD\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\r\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003!\u0011'o\\6fe&#W#A*\u0011\u0005\u0005\"\u0016BA+#\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\n1C\u0019:pW\u0016\u0014X\t]8dQN+\b\u000f\u001d7jKJ,\u0012!\u0017\t\u0004Cic\u0016BA.#\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002\";&\u0011aL\t\u0002\u0005\u0019>tw-\u0001\u000bce>\\WM]#q_\u000eD7+\u001e9qY&,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\t\u001cG-\u001a4h!\t9\u0003\u0001C\u00037\u0017\u0001\u0007\u0001\bC\u0003=\u0017\u0001\u0007a\bC\u0003C\u0017\u0001\u0007A\tC\u0003R\u0017\u0001\u00071\u000bC\u0003X\u0017\u0001\u0007\u0011,\u0001\tv]N,g\u000e^%teV\u0003H-\u0019;fgV\t!\u000e\u0005\u0003laJ4X\"\u00017\u000b\u00055t\u0017\u0001B;uS2T\u0011a\\\u0001\u0005U\u00064\u0018-\u0003\u0002rY\n\u0019Q*\u00199\u0011\u0005M$X\"A$\n\u0005U<%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003O]L!\u0001\u001f\u000e\u0003\u0019\u0005cG/\u001a:JgJLE/Z7\u0002#Ut7/\u001a8u\u0013N\u0014X\u000b\u001d3bi\u0016\u001c\b%A\bj]\u001ad\u0017n\u001a5u%\u0016\fX/Z:u+\u0005a\bcA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\ta!\u0019;p[&\u001c'bAA\u0002Y\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0007\u0005\u001daPA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0011S:4G.[4iiJ+\u0017/^3ti\u0002\nQa\u001d;beR$\"!a\u0004\u0011\u0007\u0005\n\t\"C\u0002\u0002\u0014\t\u0012A!\u00168ji\u0006A1\u000f[;uI><h.\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u00037\t\t\u0003E\u0002\"\u0003;I1!a\b#\u0005\u001d\u0011un\u001c7fC:Da!a\t\u0013\u0001\u00041\u0018\u0001D1mi\u0016\u0014\u0018j\u001d:Ji\u0016l\u0017\u0001D2mK\u0006\u0014\b+\u001a8eS:<G\u0003BA\b\u0003SAa!a\u000b\u0014\u0001\u0004\u0011\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0019[\u0006L(-\u001a)s_B\fw-\u0019;f\u0013N\u00148\t[1oO\u0016\u001c\u0018\u0001F2mK\u0006\u0014\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cH/A\u0006tK:$'+Z9vKN$H\u0003BA\b\u0003kAq!a\u000e\u0017\u0001\u0004\tI$A\u000bj]\u001ad\u0017n\u001a5u\u00032$XM]%te&#X-\\:\u0011\u000b\u0005m\u00121\n<\u000f\t\u0005u\u0012q\t\b\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013bAA%E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA'\u0003\u001f\u00121aU3r\u0015\r\tIEI\u0001\rEVLG\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003+\n\t\u0007\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tYfR\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ty&!\u0017\u0003'\u0005cG/\u001a:JgJ\u0014V-];fgR$\u0015\r^1\t\u000f\u0005]r\u00031\u0001\u0002:\u00051\u0002.\u00198eY\u0016\fE\u000e^3s\u0013N\u0014(+Z:q_:\u001cX\r\u0006\u0005\u0002h\u0005M\u00141QAD!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7\u000f\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002r\u0005-$AB#se>\u00148\u000fC\u0004\u0002va\u0001\r!a\u001e\u0002!\u0005dG/\u001a:JgJ\u0014Vm\u001d9p]N,\u0007\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005ut)\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\t)a\u001f\u0003!\u0005cG/\u001a:JgJ\u0014Vm\u001d9p]N,\u0007BBAC1\u0001\u0007A,A\btK:$(I]8lKJ,\u0005o\\2i\u0011\u001d\t9\u0004\u0007a\u0001\u0003s\u0001")
public class DefaultAlterIsrManager
implements AlterIsrManager,
KafkaMetricsGroup {
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final java.util.Map<TopicPartition, AlterIsrItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public java.util.Map<TopicPartition, AlterIsrItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean submit(AlterIsrItem alterIsrItem) {
        void var2_2;
        boolean enqueued = this.unsentIsrUpdates().putIfAbsent(alterIsrItem.topicPartition(), alterIsrItem) == null;
        this.maybePropagateIsrChanges();
        return (boolean)var2_2;
    }

    @Override
    public void clearPending(TopicPartition topicPartition) {
        this.unsentIsrUpdates().remove(topicPartition);
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterIsrItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterIsrItems.append(Predef$.MODULE$.wrapRefArray((Object[])new AlterIsrItem[]{item})));
            this.sendRequest((Seq<AlterIsrItem>)inflightAlterIsrItems.toSeq());
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> "Attempting to clear AlterIsr in-flight flag when no apparent request is in-flight");
        }
    }

    private void sendRequest(Seq<AlterIsrItem> inflightAlterIsrItems) {
        AlterIsrRequestData message = this.buildRequest(inflightAlterIsrItems);
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending AlterIsr to controller ").append(message).toString());
        this.controllerChannelManager().sendRequest(new AlterIsrRequest.Builder(message), new ControllerRequestCompletionHandler(this, message, inflightAlterIsrItems){
            private final /* synthetic */ DefaultAlterIsrManager $outer;
            private final AlterIsrRequestData message$1;
            private final Seq inflightAlterIsrItems$2;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Received AlterIsr response ").append(response).toString());
                try {
                    if (response.authenticationException() != null) {
                        errors = Errors.NETWORK_EXCEPTION;
                    } else if (response.versionMismatch() != null) {
                        errors = Errors.UNSUPPORTED_VERSION;
                    } else {
                        AlterIsrResponse body = (AlterIsrResponse)response.responseBody();
                        errors = this.$outer.handleAlterIsrResponse(body, this.message$1.brokerEpoch(), this.inflightAlterIsrItems$2);
                    }
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (((Object)((Object)Errors.NONE)).equals((Object)((Object)error))) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().schedule("send-alter-isr", (JFunction0$mcV$sp & scala.Serializable)() -> $this.$outer.maybePropagateIsrChanges(), 50L, -1L, TimeUnit.MILLISECONDS);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterIsr to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$1 = message$1;
                this.inflightAlterIsrItems$2 = inflightAlterIsrItems$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$2(kafka.server.DefaultAlterIsrManager$$anon$1 )}, serializedLambda);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private AlterIsrRequestData buildRequest(Seq<AlterIsrItem> inflightAlterIsrItems) {
        void var2_2;
        AlterIsrRequestData message = new AlterIsrRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(this.brokerEpochSupplier().apply$mcJ$sp()).setTopics(new ArrayList<AlterIsrRequestData.TopicData>());
        inflightAlterIsrItems.groupBy((Function1<AlterIsrItem, String> & Serializable & scala.Serializable)x$1 -> x$1.topicPartition().topic()).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)entry -> {
            DefaultAlterIsrManager.$anonfun$buildRequest$2(message, entry);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Errors handleAlterIsrResponse(AlterIsrResponse alterIsrResponse, long sentBrokerEpoch, Seq<AlterIsrItem> inflightAlterIsrItems) {
        AlterIsrResponseData data = alterIsrResponse.data();
        Errors errors = Errors.forCode(data.errorCode());
        if (((Object)((Object)Errors.STALE_BROKER_EPOCH)).equals((Object)errors)) {
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (((Object)((Object)Errors.CLUSTER_AUTHORIZATION_FAILED)).equals((Object)errors)) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> "Broker is not authorized to send AlterIsr to controller", (Function0<Throwable>)(Function0<ApiException> & Serializable & scala.Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterIsr to controller"));
        } else if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            HashMap partitionResponses = new HashMap();
            data.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                Errors error = Errors.forCode(partition.errorCode());
                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Controller successfully handled AlterIsr request for ").append(tp).append(": ").append(partition).toString());
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                    LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(partition.leaderId(), partition.leaderEpoch(), ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.isr()).asScala()).toList().map((Function1<Integer, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(x$2)), List$.MODULE$.canBuildFrom()), partition.currentIsrVersion());
                    partitionResponses.update(tp, package$.MODULE$.Right().apply(newLeaderAndIsr));
                    return;
                }
                partitionResponses.update(tp, package$.MODULE$.Left().apply(error));
            }));
            inflightAlterIsrItems.foreach((Function1<AlterIsrItem, Object> & Serializable & scala.Serializable)inflightAlterIsr -> {
                DefaultAlterIsrManager.$anonfun$handleAlterIsrResponse$8(this, partitionResponses, inflightAlterIsr);
                return BoxedUnit.UNIT;
            });
        } else if (errors != null) {
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Controller returned an unexpected top-level error when handling AlterIsr request: ").append((Object)errors).toString());
        } else {
            throw new MatchError((Object)null);
        }
        return Errors.forCode(data.errorCode());
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(AlterIsrRequestData.TopicData topicPart$1, AlterIsrItem item) {
        return topicPart$1.partitions().add(new AlterIsrRequestData.PartitionData().setPartitionIndex(item.topicPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsr(CollectionConverters$.MODULE$.seqAsJavaListConverter(item.leaderAndIsr().isr().map((Function1<Object, Integer> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1), List$.MODULE$.canBuildFrom())).asJava()).setCurrentIsrVersion(item.leaderAndIsr().zkVersion()));
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(AlterIsrRequestData message$2, Tuple2 entry) {
        AlterIsrRequestData.TopicData topicPart = new AlterIsrRequestData.TopicData().setName((String)entry._1()).setPartitions(new ArrayList<AlterIsrRequestData.PartitionData>());
        message$2.topics().add(topicPart);
        ((IterableLike)entry._2()).foreach((Function1<AlterIsrItem, Object> & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean(DefaultAlterIsrManager.$anonfun$buildRequest$3(topicPart, item)));
    }

    public static final /* synthetic */ void $anonfun$handleAlterIsrResponse$8(DefaultAlterIsrManager $this, scala.collection.mutable.Map partitionResponses$1, AlterIsrItem inflightAlterIsr) {
        if (partitionResponses$1.contains(inflightAlterIsr.topicPartition())) {
            try {
                inflightAlterIsr.callback().apply((Either<Errors, LeaderAndIsr>)partitionResponses$1.apply(inflightAlterIsr.topicPartition()));
            }
            finally {
                $this.unsentIsrUpdates().remove(inflightAlterIsr.topicPartition());
            }
            return;
        }
        $this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterIsr.topicPartition()).append(" was sent but not included in the response").toString());
    }

    public DefaultAlterIsrManager(BrokerToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        AlterIsrManager.$init$(this);
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterIsrItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

