/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public final class LogToolUtils {
    public static final String CONTAINER_ON_NODE_PATTERN = "Container: %s on %s";

    private LogToolUtils() {
    }

    private static byte[] formatContainerLogHeader(String containerId, String nodeId, ContainerLogAggregationType logType, String fileName, String lastModifiedTime, long fileLength) {
        StringBuilder sb = new StringBuilder();
        String containerStr = String.format(CONTAINER_ON_NODE_PATTERN, containerId, nodeId);
        sb.append(containerStr + "\n").append("LogAggregationType: " + (Object)((Object)logType) + "\n").append(StringUtils.repeat("=", containerStr.length()) + "\n").append("LogType:" + fileName + "\n").append("LogLastModifiedTime:" + lastModifiedTime + "\n").append("LogLength:" + fileLength + "\n").append("LogContents:\n");
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static void outputContainerLog(String containerId, String nodeId, String fileName, long fileLength, long outputSize, String lastModifiedTime, InputStream fis, OutputStream os, byte[] buf, ContainerLogAggregationType logType) throws IOException {
        long toSkip = 0L;
        long totalBytesToRead = fileLength;
        long skipAfterRead = 0L;
        if (outputSize < 0L) {
            long absBytes = Math.abs(outputSize);
            if (absBytes < fileLength) {
                toSkip = fileLength - absBytes;
                totalBytesToRead = absBytes;
            }
            IOUtils.skipFully((InputStream)fis, (long)toSkip);
        } else if (outputSize < fileLength) {
            totalBytesToRead = outputSize;
            skipAfterRead = fileLength - outputSize;
        }
        long curRead = 0L;
        long pendingRead = totalBytesToRead - curRead;
        int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
        int len = fis.read(buf, 0, toRead);
        boolean keepGoing = len != -1 && curRead < totalBytesToRead;
        byte[] b = LogToolUtils.formatContainerLogHeader(containerId, nodeId, logType, fileName, lastModifiedTime, fileLength);
        os.write(b, 0, b.length);
        while (keepGoing) {
            os.write(buf, 0, len);
            pendingRead = totalBytesToRead - (curRead += (long)len);
            toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
            len = fis.read(buf, 0, toRead);
            keepGoing = len != -1 && curRead < totalBytesToRead;
        }
        IOUtils.skipFully((InputStream)fis, (long)skipAfterRead);
        os.flush();
    }

    public static void outputContainerLogThroughZeroCopy(String containerId, String nodeId, String fileName, long fileLength, long outputSize, String lastModifiedTime, FileInputStream fis, OutputStream os, ContainerLogAggregationType logType) throws IOException {
        long toSkip = 0L;
        long totalBytesToRead = fileLength;
        if (outputSize < 0L) {
            long absBytes = Math.abs(outputSize);
            if (absBytes < fileLength) {
                toSkip = fileLength - absBytes;
                totalBytesToRead = absBytes;
            }
        } else if (outputSize < fileLength) {
            totalBytesToRead = outputSize;
        }
        byte[] b = LogToolUtils.formatContainerLogHeader(containerId, nodeId, logType, fileName, lastModifiedTime, fileLength);
        os.write(b, 0, b.length);
        if (totalBytesToRead > 0L) {
            FileChannel inputChannel = fis.getChannel();
            WritableByteChannel outputChannel = Channels.newChannel(os);
            long position = toSkip;
            while (totalBytesToRead > 0L) {
                long transferred = inputChannel.transferTo(position, totalBytesToRead, outputChannel);
                totalBytesToRead -= transferred;
                position += transferred;
            }
            os.flush();
        }
    }

    public static PrintStream createPrintStream(String localDir, String nodeId, String containerId) throws IOException {
        PrintStream out = System.out;
        if (localDir != null && !localDir.isEmpty()) {
            Path nodePath = new Path(localDir, LogAggregationUtils.getNodeString(nodeId));
            Files.createDirectories(Paths.get(nodePath.toString(), new String[0]), new FileAttribute[0]);
            Path containerLogPath = new Path(nodePath, containerId);
            out = new PrintStream(containerLogPath.toString(), "UTF-8");
        }
        return out;
    }

    public static ClientResponse getResponseFromNMWebService(Configuration conf, Client webServiceClient, ContainerLogsRequest request, String logFile) {
        WebResource webResource = webServiceClient.resource(WebAppUtils.getHttpSchemePrefix(conf) + request.getNodeHttpAddress());
        return (ClientResponse)webResource.path("ws").path("v1").path("node").path("containers").path(request.getContainerId()).path("logs").path(logFile).queryParam("size", Long.toString(request.getBytes())).accept(new String[]{"text/plain"}).get(ClientResponse.class);
    }
}

