/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.jaxrs.json;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.json.JsonMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.jaxrs.cfg.Annotations;
import org.apache.pinot.shaded.com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import org.apache.pinot.shaded.com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;

public class JsonMapperConfigurator
extends MapperConfiguratorBase<JsonMapperConfigurator, ObjectMapper> {
    private final ReentrantLock _lock = new ReentrantLock();

    public JsonMapperConfigurator(ObjectMapper mapper, Annotations[] defAnnotations) {
        super(mapper, defAnnotations);
    }

    @Override
    public ObjectMapper getConfiguredMapper() {
        return this._mapper;
    }

    @Override
    public ObjectMapper getDefaultMapper() {
        if (this._defaultMapper == null) {
            this._lock.lock();
            try {
                if (this._defaultMapper == null) {
                    this._defaultMapper = new JsonMapper();
                    this._setAnnotations(this._defaultMapper, this._defaultAnnotationsToUse);
                }
            }
            finally {
                this._lock.unlock();
            }
        }
        return this._defaultMapper;
    }

    @Override
    protected ObjectMapper mapper() {
        if (this._mapper == null) {
            this._lock.lock();
            try {
                if (this._mapper == null) {
                    this._mapper = new JsonMapper();
                    this._setAnnotations(this._mapper, this._defaultAnnotationsToUse);
                }
            }
            finally {
                this._lock.unlock();
            }
        }
        return this._mapper;
    }

    @Override
    protected AnnotationIntrospector _resolveIntrospectors(Annotations[] annotationsToUse) {
        ArrayList<AnnotationIntrospector> intr = new ArrayList<AnnotationIntrospector>();
        for (Annotations a : annotationsToUse) {
            if (a == null) continue;
            intr.add(this._resolveIntrospector(a));
        }
        int count = intr.size();
        if (count == 0) {
            return AnnotationIntrospector.nopInstance();
        }
        AnnotationIntrospector curr = (AnnotationIntrospector)intr.get(0);
        int len = intr.size();
        for (int i = 1; i < len; ++i) {
            curr = AnnotationIntrospector.pair(curr, (AnnotationIntrospector)intr.get(i));
        }
        return curr;
    }

    protected AnnotationIntrospector _resolveIntrospector(Annotations ann) {
        switch (ann) {
            case JACKSON: {
                return new JacksonAnnotationIntrospector();
            }
            case JAXB: {
                try {
                    if (this._jaxbIntrospectorClass == null) {
                        this._jaxbIntrospectorClass = JaxbAnnotationIntrospector.class;
                    }
                    return (AnnotationIntrospector)this._jaxbIntrospectorClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate JaxbAnnotationIntrospector: " + e.getMessage(), e);
                }
            }
        }
        throw new IllegalStateException();
    }
}

