/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class BeanPropertySqlParameterSourceFactory
implements SqlParameterSourceFactory {
    private Map<String, Object> staticParameters = Collections.unmodifiableMap(new HashMap());

    public void setStaticParameters(Map<String, Object> staticParameters) {
        this.staticParameters = staticParameters;
    }

    @Override
    public SqlParameterSource createParameterSource(Object input) {
        return new StaticBeanPropertySqlParameterSource(input, this.staticParameters);
    }

    private static final class StaticBeanPropertySqlParameterSource
    extends AbstractSqlParameterSource {
        private final BeanPropertySqlParameterSource input;
        private final Map<String, Object> staticParameters;

        StaticBeanPropertySqlParameterSource(Object input, Map<String, Object> staticParameters) {
            this.input = new BeanPropertySqlParameterSource(input);
            this.staticParameters = staticParameters;
        }

        public Object getValue(String paramName) throws IllegalArgumentException {
            return this.staticParameters.containsKey(paramName) ? this.staticParameters.get(paramName) : this.input.getValue(paramName);
        }

        public boolean hasValue(String paramName) {
            return this.staticParameters.containsKey(paramName) || this.input.hasValue(paramName);
        }
    }
}

