/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.infra.nacos.config;

import java.util.Objects;

public class NacosACMConfig {
    private boolean enabled;
    private String endpoint;
    private String namespace;
    private String accessKey;
    private String secretKey;

    public NacosACMConfig(boolean enabled, String endpoint, String namespace, String accessKey, String secretKey) {
        this.enabled = enabled;
        this.endpoint = endpoint;
        this.namespace = namespace;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        NacosACMConfig that = (NacosACMConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.endpoint, this.namespace, this.accessKey, this.secretKey);
    }

    public String toString() {
        return "NacosACMConfig{enabled=" + this.enabled + ", endpoint='" + this.endpoint + "', namespace='" + this.namespace + "', accessKey='" + this.accessKey + "', secretKey='" + this.secretKey + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean enabled;
        private String endpoint;
        private String namespace;
        private String accessKey;
        private String secretKey;

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public NacosACMConfig build() {
            return new NacosACMConfig(this.enabled, this.endpoint, this.namespace, this.accessKey, this.secretKey);
        }
    }
}

