/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core;

import com.qq.tars.net.core.Processor;
import com.qq.tars.net.core.SessionManager;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.protocol.ProtocolFactory;
import com.qq.tars.net.util.Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class Server {
    private String host = null;
    private int port = 9000;
    private static final int DEFAULT_MAIN_PORT = 9000;
    private ProtocolFactory protocolFactory = null;
    private SelectorManager selectorManager = null;
    private Processor processor = null;
    private Executor threadPool = null;
    private Properties props = new Properties();
    private int minPoolSize = 10;
    private int maxPoolSize = 128;
    private boolean keepAlive = true;
    private boolean udpMode = false;

    public Server(String ip, int port) throws IOException {
        this(ip, port, null, null, false);
    }

    public Server(String ip, int port, boolean udpMode) throws IOException {
        this(ip, port, null, null, udpMode);
    }

    public Server(String ip, int port, ProtocolFactory protocolFactory, Processor processor, boolean udpMode) throws IOException {
        this.initServerConfig();
        this.host = ip;
        this.port = port;
        this.udpMode = udpMode;
        this.protocolFactory = protocolFactory;
        this.processor = processor;
        this.threadPool = new ThreadPoolExecutor(this.minPoolSize, this.maxPoolSize, 120L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(20000));
        this.selectorManager = new SelectorManager(Utils.getSelectorPoolSize(), protocolFactory, this.threadPool, processor, this.keepAlive, "server", this.udpMode);
    }

    public void startUp(String[] args) throws Exception {
        this.startNIOServer();
        if (!this.udpMode) {
            SessionManager.getSessionManager().start();
        }
    }

    protected void startNIOServer() throws Exception {
        int interestKey;
        AbstractSelectableChannel server = null;
        this.selectorManager.start();
        if (this.udpMode) {
            server = DatagramChannel.open();
            ((DatagramChannel)server).socket().bind(new InetSocketAddress(this.host, this.port));
            interestKey = 1;
        } else {
            server = ServerSocketChannel.open();
            ((ServerSocketChannel)server).socket().bind(new InetSocketAddress(this.host, this.port), 1024);
            interestKey = 16;
        }
        ((SelectableChannel)server).configureBlocking(false);
        this.selectorManager.getReactor(0).registerChannel(server, interestKey);
        System.out.println("INFO: NAMI Server started on port " + String.valueOf(this.port) + "...");
    }

    protected void initServerConfig() {
        try {
            this.props.load(Utils.loadConfigFile("server.properties", Server.class));
            this.minPoolSize = Integer.parseInt(this.props.getProperty("nami_min_thread", "10"));
            this.maxPoolSize = Integer.parseInt(this.props.getProperty("nami_max_thread", "128"));
            this.keepAlive = Boolean.parseBoolean(this.props.getProperty("nami_keep_alive", "true"));
        }
        catch (Exception ex) {
            System.out.println("ERROR: Failed to init server config file...");
            ex.printStackTrace();
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public void setProtocolFactory(ProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public static enum ServerConf {
        SERVER_LOCAL_IP,
        SERVER_BIND_PORT,
        SERVER_THREAD_POOL_MAX,
        SERVER_THREAD_POOL_MIN,
        SERVER_KEEP_ALIVE;

    }
}

