/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.config;

import com.alibaba.csp.sentinel.config.SentinelConfigLoader;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public final class SentinelConfig {
    public static final int APP_TYPE_COMMON = 0;
    private static final String CLASSLOADER_CONTEXT = "context";
    private static final Map<String, String> props = new ConcurrentHashMap<String, String>();
    private static int appType = 0;
    private static String appName = "";
    public static final String PROJECT_NAME_PROP_KEY = "project.name";
    public static final String APP_NAME_PROP_KEY = "csp.sentinel.app.name";
    public static final String APP_TYPE_PROP_KEY = "csp.sentinel.app.type";
    public static final String CHARSET = "csp.sentinel.charset";
    public static final String SINGLE_METRIC_FILE_SIZE = "csp.sentinel.metric.file.single.size";
    public static final String TOTAL_METRIC_FILE_COUNT = "csp.sentinel.metric.file.total.count";
    public static final String COLD_FACTOR = "csp.sentinel.flow.cold.factor";
    public static final String STATISTIC_MAX_RT = "csp.sentinel.statistic.max.rt";
    public static final String SPI_CLASSLOADER = "csp.sentinel.spi.classloader";
    public static final String METRIC_FLUSH_INTERVAL = "csp.sentinel.metric.flush.interval";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long DEFAULT_SINGLE_METRIC_FILE_SIZE = 0x3200000L;
    public static final int DEFAULT_TOTAL_METRIC_FILE_COUNT = 6;
    public static final int DEFAULT_COLD_FACTOR = 3;
    public static final int DEFAULT_STATISTIC_MAX_RT = 5000;
    public static final long DEFAULT_METRIC_FLUSH_INTERVAL = 1L;

    private static void resolveAppType() {
        try {
            String type = SentinelConfig.getConfig(APP_TYPE_PROP_KEY);
            if (type == null) {
                appType = 0;
                return;
            }
            appType = Integer.parseInt(type);
            if (appType < 0) {
                appType = 0;
            }
        }
        catch (Exception ex) {
            appType = 0;
        }
    }

    private static void initialize() {
        SentinelConfig.setConfig(CHARSET, DEFAULT_CHARSET);
        SentinelConfig.setConfig(SINGLE_METRIC_FILE_SIZE, String.valueOf(0x3200000L));
        SentinelConfig.setConfig(TOTAL_METRIC_FILE_COUNT, String.valueOf(6));
        SentinelConfig.setConfig(COLD_FACTOR, String.valueOf(3));
        SentinelConfig.setConfig(STATISTIC_MAX_RT, String.valueOf(5000));
        SentinelConfig.setConfig(METRIC_FLUSH_INTERVAL, String.valueOf(1L));
    }

    private static void loadProps() {
        Properties properties = SentinelConfigLoader.getProperties();
        for (Object key : properties.keySet()) {
            SentinelConfig.setConfig((String)key, (String)properties.get(key));
        }
    }

    public static String getConfig(String key) {
        AssertUtil.notNull(key, "key cannot be null");
        return props.get(key);
    }

    public static String getConfig(String key, boolean envVariableKey) {
        String value;
        AssertUtil.notNull(key, "key cannot be null");
        if (envVariableKey && StringUtil.isNotEmpty(value = System.getenv(key))) {
            return value;
        }
        return SentinelConfig.getConfig(key);
    }

    public static void setConfig(String key, String value) {
        AssertUtil.notNull(key, "key cannot be null");
        AssertUtil.notNull(value, "value cannot be null");
        props.put(key, value);
    }

    public static String removeConfig(String key) {
        AssertUtil.notNull(key, "key cannot be null");
        return props.remove(key);
    }

    public static void setConfigIfAbsent(String key, String value) {
        AssertUtil.notNull(key, "key cannot be null");
        AssertUtil.notNull(value, "value cannot be null");
        String v = props.get(key);
        if (v == null) {
            props.put(key, value);
        }
    }

    public static String getAppName() {
        return appName;
    }

    public static int getAppType() {
        return appType;
    }

    public static String charset() {
        return props.get(CHARSET);
    }

    public static long metricLogFlushIntervalSec() {
        String flushIntervalStr = SentinelConfig.getConfig(METRIC_FLUSH_INTERVAL);
        if (flushIntervalStr == null) {
            return 1L;
        }
        try {
            return Long.parseLong(flushIntervalStr);
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse the metricLogFlushInterval fail, use default value: 1", throwable);
            return 1L;
        }
    }

    public static long singleMetricFileSize() {
        try {
            return Long.parseLong(props.get(SINGLE_METRIC_FILE_SIZE));
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse singleMetricFileSize fail, use default value: 52428800", throwable);
            return 0x3200000L;
        }
    }

    public static int totalMetricFileCount() {
        try {
            return Integer.parseInt(props.get(TOTAL_METRIC_FILE_COUNT));
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse totalMetricFileCount fail, use default value: 6", throwable);
            return 6;
        }
    }

    public static int coldFactor() {
        try {
            int coldFactor = Integer.parseInt(props.get(COLD_FACTOR));
            if (coldFactor <= 1) {
                coldFactor = 3;
                RecordLog.warn("cold factor=" + coldFactor + ", should be larger than 1, use default value: " + 3, new Object[0]);
            }
            return coldFactor;
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse coldFactor fail, use default value: 3", throwable);
            return 3;
        }
    }

    public static int statisticMaxRt() {
        String v = props.get(STATISTIC_MAX_RT);
        try {
            if (StringUtil.isEmpty(v)) {
                return 5000;
            }
            return Integer.parseInt(v);
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Invalid statisticMaxRt value: {}, using the default value instead: 5000", v, throwable);
            SentinelConfig.setConfig(STATISTIC_MAX_RT, String.valueOf(5000));
            return 5000;
        }
    }

    private static void resolveAppName() {
        String separator;
        String envKey = SentinelConfig.toEnvKey(APP_NAME_PROP_KEY);
        String n = System.getenv(envKey);
        if (!StringUtil.isBlank(n)) {
            appName = n;
            RecordLog.info("App name resolved from system env {}: {}", envKey, appName);
            return;
        }
        n = props.get(APP_NAME_PROP_KEY);
        if (!StringUtil.isBlank(n)) {
            appName = n;
            RecordLog.info("App name resolved from property {}: {}", APP_NAME_PROP_KEY, appName);
            return;
        }
        n = props.get(PROJECT_NAME_PROP_KEY);
        if (!StringUtil.isBlank(n)) {
            appName = n;
            RecordLog.info("App name resolved from property {}: {}", PROJECT_NAME_PROP_KEY, appName);
            return;
        }
        String command = System.getProperty("sun.java.command");
        if (StringUtil.isBlank(command)) {
            RecordLog.warn("Cannot resolve default appName from property sun.java.command", new Object[0]);
            return;
        }
        if ((command = command.split("\\s")[0]).contains(separator = File.separator)) {
            String[] strs = "\\".equals(separator) ? command.split("\\\\") : command.split(separator);
            command = strs[strs.length - 1];
        }
        if (command.toLowerCase().endsWith(".jar")) {
            command = command.substring(0, command.length() - 4);
        }
        appName = command;
        RecordLog.info("App name resolved from default: {}", appName);
    }

    private static String toEnvKey(String propKey) {
        return propKey.toUpperCase().replace('.', '_');
    }

    public static boolean shouldUseContextClassloader() {
        String classloaderConf = SentinelConfig.getConfig(SPI_CLASSLOADER);
        return CLASSLOADER_CONTEXT.equalsIgnoreCase(classloaderConf);
    }

    private SentinelConfig() {
    }

    static {
        try {
            SentinelConfig.initialize();
            SentinelConfig.loadProps();
            SentinelConfig.resolveAppName();
            SentinelConfig.resolveAppType();
            RecordLog.info("[SentinelConfig] Application type resolved: {}", appType);
        }
        catch (Throwable ex) {
            RecordLog.warn("[SentinelConfig] Failed to initialize", ex);
            ex.printStackTrace();
        }
    }
}

