/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.AbstractRemotingProcessor;
import com.alipay.remoting.CommandCode;
import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.CommandHandler;
import com.alipay.remoting.CommonCommandCode;
import com.alipay.remoting.ProcessorManager;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.RemotingContext;
import com.alipay.remoting.RemotingProcessor;
import com.alipay.remoting.ResponseStatus;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.RpcCommand;
import com.alipay.remoting.rpc.RpcConfigManager;
import com.alipay.remoting.rpc.protocol.RpcCommandCode;
import com.alipay.remoting.rpc.protocol.RpcHeartBeatProcessor;
import com.alipay.remoting.rpc.protocol.RpcRequestProcessor;
import com.alipay.remoting.rpc.protocol.RpcResponseProcessor;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class RpcCommandHandler
implements CommandHandler {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    ProcessorManager processorManager;
    CommandFactory commandFactory;

    public RpcCommandHandler(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
        this.processorManager = new ProcessorManager();
        this.processorManager.registerProcessor(RpcCommandCode.RPC_REQUEST, new RpcRequestProcessor(this.commandFactory));
        this.processorManager.registerProcessor(RpcCommandCode.RPC_RESPONSE, new RpcResponseProcessor());
        this.processorManager.registerProcessor(CommonCommandCode.HEARTBEAT, new RpcHeartBeatProcessor());
        this.processorManager.registerDefaultProcessor(new AbstractRemotingProcessor<RemotingCommand>(){

            @Override
            public void doProcess(RemotingContext ctx, RemotingCommand msg) throws Exception {
                logger.error("No processor available for command code {}, msgId {}", (Object)msg.getCmdCode(), (Object)msg.getId());
            }
        });
    }

    @Override
    public void handleCommand(RemotingContext ctx, Object msg) throws Exception {
        this.handle(ctx, msg);
    }

    private void handle(final RemotingContext ctx, final Object msg) {
        try {
            if (msg instanceof List) {
                Runnable handleTask = new Runnable(){

                    @Override
                    public void run() {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Batch message! size={}", (Object)((List)msg).size());
                        }
                        for (Object m : (List)msg) {
                            RpcCommandHandler.this.process(ctx.clone(), m);
                        }
                    }
                };
                if (RpcConfigManager.dispatch_msg_list_in_default_executor()) {
                    this.processorManager.getDefaultExecutor().execute(handleTask);
                } else {
                    handleTask.run();
                }
            } else {
                this.process(ctx, msg);
            }
        }
        catch (Throwable t) {
            this.processException(ctx, msg, t);
        }
    }

    private void process(RemotingContext ctx, Object msg) {
        try {
            RpcCommand cmd = (RpcCommand)msg;
            RemotingProcessor<?> processor = this.processorManager.getProcessor(cmd.getCmdCode());
            processor.process(ctx, cmd, this.processorManager.getDefaultExecutor());
        }
        catch (Throwable t) {
            this.processException(ctx, msg, t);
        }
    }

    private void processException(RemotingContext ctx, Object msg, Throwable t) {
        if (msg instanceof List) {
            for (Object m : (List)msg) {
                this.processExceptionForSingleCommand(ctx, m, t);
            }
        } else {
            this.processExceptionForSingleCommand(ctx, msg, t);
        }
    }

    private void processExceptionForSingleCommand(RemotingContext ctx, Object msg, Throwable t) {
        RequestCommand cmd;
        final int id = ((RpcCommand)msg).getId();
        String emsg = "Exception caught when processing " + (msg instanceof RequestCommand ? "request, id=" : "response, id=");
        logger.warn(emsg + id, t);
        if (msg instanceof RequestCommand && (cmd = (RequestCommand)msg).getType() != 2 && t instanceof RejectedExecutionException) {
            final ResponseCommand response = (ResponseCommand)this.commandFactory.createExceptionResponse(id, ResponseStatus.SERVER_THREADPOOL_BUSY);
            ctx.getChannelContext().writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Write back exception response done, requestId={}, status={}", (Object)id, (Object)response.getResponseStatus());
                        }
                    } else {
                        logger.error("Write back exception response failed, requestId={}", (Object)id, (Object)future.cause());
                    }
                }
            });
        }
    }

    public void registerProcessor(CommandCode cmd, RemotingProcessor processor) {
        this.processorManager.registerProcessor(cmd, processor);
    }

    @Override
    public void registerDefaultExecutor(ExecutorService executor) {
        this.processorManager.registerDefaultExecutor(executor);
    }

    @Override
    public ExecutorService getDefaultExecutor() {
        return this.processorManager.getDefaultExecutor();
    }
}

