/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;

final class ExpandedFeature
extends AbstractFeature {
    private static final Object[] EMPTY = new Object[0];
    private final AbstractFeature source;
    private final Map<String, Integer> nameToIndex;
    private final Object[][] values;
    final int index;

    private ExpandedFeature(AbstractFeature source, Map<String, Integer> nameToIndex, Object[][] values, int index) {
        super(source.getType());
        this.source = source;
        this.nameToIndex = nameToIndex;
        this.values = values;
        this.index = index;
    }

    static ExpandedFeature[] create(AbstractFeature source, Map<String, Integer> nameToIndex) {
        if (source != null) {
            Object[][] values = new Object[nameToIndex.size()][];
            Arrays.fill((Object[])values, EMPTY);
            int count = 0;
            for (Map.Entry<String, Integer> entry : nameToIndex.entrySet()) {
                int n;
                Object value = source.getPropertyValue(entry.getKey());
                if (value == null) continue;
                int i = entry.getValue();
                if (value instanceof Collection) {
                    Object[] elements = ((Collection)value).toArray();
                    if (elements != null) {
                        values[i] = elements;
                    }
                } else {
                    values[i] = new Object[]{value};
                }
                if ((n = values[i].length) <= count) continue;
                count = n;
            }
            if (count > 1) {
                ExpandedFeature[] features = new ExpandedFeature[count];
                for (int i = 0; i < count; ++i) {
                    features[i] = new ExpandedFeature(source, nameToIndex, values, i);
                }
                return features;
            }
        }
        return null;
    }

    public DefaultFeatureType getType() {
        return this.source.getType();
    }

    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    public void setProperty(Object property) {
        this.source.setProperty(property);
    }

    public Object getPropertyValue(String name) {
        Integer i = this.nameToIndex.get(name);
        if (i == null) {
            return this.source.getPropertyValue(name);
        }
        Object[] elements = this.values[i];
        return this.index < elements.length ? List.of(elements[this.index]) : List.of();
    }

    public Object getValueOrFallback(String name, Object missingPropertyFallback) {
        return this.getPropertyValue(name);
    }

    public void setPropertyValue(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.source.hashCode() + this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExpandedFeature) {
            ExpandedFeature other = (ExpandedFeature)((Object)obj);
            return this.index == other.index && this.source.equals((Object)other.source);
        }
        return false;
    }

    public String toString() {
        return this.source.toString();
    }
}

