/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.acquisition.EnvironmentalRecord;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.Operation;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.acquisition.Requirement;

@XmlType(name="MI_AcquisitionInformation_Type", propOrder={"acquisitionPlans", "acquisitionRequirements", "environmentalConditions", "instruments", "objectives", "operations", "platforms"})
@XmlRootElement(name="MI_AcquisitionInformation")
public class DefaultAcquisitionInformation
extends ISOMetadata
implements AcquisitionInformation {
    private static final long serialVersionUID = 6115581617356679324L;
    private Collection<Plan> acquisitionPlans;
    private Collection<Requirement> acquisitionRequirements;
    private EnvironmentalRecord environmentalConditions;
    private Collection<Instrument> instruments;
    private Collection<Objective> objectives;
    private Collection<Operation> operations;
    private Collection<Platform> platforms;

    public DefaultAcquisitionInformation() {
    }

    public DefaultAcquisitionInformation(AcquisitionInformation object) {
        super(object);
        if (object != null) {
            this.acquisitionPlans = DefaultAcquisitionInformation.copyCollection(object.getAcquisitionPlans(), Plan.class);
            this.acquisitionRequirements = DefaultAcquisitionInformation.copyCollection(object.getAcquisitionRequirements(), Requirement.class);
            this.environmentalConditions = object.getEnvironmentalConditions();
            this.instruments = DefaultAcquisitionInformation.copyCollection(object.getInstruments(), Instrument.class);
            this.objectives = DefaultAcquisitionInformation.copyCollection(object.getObjectives(), Objective.class);
            this.operations = DefaultAcquisitionInformation.copyCollection(object.getOperations(), Operation.class);
            this.platforms = DefaultAcquisitionInformation.copyCollection(object.getPlatforms(), Platform.class);
        }
    }

    public static DefaultAcquisitionInformation castOrCopy(AcquisitionInformation object) {
        if (object == null || object instanceof DefaultAcquisitionInformation) {
            return (DefaultAcquisitionInformation)object;
        }
        return new DefaultAcquisitionInformation(object);
    }

    @XmlElement(name="acquisitionPlan")
    public Collection<Plan> getAcquisitionPlans() {
        this.acquisitionPlans = this.nonNullCollection(this.acquisitionPlans, Plan.class);
        return this.acquisitionPlans;
    }

    public void setAcquisitionPlans(Collection<? extends Plan> newValues) {
        this.acquisitionPlans = this.writeCollection(newValues, this.acquisitionPlans, Plan.class);
    }

    @XmlElement(name="acquisitionRequirement")
    public Collection<Requirement> getAcquisitionRequirements() {
        this.acquisitionRequirements = this.nonNullCollection(this.acquisitionRequirements, Requirement.class);
        return this.acquisitionRequirements;
    }

    public void setAcquisitionRequirements(Collection<? extends Requirement> newValues) {
        this.acquisitionRequirements = this.writeCollection(newValues, this.acquisitionRequirements, Requirement.class);
    }

    @XmlElement(name="environmentalConditions")
    public EnvironmentalRecord getEnvironmentalConditions() {
        return this.environmentalConditions;
    }

    public void setEnvironmentalConditions(EnvironmentalRecord newValue) {
        this.checkWritePermission(this.environmentalConditions);
        this.environmentalConditions = newValue;
    }

    @XmlElement(name="instrument")
    public Collection<Instrument> getInstruments() {
        this.instruments = this.nonNullCollection(this.instruments, Instrument.class);
        return this.instruments;
    }

    public void setInstruments(Collection<? extends Instrument> newValues) {
        this.instruments = this.writeCollection(newValues, this.instruments, Instrument.class);
    }

    @XmlElement(name="objective")
    public Collection<Objective> getObjectives() {
        this.objectives = this.nonNullCollection(this.objectives, Objective.class);
        return this.objectives;
    }

    public void setObjectives(Collection<? extends Objective> newValues) {
        this.objectives = this.writeCollection(newValues, this.objectives, Objective.class);
    }

    @XmlElement(name="operation")
    public Collection<Operation> getOperations() {
        this.operations = this.nonNullCollection(this.operations, Operation.class);
        return this.operations;
    }

    public void setOperations(Collection<? extends Operation> newValues) {
        this.operations = this.writeCollection(newValues, this.operations, Operation.class);
    }

    @XmlElement(name="platform")
    public Collection<Platform> getPlatforms() {
        this.platforms = this.nonNullCollection(this.platforms, Platform.class);
        return this.platforms;
    }

    public void setPlatforms(Collection<? extends Platform> newValues) {
        this.platforms = this.writeCollection(newValues, this.platforms, Platform.class);
    }
}

